/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public abstract class SortCategoryAbstractPlugIn
extends AbstractPlugIn
implements ActionListener {
    protected static final ImageIcon ICON = null;
    protected String menuLabelOnLayer = "Sort Selected Categories";
    protected static final String I18N_SORT_MENU_LABEL = "org.openjump.core.ui.plugin.layer.SortCategoryAbstractPlugIn.Sort-Selected-Categories";
    private String labelSelected;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.menuLabelOnLayer = I18N.getInstance().get(I18N_SORT_MENU_LABEL);
        this.addMenuOptions(context);
        this.addActionListenersToMenu(context);
    }

    protected abstract void addMenuOptions(PlugInContext var1);

    private void addActionListenersToMenu(PlugInContext context) {
        JMenu menu = context.getFeatureInstaller().menuBarMenu(MenuNames.LAYER);
        for (int j = 0; j < menu.getItemCount(); ++j) {
            int k;
            JMenu submenu;
            if (menu.getItem(j) == null || !menu.getItem(j).getText().equals(this.menuLabelOnLayer)) continue;
            try {
                submenu = (JMenu)menu.getItem(j);
                for (k = 0; k < submenu.getItemCount(); ++k) {
                    if (!submenu.getItem(k).getText().equals(this.getSubMenuLabel())) continue;
                    submenu = (JMenu)submenu.getItem(k);
                    break;
                }
            }
            catch (ClassCastException cexc) {
                context.getWorkbenchContext().getErrorHandler().handleThrowable(new Exception("Menuitem is an unexpected object type."));
                return;
            }
            for (k = 0; k < submenu.getItemCount(); ++k) {
                submenu.getItem(k).addActionListener(this);
            }
            break;
        }
    }

    protected final String[] getMenuLocation(String submenuLabel) {
        return new String[]{MenuNames.LAYER, this.menuLabelOnLayer, submenuLabel};
    }

    protected abstract String getSubMenuLabel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            this.reportNothingToUndoYet(context);
            LayerManager layerManager = context.getWorkbenchContext().getLayerManager();
            ArrayList selectedCategories = null;
            try {
                selectedCategories = (ArrayList)context.getWorkbenchContext().getLayerNamePanel().getSelectedCategories();
            }
            catch (ClassCastException e) {
                context.getWorkbenchContext().getErrorHandler().handleThrowable(new Exception("Categories is an unexpected object type."));
                return false;
            }
            try {
                for (Category category : selectedCategories) {
                    ArrayList<Layerable> layers = this.getOrderedLayersInCategory(category, this.labelSelected);
                    this.removeLayers(category, layers);
                    this.addLayers(category, layers);
                    for (Layerable layerable : layers) {
                        layerManager.fireLayerChanged(layerable, LayerEventType.METADATA_CHANGED);
                    }
                }
            }
            finally {
                context.getLayerViewPanel().repaint();
                context.getWorkbenchFrame().repaint();
            }
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("Error: see output window");
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText(this.getName() + " PlugIn Exception:" + e.toString());
            return false;
        }
    }

    private void addLayers(Category category, ArrayList<Layerable> layers) {
        for (Layerable layerable : layers) {
            category.add(0, layerable);
        }
    }

    private void removeLayers(Category category, ArrayList<Layerable> layers) {
        for (Layerable layerable : layers) {
            category.remove(layerable);
        }
    }

    abstract ArrayList<Layerable> getOrderedLayersInCategory(Category var1, String var2);

    protected ArrayList<Layerable> getCategoryArrayList(Category category) {
        List<Layerable> categoryList = category.getLayerables();
        ArrayList<Layerable> categoryOrderedList = new ArrayList<Layerable>();
        for (Layerable layer : categoryList) {
            categoryOrderedList.add(layer);
        }
        return categoryOrderedList;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event != null) {
            this.labelSelected = event.getActionCommand();
        }
    }

    class LayerableNameSort
    implements Comparator<Layerable> {
        LayerableNameSort() {
        }

        @Override
        public int compare(Layerable layer1, Layerable layer2) {
            return layer2.getName().compareTo(layer1.getName());
        }
    }
}

