/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;

public class ExtractLayerInFence
extends AbstractPlugIn {
    private static final String EXTRACT_LAYER_IN_FENCE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayerInFence.Extract-Layer-in-Fence");
    public static final ImageIcon ICON = IconLoader.icon("extract1.gif");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.EXTRACT}, this.getName(), false, ICON, ExtractLayerInFence.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createFenceMustBeDrawnCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] layers = context.getWorkbenchContext().getLayerableNamePanel().getSelectedLayers();
        if (layers.length > 0) {
            Layer layer = layers[0];
            this.splitLayer(context, layer);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return EXTRACT_LAYER_IN_FENCE;
    }

    private void splitLayer(PlugInContext context, Layer layer) {
        Geometry fence = context.getLayerViewPanel().getFence();
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List<Feature> featureList = featureCollection.getFeatures();
        FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        boolean wasFiringEvents = context.getLayerManager().isFiringEvents();
        Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        context.getLayerManager().setFiringEvents(true);
        Layer fencedLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : ((Object)selectedCategories.iterator().next()).toString(), layer.getName(), new FeatureDataset(featureSchema));
        FeatureCollectionWrapper fencedFeatureCollection = fencedLayer.getFeatureCollectionWrapper();
        context.getLayerManager().setFiringEvents(false);
        for (Feature feature : featureList) {
            Geometry geometry = feature.getGeometry();
            if (geometry.isEmpty() || fence == null || !geometry.intersects(fence)) continue;
            fencedFeatureCollection.add(feature.clone());
        }
        context.getLayerManager().setFiringEvents(wasFiringEvents);
        context.getLayerViewPanel().repaint();
    }
}

