/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerView;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.model.TaskEvent;
import org.openjump.core.model.TaskListener;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.ui.plugin.file.FindFile;
import org.openjump.core.ui.plugin.file.OpenProjectPlugIn;
import org.openjump.core.ui.plugin.file.OpenRecentPlugIn;
import org.openjump.core.ui.plugin.file.open.SelectProjectFilesPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;
import org.openjump.util.metaData.MetaInformationHandler;

public class OpenProjectWizard
extends AbstractWizardGroup {
    public static final String KEY = OpenProjectWizard.class.getName();
    public static final String FILE_CHOOSER_DIRECTORY_KEY = KEY + " - FILE CHOOSER DIRECTORY";
    private WorkbenchContext workbenchContext;
    private SelectProjectFilesPanel selectProjectPanel;
    private Task sourceTask;
    private Task newTask;
    private File[] files;
    private Envelope savedTaskEnvelope = null;
    private boolean initialized = false;

    public OpenProjectWizard(WorkbenchContext workbenchContext) {
        super(I18N.getInstance().get(KEY), OpenProjectPlugIn.ICON, SelectProjectFilesPanel.KEY);
        this.workbenchContext = workbenchContext;
    }

    public OpenProjectWizard(WorkbenchContext workbenchContext, File[] files) {
        this.workbenchContext = workbenchContext;
        this.files = files;
    }

    @Override
    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        if (this.initialized) {
            return;
        }
        this.selectProjectPanel = new SelectProjectFilesPanel(workbenchContext);
        this.selectProjectPanel.setDialog(dialog);
        this.addPanel(this.selectProjectPanel);
        this.initialized = true;
    }

    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) throws Exception {
        File[] selectedFiles = this.files != null ? this.files : this.selectProjectPanel.getSelectedFiles();
        this.open(selectedFiles, monitor);
    }

    private void open(File[] files, TaskMonitor monitor) throws Exception {
        for (File file : files) {
            this.open(file, monitor);
        }
    }

    public void open(File file, TaskMonitor monitor) throws Exception {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        blackboard.put(FILE_CHOOSER_DIRECTORY_KEY, file.getAbsoluteFile().getParent());
        WorkbenchFrame workbenchFrame = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
            workbenchFrame = workbench.getFrame();
            PlugInManager plugInManager = workbench.getPlugInManager();
            ClassLoader pluginClassLoader = plugInManager.getClassLoader();
            this.sourceTask = (Task)new XML2Java(pluginClassLoader).read(inputStream, Task.class);
            this.initializeDataSources(this.sourceTask, workbenchFrame.getContext());
            this.newTask = new Task();
            this.newTask.setName(GUIUtil.nameWithoutExtension(file));
            this.newTask.setProjectFile(file);
            this.newTask.setProperties(this.sourceTask.getProperties());
            this.newTask.setTaskWindowLocation(this.sourceTask.getTaskWindowLocation());
            this.newTask.setTaskWindowSize(this.sourceTask.getTaskWindowSize());
            this.newTask.setMaximized(this.sourceTask.getMaximized());
            this.newTask.setSavedViewEnvelope(this.sourceTask.getSavedViewEnvelope());
            TaskFrame frame = workbenchFrame.addTaskFrame(this.newTask);
            Dimension size = this.newTask.getTaskWindowSize();
            if (size != null) {
                frame.setSize(size);
            }
            if (this.newTask.getMaximized()) {
                frame.setMaximum(true);
            }
            this.savedTaskEnvelope = this.newTask.getSavedViewEnvelope();
            LayerManager sourceLayerManager = this.sourceTask.getLayerManager();
            LayerManager newLayerManager = this.newTask.getLayerManager();
            CoordinateSystemRegistry crsRegistry = CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard());
            this.workbenchContext.getLayerViewPanel().setDeferLayerEvents(true);
            this.loadLayers(sourceLayerManager, newLayerManager, crsRegistry, monitor);
            this.workbenchContext.getLayerViewPanel().setDeferLayerEvents(false);
            OpenRecentPlugIn.get(this.workbenchContext).addRecentProject(file);
        }
        catch (ClassNotFoundException e) {
            Logger.error(file.getPath() + " can not be loaded", e);
            workbenchFrame.warnUser("Missing class: " + e.getCause());
        }
        catch (Exception cause) {
            Exception e = new Exception(I18N.getInstance().get(KEY + ".could-not-open-project-file-{0}-with-error-{1}", file, cause.getLocalizedMessage()), cause);
            monitor.report(e);
            throw e;
        }
    }

    private void initializeDataSources(Task task, WorkbenchContext context) {
        LayerManager layerManager = task.getLayerManager();
        List<Layer> layers = layerManager.getLayers();
        ArrayList<Layer> layersToBeRemoved = new ArrayList<Layer>();
        for (Layer layer : layers) {
            if (layer instanceof LayerView) continue;
            DataSourceQuery dataSourceQuery = layer.getDataSourceQuery();
            DataSource dataSource = dataSourceQuery.getDataSource();
            if (dataSource == null) {
                context.getWorkbench().getFrame().warnUser(I18N.getInstance().get(KEY + ".datasource-not-found", layer.getName()));
                layerManager.remove(layer);
                continue;
            }
            if (!(dataSource instanceof WorkbenchContextReference)) continue;
            try {
                WorkbenchContextReference workbenchRef = (WorkbenchContextReference)((Object)dataSource);
                workbenchRef.setWorkbenchContext(context);
            }
            catch (Exception e) {
                int response = JOptionPane.showConfirmDialog(this.workbenchContext.getWorkbench().getFrame(), "<html>" + I18N.getInstance().get(KEY + ".opening-datasource-{0}-failed-with-error", layer.getName()) + "<br>" + StringUtil.split(e.getLocalizedMessage(), 80).replaceAll("\n", "<br>") + "<br>" + I18N.getInstance().get(KEY + ".click-yes-to-continue-or-no-to-remove-layer") + "</html>", "OpenJUMP", 0, 2);
                if (response == 0) continue;
                layersToBeRemoved.add(layer);
            }
        }
        for (Layer layer : layersToBeRemoved) {
            layerManager.remove(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLayers(LayerManager sourceLayerManager, LayerManager newLayerManager, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame workbenchFrame = workbench.getFrame();
        FindFile findFile = new FindFile(workbenchFrame);
        boolean displayDialog = true;
        boolean findFiles = false;
        String oldProjectPath = (String)this.sourceTask.getProperty(new QName("Project File"));
        boolean updateResources = false;
        boolean updateOnlyMissingResources = false;
        File oldProjectFile = null;
        if (oldProjectPath != null && !oldProjectPath.equals("") && !(oldProjectFile = new File(oldProjectPath)).equals(this.newTask.getProjectFile())) {
            JCheckBox checkbox = new JCheckBox(I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.Only-for-missing-resources"));
            String message = I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.The-project-has-been-moved-Do-you-want-to-update-paths-below-the-project-folder");
            Object[] params = new Object[]{message, checkbox};
            int answer = JOptionPane.showConfirmDialog(workbenchFrame, params, "OpenJUMP", 0);
            if (answer == 0) {
                updateResources = true;
                if (checkbox.isSelected()) {
                    updateOnlyMissingResources = true;
                }
            }
        }
        try {
            List<Category> categories = sourceLayerManager.getCategories();
            for (Category sourceLayerCategory : categories) {
                newLayerManager.addCategory(sourceLayerCategory.getName());
                ArrayList<Layerable> layerables = new ArrayList<Layerable>(sourceLayerCategory.getLayerables());
                Collections.reverse(layerables);
                for (Layerable layerable : layerables) {
                    block21: {
                        if (monitor != null) {
                            monitor.report(I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.loading") + " " + layerable.getName());
                        }
                        layerable.setLayerManager(newLayerManager);
                        boolean missingDataSource = false;
                        if (!(layerable instanceof LayerView)) {
                            if (layerable instanceof Layer) {
                                Layer layer = (Layer)layerable;
                                File layerFile = this.getLayerFileProperty(layer);
                                if (!(layerFile == null || oldProjectFile == null || layerFile.isAbsolute() && (updateOnlyMissingResources && layerFile.exists() || !updateResources || !this.isLocatedBelow(oldProjectFile.getParentFile(), layerFile)))) {
                                    File newLayerFile = this.updateResourcePath(oldProjectFile, this.newTask.getProjectFile(), layerFile);
                                    this.setLayerFileProperty(layer, newLayerFile);
                                }
                                try {
                                    OpenProjectWizard.load(layer, registry, monitor);
                                }
                                catch (FileNotFoundException ex) {
                                    String fname;
                                    String filename;
                                    DataSourceQuery dataSourceQuery;
                                    DataSource dataSource;
                                    Map<String, Object> properties;
                                    missingDataSource = true;
                                    if (displayDialog) {
                                        displayDialog = false;
                                        int response = JOptionPane.showConfirmDialog(workbenchFrame, I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.At-least-one-file-in-the-task-could-not-be-found") + "\n" + I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.Do-you-want-to-locate-it-and-continue-loading-the-task"), "OpenJUMP", 0);
                                        boolean bl = findFiles = response == 0;
                                    }
                                    if (findFiles && (properties = (dataSource = (dataSourceQuery = layer.getDataSourceQuery()).getDataSource()).getProperties()).get("File") != null && (filename = findFile.getFileName(fname = properties.get("File").toString(), this.newTask.getProjectFile().getParentFile())).length() > 0) {
                                        properties.put("File", filename);
                                        dataSource.setProperties(properties);
                                        OpenProjectWizard.load(layer, registry, monitor);
                                        missingDataSource = false;
                                    }
                                    if (!missingDataSource) break block21;
                                    this.fixupMissingDatasourceLayer(layer);
                                }
                            } else {
                                if (layerable instanceof RasterImageLayer) {
                                    RasterImageLayer rasterImageLayer = (RasterImageLayer)layerable;
                                    OpenProjectWizard.loadRasterImageLayer(this.workbenchContext, rasterImageLayer, rasterImageLayer.getSymbology(), sourceLayerCategory);
                                    continue;
                                }
                                if (layerable instanceof WMSLayer) {
                                    try {
                                        ((WMSLayer)layerable).getService().initialize();
                                    }
                                    catch (Exception e) {
                                        Logger.trace(e);
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                    newLayerManager.addLayerable(sourceLayerCategory.getName(), layerable);
                }
            }
            for (TaskListener taskListener : workbenchFrame.getTaskListeners()) {
                taskListener.taskLoaded(new TaskEvent(this, newLayerManager.getTask()));
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (OpenProjectWizard.this.savedTaskEnvelope == null) {
                            OpenProjectWizard.this.workbenchContext.getLayerViewPanel().getViewport().zoomToFullExtent();
                        } else {
                            OpenProjectWizard.this.workbenchContext.getLayerViewPanel().getViewport().zoom(OpenProjectWizard.this.savedTaskEnvelope);
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("Error finalizing OpenProjectWizard#loadLayers", ex);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public static void load(Layer layer, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        DataSourceQuery dataSourceQuery = layer.getDataSourceQuery();
        String query = dataSourceQuery.getQuery();
        DataSource dataSource = dataSourceQuery.getDataSource();
        FeatureCollection features = OpenProjectWizard.executeQuery(query, dataSource, registry, monitor);
        layer.setFeatureCollection(features);
        layer.setFeatureCollectionModified(false);
    }

    public static void loadRasterImageLayer(WorkbenchContext context, RasterImageLayer ril, RasterSymbology symbology, Category category) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Point point = RasterImageIO.getImageDimensions(ril.getImageFileName());
        Envelope env = RasterImageIO.getGeoReferencing(ril.getImageFileName(), true, point);
        Viewport viewport = context.getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(ril.getImageFileName(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        ril = new RasterImageLayer(ril.getName(), context.getLayerManager(), ril.getImageFileName(), imageAndMetadata.getImage(), env);
        try {
            ril.setSrsInfo(ProjUtils.getSRSInfoFromLayerSource(ril));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Raster raster = ril.getRasterData(null);
        MetaInformationHandler mih = new MetaInformationHandler(ril);
        mih.addMetaInformation(I18N.getInstance().get("file-name"), "");
        mih.addMetaInformation(I18N.getInstance().get("resolution"), raster.getWidth() + " (px) x " + raster.getHeight() + " (px)");
        mih.addMetaInformation(I18N.getInstance().get("real-world-width"), ril.getWholeImageEnvelope().getWidth());
        mih.addMetaInformation(I18N.getInstance().get("real-world-height"), ril.getWholeImageEnvelope().getHeight());
        mih.addMetaInformation("srid", ril.getSrsInfo().getCode());
        if (ril.getSrsInfo().getCode().equals("0")) {
            mih.addMetaInformation("srid-location", "");
        } else {
            mih.addMetaInformation("srid-location", ril.getSrsInfo().getSource());
        }
        context.getLayerManager().addLayerable(category.getName(), ril);
        if (symbology != null) {
            ril.setSymbology(symbology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            FeatureCollection features = connection.executeQuery(query, monitor);
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(features, registry);
            return featureCollection;
        }
    }

    private File updateResourcePath(File oldProjectFile, File newProjectFile, File layerFile) {
        String oldParent = oldProjectFile.getParentFile().getAbsolutePath();
        String newParent = newProjectFile.getParentFile().getAbsolutePath();
        String child = layerFile.isAbsolute() ? layerFile.getAbsolutePath() : new File(oldParent, layerFile.getPath()).getAbsolutePath();
        String relativePath = child.substring(oldParent.length() + 1);
        return new File(newParent, relativePath);
    }

    private boolean isLocatedBelow(File parentDir, File layerFile) {
        if (layerFile == null || parentDir == null) {
            return false;
        }
        Path layerPath = Paths.get(layerFile.getPath(), new String[0]);
        Path parentPath = Paths.get(parentDir.getPath(), new String[0]);
        if (!layerPath.isAbsolute()) {
            return true;
        }
        return layerPath.startsWith(parentPath);
    }

    private File getLayerFileProperty(Layer layer) {
        DataSourceQuery dataSourceQuery = layer.getDataSourceQuery();
        DataSource dataSource = dataSourceQuery.getDataSource();
        Map<String, Object> properties = dataSource.getProperties();
        File layerFile = null;
        if (properties.get("File") != null) {
            layerFile = new File(properties.get("File").toString());
        }
        return layerFile;
    }

    private void setLayerFileProperty(Layer layer, File file) {
        DataSourceQuery dataSourceQuery = layer.getDataSourceQuery();
        DataSource dataSource = dataSourceQuery.getDataSource();
        Map<String, Object> properties = dataSource.getProperties();
        properties.put("File", file.getAbsolutePath());
    }

    private void fixupMissingDatasourceLayer(Layer layer) {
        layer.getDataSourceQuery().getDataSource().setDisabled(true);
        layer.setFeatureCollection(AddNewLayerPlugIn.createBlankFeatureCollection());
    }
}

