/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.io.File;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.plugin.file.OpenRecentPlugIn;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.plugin.file.open.OpenFileWizardState;
import org.openjump.core.ui.plugin.file.open.SelectFileLoaderPanel;
import org.openjump.core.ui.plugin.file.open.SelectFileOptionsPanel;
import org.openjump.core.ui.plugin.file.open.SelectFilesPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;
import org.openjump.util.UriUtil;

public class OpenFileWizard
extends AbstractWizardGroup {
    public static final String KEY = OpenFileWizard.class.getName();
    private OpenFileWizardState state;
    private WorkbenchContext workbenchContext;
    private boolean initialized = false;
    private File[] files;
    private Class loaderFilter = null;
    private ChooseProjectPanel chooseProjectPanel;
    private SelectFilesPanel selectFilesPanel;
    private SelectFileLoaderPanel selectFileLoaderPanel;
    private SelectFileOptionsPanel selectFileOptionsPanel;
    private Layerable layer;

    public Layerable getLayer() {
        return this.layer;
    }

    public void setLayer(Layerable layer) {
        this.layer = layer;
    }

    public OpenFileWizard(WorkbenchContext workbenchContext) {
        super(I18N.getInstance().get(KEY), IconLoader.icon("folder_page.png"), SelectFilesPanel.KEY);
    }

    public OpenFileWizard(WorkbenchContext workbenchContext, File[] files) {
        this.files = files;
    }

    public OpenFileWizard(WorkbenchContext workbenchContext, Class loaderFilter) {
        this.loaderFilter = loaderFilter;
    }

    @Override
    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        if (this.initialized) {
            return;
        }
        this.workbenchContext = workbenchContext;
        this.initPanels(workbenchContext);
        this.state = new OpenFileWizardState(workbenchContext.getErrorHandler());
        Registry registry = workbenchContext.getRegistry();
        List loaders = registry.getEntries(FileLayerLoader.KEY);
        for (FileLayerLoader fileLayerLoader : loaders) {
            if (this.loaderFilter != null && !this.loaderFilter.isInstance(fileLayerLoader)) continue;
            this.state.addFileLoader(fileLayerLoader);
        }
        if (this.selectFilesPanel != null) {
            this.selectFilesPanel.setState(this.state);
            this.selectFilesPanel.setDialog(dialog);
        }
        this.selectFileLoaderPanel.setState(this.state);
        this.selectFileOptionsPanel.setState(this.state);
        if (this.files != null) {
            this.state.setupFileLoaders(this.files, null);
        }
        this.initialized = true;
    }

    protected void initPanels(WorkbenchContext workbenchContext) {
        if (this.selectFileLoaderPanel == null) {
            if (this.files == null) {
                this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, SelectFilesPanel.KEY);
                this.addPanel(this.chooseProjectPanel);
                this.selectFilesPanel = new SelectFilesPanel(workbenchContext, this.loaderFilter);
                this.addPanel(this.selectFilesPanel);
            } else {
                this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, SelectFileLoaderPanel.KEY);
                this.addPanel(this.chooseProjectPanel);
            }
            this.selectFileLoaderPanel = new SelectFileLoaderPanel();
            this.addPanel(this.selectFileLoaderPanel);
            this.selectFileOptionsPanel = new SelectFileOptionsPanel(workbenchContext);
            this.addPanel(this.selectFileOptionsPanel);
        }
    }

    @Override
    public String getFirstId() {
        String firstId = this.files != null ? this.state.getNextPanel(SelectFilesPanel.KEY) : SelectFilesPanel.KEY;
        if (!this.chooseProjectPanel.hasActiveTaskFrame() && this.chooseProjectPanel.hasTaskFrames()) {
            this.chooseProjectPanel.setNextID(firstId);
            return this.chooseProjectPanel.getID();
        }
        return firstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) throws Exception {
        this.chooseProjectPanel.activateSelectedProject();
        LinkedHashSet<File> openedFiles = new LinkedHashSet<File>();
        try {
            monitor.allowCancellationRequests();
            this.workbenchContext.getLayerViewPanel().setDeferLayerEvents(true);
            Map<URI, FileLayerLoader> fileLoaders = this.state.getFileLoaders();
            for (Map.Entry<URI, FileLayerLoader> entry : fileLoaders.entrySet()) {
                URI uri = entry.getKey();
                FileLayerLoader loader = entry.getValue();
                Map<String, Object> options = this.state.getOptions(uri);
                if (this.layer != null) {
                    options.put("LAYER", this.layer);
                }
                try {
                    if (!loader.open(monitor, uri, options)) continue;
                    if (uri.getScheme().equals("zip")) {
                        openedFiles.add(UriUtil.getZipFile(uri));
                        continue;
                    }
                    openedFiles.add(new File(uri));
                }
                catch (Exception e) {
                    this.workbenchContext.getWorkbench().getFrame().handleThrowable(e, dialog);
                }
            }
        }
        finally {
            this.workbenchContext.getLayerViewPanel().setDeferLayerEvents(false);
            this.workbenchContext.getLayerViewPanel().repaint();
            OpenRecentPlugIn recentPlugin = OpenRecentPlugIn.get(this.workbenchContext);
            for (File file : openedFiles) {
                recentPlugin.addRecentFile(file);
            }
        }
    }
}

