/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.List;
import javax.swing.ImageIcon;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;
import org.openjump.core.ui.plugin.file.open.OpenFileWizard;
import org.openjump.core.ui.swing.wizard.WizardGroup;
import org.openjump.core.ui.swing.wizard.WizardGroupDialog;

public class OpenWizardPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String KEY = OpenWizardPlugIn.class.getName();
    private WizardGroupDialog dialog;
    private WizardGroup lastWizard;
    private static ImageIcon icon16 = IconLoader.icon("fugue/folder-horizontal-open_16.png");
    private static ImageIcon icon20 = IconLoader.icon("fugue/folder-horizontal-open_24x20.png");

    public OpenWizardPlugIn() {
        super(I18N.getInstance().get(KEY), icon16);
        this.setShortcutKeys(79);
        this.setShortcutModifiers(128);
    }

    public static void addWizard(WorkbenchContext workbenchContext, WizardGroup wizard) {
        Registry registry = workbenchContext.getRegistry();
        registry.createEntry(KEY, wizard);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame frame = workbench.getFrame();
        String name = this.getName();
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.FILE});
        WorkbenchToolBar toolBar = frame.getToolBar();
        toolBar.addPlugIn(1, this, icon20, this.enableCheck, this.workbenchContext);
        featureInstaller.addPopupMenuPlugin(frame.getCategoryPopupMenu(), this, name, false, icon16, this.enableCheck);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Registry registry = this.workbenchContext.getRegistry();
        WorkbenchFrame workbenchFrame = context.getWorkbenchFrame();
        String name = this.getName();
        if (this.dialog == null) {
            this.dialog = new WizardGroupDialog(this.workbenchContext, workbenchFrame, name);
            List wizards = registry.getEntries(KEY);
            this.lastWizard = (WizardGroup)wizards.get(0);
            for (WizardGroup wizard : wizards) {
                this.dialog.addWizard(wizard);
                if (!(wizard instanceof OpenFileWizard)) continue;
                this.lastWizard = wizard;
            }
        }
        this.dialog.setSelectedWizard(this.lastWizard);
        this.dialog.pack();
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setFocusable(false);
        this.dialog.setVisible(true);
        this.lastWizard = this.dialog.getSelectedWizard();
        return this.dialog.wasFinishPressed();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (this.dialog == null) {
            return;
        }
        WizardGroup wizard = this.dialog.getSelectedWizard();
        wizard.run(this.dialog, monitor);
    }
}

