/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.tab;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.locationtech.jts.util.Assert;

public class ConstraintsOptionsPanel
extends JPanel
implements OptionsPanel {
    private Border titleBorder;
    WorkbenchContext workbenchContext;
    static final String length = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Length");
    static final String incAngle = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Incremental-Angle");
    static final String incAngleShift = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Incremental-Angle-Shift-to-activate");
    static final String angle = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Angle");
    static final String angleShift = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Angle-Shift-to-activate");
    static final String constrainAngleByStepsOf = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Constrain-angle-by-steps-of");
    static final String degree = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.degree");
    static final String negativeNumbersNotAllowedForLength = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.negative-numbers-not-allowed-for-length");
    static final String isToSmall = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.is-too-small-must-be-3-or-greater");
    static final String invalidNumbers = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.invalid-numbers");
    static final String constrainLengthToNearest = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Constrain-length-to-nearest");
    static final String modelUnits = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.model-units");
    static final String ConstrainAngleTo45DegreeIncrements = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Constrain-angle-to-45-degree-increments");
    static final String byDividing360DegreesInto = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.by-dividing-360-degrees-into");
    static final String parts = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.parts");
    static final String constrainToRelativeAngle = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Constrain-to-relative-angle");
    static final String constrainToAbsoluteAngle = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Constrain-to-absolute-angle");
    static final String degrees = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.degrees");
    static final String constrainToAngle = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel.Constrain-to-angle");
    private JPanel constraintsPanel = new JPanel();
    private BorderLayout constraintsBorderLayout = new BorderLayout();
    private GridBagLayout constraintsGridBagLayout = new GridBagLayout();
    private JPanel lengthPanel = new JPanel();
    private JPanel lengthSubPanel = new JPanel();
    private GridBagLayout lengthPanelGridBagLayout = new GridBagLayout();
    private GridBagLayout lengthSubPanelGridBagLayout = new GridBagLayout();
    private TitledBorder lengthPanelTitle = new TitledBorder(this.titleBorder, length);
    private JCheckBox lengthCheckBox = new JCheckBox();
    private JTextField lengthTextField = new JTextField(4);
    private JLabel lengthUnitsLabel = new JLabel();
    private JPanel incrementalAnglePanel = new JPanel();
    private JPanel incrementalAngleSubPanel = new JPanel();
    private GridBagLayout incrementalAnglePanelGridBagLayout = new GridBagLayout();
    private GridBagLayout incrementalAngleSubPanelGridBagLayout = new GridBagLayout();
    private TitledBorder IncrementalAnglePanelTitleShort = new TitledBorder(this.titleBorder, incAngle);
    private TitledBorder IncrementalAnglePanelTitleLong = new TitledBorder(this.titleBorder, incAngleShift);
    private JCheckBox constrainIncrementalAngleCheckBox = new JCheckBox();
    private JTextField numPartsTextField = new JTextField(4);
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private JPanel numPartsPanel = new JPanel();
    private JLabel numPartsPreLabel = new JLabel();
    private JLabel numPartsPostLabel = new JLabel();
    private JPanel anglePanel = new JPanel();
    private TitledBorder anglePanelTitleShort = new TitledBorder(this.titleBorder, angle);
    private TitledBorder anglePanelTitleLong = new TitledBorder(this.titleBorder, angleShift);
    private GridBagLayout AnglePanelGridBagLayout = new GridBagLayout();
    private GridBagLayout angleDataPanelGridBagLayout = new GridBagLayout();
    private JPanel angleDataPanel = new JPanel();
    private JTextField angleConstraintTextField = new JTextField(4);
    private JCheckBox constrainAngleCheckBox = new JCheckBox();
    private JRadioButton relativeAngleRadioButton = new JRadioButton();
    private JRadioButton absoluteAngleRadioButton = new JRadioButton();
    private JLabel angleUnitsLabel = new JLabel();
    private ButtonGroup angleButtonGroup = new ButtonGroup();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JLabel absAngleImageLabel = new JLabel();
    private JLabel relAngleImageLabel = new JLabel();

    public ConstraintsOptionsPanel(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        this.lengthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintsOptionsPanel.this.updateEnabled();
            }
        });
        this.constrainIncrementalAngleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConstraintsOptionsPanel.this.constrainIncrementalAngleCheckBox.isSelected()) {
                    ConstraintsOptionsPanel.this.constrainAngleCheckBox.setSelected(false);
                }
                ConstraintsOptionsPanel.this.updateEnabled();
            }
        });
        this.constrainAngleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConstraintsOptionsPanel.this.constrainAngleCheckBox.isSelected()) {
                    ConstraintsOptionsPanel.this.constrainIncrementalAngleCheckBox.setSelected(false);
                }
                ConstraintsOptionsPanel.this.updateEnabled();
            }
        });
    }

    private void updateEnabled() {
        this.lengthTextField.setEnabled(this.lengthCheckBox.isSelected());
        this.numPartsTextField.setEnabled(this.constrainIncrementalAngleCheckBox.isSelected());
        this.angleConstraintTextField.setEnabled(this.constrainAngleCheckBox.isSelected());
        this.relativeAngleRadioButton.setEnabled(this.constrainAngleCheckBox.isSelected());
        this.absoluteAngleRadioButton.setEnabled(this.constrainAngleCheckBox.isSelected());
        if (this.constrainIncrementalAngleCheckBox.isSelected()) {
            this.incrementalAnglePanel.setBorder(this.IncrementalAnglePanelTitleLong);
        } else {
            this.incrementalAnglePanel.setBorder(this.IncrementalAnglePanelTitleShort);
        }
        if (this.constrainAngleCheckBox.isSelected()) {
            this.anglePanel.setBorder(this.anglePanelTitleLong);
        } else {
            this.anglePanel.setBorder(this.anglePanelTitleShort);
        }
    }

    @Override
    public String validateInput() {
        String errorMessage1 = "\"" + this.lengthTextField.getText() + "\"" + negativeNumbersNotAllowedForLength;
        String errorMessage2 = "\"" + this.numPartsTextField.getText() + "\"" + isToSmall;
        String errorMessage3 = invalidNumbers;
        try {
            if (Double.parseDouble(this.lengthTextField.getText()) < 0.0) {
                return errorMessage1;
            }
            if (Integer.parseInt(this.numPartsTextField.getText()) < 3) {
                return errorMessage2;
            }
        }
        catch (NumberFormatException e) {
            return errorMessage3;
        }
        return null;
    }

    @Override
    public void okPressed() {
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("CONSTRAIN_LENGTH - ENABLED", this.lengthCheckBox.isSelected());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("LENGTH_CONSTRAINT", Double.parseDouble(this.lengthTextField.getText()));
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("CONSTRAIN_INCREMENTAL_ANGLE - ENABLED", this.constrainIncrementalAngleCheckBox.isSelected());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("INCREMENTAL_ANGLE_CONSTRAINT", Integer.parseInt(this.numPartsTextField.getText()));
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("CONSTRAIN_ANGLE - ENABLED", this.constrainAngleCheckBox.isSelected());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("ANGLE_CONSTRAINT", Double.parseDouble(this.angleConstraintTextField.getText()));
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("RELATIVE_ANGLE_CONSTRAINT", this.relativeAngleRadioButton.isSelected());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put("ABSOLUTE_ANGLE_CONSTRAINT", this.absoluteAngleRadioButton.isSelected());
    }

    @Override
    public void init() {
        this.lengthCheckBox.setSelected(PersistentBlackboardPlugIn.get(this.workbenchContext).get("CONSTRAIN_LENGTH - ENABLED", false));
        this.lengthTextField.setText("" + PersistentBlackboardPlugIn.get(this.workbenchContext).get("LENGTH_CONSTRAINT", 0.5));
        this.constrainIncrementalAngleCheckBox.setSelected(PersistentBlackboardPlugIn.get(this.workbenchContext).get("CONSTRAIN_INCREMENTAL_ANGLE - ENABLED", false));
        this.numPartsTextField.setText("" + PersistentBlackboardPlugIn.get(this.workbenchContext).get("INCREMENTAL_ANGLE_CONSTRAINT", 8));
        this.constrainAngleCheckBox.setSelected(PersistentBlackboardPlugIn.get(this.workbenchContext).get("CONSTRAIN_ANGLE - ENABLED", false));
        this.angleConstraintTextField.setText("" + PersistentBlackboardPlugIn.get(this.workbenchContext).get("ANGLE_CONSTRAINT", 30.0));
        this.relativeAngleRadioButton.setSelected(PersistentBlackboardPlugIn.get(this.workbenchContext).get("RELATIVE_ANGLE_CONSTRAINT", true));
        this.absoluteAngleRadioButton.setSelected(PersistentBlackboardPlugIn.get(this.workbenchContext).get("ABSOLUTE_ANGLE_CONSTRAINT", false));
        double newAngle = 360.0 / Double.parseDouble(this.numPartsTextField.getText());
        this.constrainIncrementalAngleCheckBox.setText(constrainAngleByStepsOf + " " + newAngle + " " + degree);
        this.updateEnabled();
    }

    private void jbInit() throws Exception {
        this.titleBorder = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.setLayout(this.constraintsBorderLayout);
        this.add((Component)this.constraintsPanel, "Center");
        this.constraintsPanel.setLayout(this.constraintsGridBagLayout);
        this.lengthPanel.setBorder(this.lengthPanelTitle);
        this.lengthPanel.setLayout(this.lengthPanelGridBagLayout);
        this.lengthSubPanel.setLayout(this.lengthSubPanelGridBagLayout);
        this.lengthTextField.setText("0.5");
        this.lengthTextField.setHorizontalAlignment(11);
        this.lengthCheckBox.setToolTipText("");
        this.lengthCheckBox.setText(constrainLengthToNearest + " ");
        this.lengthUnitsLabel.setText(modelUnits);
        this.constraintsPanel.add((Component)this.lengthPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.lengthPanel.add((Component)this.lengthSubPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lengthSubPanel.add((Component)this.lengthCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lengthSubPanel.add((Component)this.lengthTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.lengthSubPanel.add((Component)this.lengthUnitsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.incrementalAnglePanel.setLayout(this.incrementalAnglePanelGridBagLayout);
        this.incrementalAngleSubPanel.setLayout(this.incrementalAngleSubPanelGridBagLayout);
        this.numPartsTextField.setText("8");
        this.constrainIncrementalAngleCheckBox.setText(ConstrainAngleTo45DegreeIncrements);
        this.constraintsPanel.add((Component)this.incrementalAnglePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 1));
        this.incrementalAnglePanel.add((Component)this.incrementalAngleSubPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.incrementalAngleSubPanel.add((Component)this.constrainIncrementalAngleCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.incrementalAngleSubPanel.add((Component)this.numPartsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.numPartsTextField.setHorizontalAlignment(11);
        this.numPartsTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateAngle();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateAngle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateAngle();
            }

            private void updateAngle() {
                try {
                    double newAngle = Math.rint(3600.0 / Double.parseDouble(ConstraintsOptionsPanel.this.numPartsTextField.getText())) / 10.0;
                    ConstraintsOptionsPanel.this.constrainIncrementalAngleCheckBox.setText(constrainAngleByStepsOf + " " + newAngle + " " + degree);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.numPartsPanel.setLayout(this.gridBagLayout4);
        this.numPartsPreLabel.setText(byDividing360DegreesInto);
        this.numPartsPostLabel.setText(parts);
        this.numPartsPanel.add((Component)this.numPartsPreLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.numPartsPanel.add((Component)this.numPartsTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.numPartsPanel.add((Component)this.numPartsPostLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.anglePanel.setBorder(this.anglePanelTitleShort);
        this.anglePanel.setLayout(this.AnglePanelGridBagLayout);
        this.angleDataPanel.setLayout(this.angleDataPanelGridBagLayout);
        this.constraintsPanel.add((Component)this.anglePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.anglePanel.add((Component)this.angleDataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.angleDataPanel.add((Component)this.constrainAngleCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.angleDataPanel.add((Component)this.angleConstraintTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.angleDataPanel.add((Component)this.relativeAngleRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.angleDataPanel.add((Component)this.relAngleImageLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.relAngleImageLabel.setIcon(new ImageIcon(this.getClass().getResource("relAngle.png")));
        this.angleDataPanel.add((Component)this.absoluteAngleRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.angleDataPanel.add((Component)this.absAngleImageLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.absAngleImageLabel.setIcon(new ImageIcon(this.getClass().getResource("absAngle.png")));
        this.angleDataPanel.add((Component)this.angleUnitsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.relativeAngleRadioButton.setText(constrainToRelativeAngle);
        this.absoluteAngleRadioButton.setText(constrainToAbsoluteAngle);
        this.angleUnitsLabel.setText(degrees);
        this.angleButtonGroup.add(this.relativeAngleRadioButton);
        this.angleButtonGroup.add(this.absoluteAngleRadioButton);
        this.angleConstraintTextField.setText("30");
        this.angleConstraintTextField.setHorizontalAlignment(11);
        this.constrainAngleCheckBox.setText(constrainToAngle);
    }

    public class myFocusListener
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

