/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;

public class RemodelerTool
extends MultiClickTool {
    public RemodelerTool(WorkbenchContext context) {
        super(context);
        this.setColor(Color.red);
        this.setStroke(new BasicStroke(1.5f, 2, 1, 10.0f, new float[]{10.0f, 5.0f}, 0.0f));
        this.allowSnapping();
        this.setMetricsDisplay(new CoordinateListMetrics());
    }

    @Override
    public Icon getIcon() {
        return org.openjump.core.ui.images.IconLoader.icon("Remodeler.png");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.RemodelerTool");
    }

    @Override
    public Cursor getCursor() {
        return RemodelerTool.createCursor(IconLoader.icon("splitPolygonCursor.png").getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws Exception {
        WorkbenchContext context = this.getWorkbench().getContext();
        this.reportNothingToUndoYet();
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        for (Layer activeLayer : selectionManager.getLayersWithSelectedItems()) {
            if (activeLayer.isEditable()) continue;
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("plugin.EnableCheckFactory.selected-items-layers-must-be-editable", 1), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.Information"), 2);
            return;
        }
        for (Layer activeLayer : selectionManager.getLayersWithSelectedItems()) {
            activeLayer.getLayerManager().getUndoableEditReceiver().startReceiving();
            try {
                if (!activeLayer.isEditable()) continue;
                Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(activeLayer);
                EditTransaction transaction = new EditTransaction(new ArrayList<Feature>(), "Re-Model", activeLayer, true, false, context.getLayerViewPanel());
                for (Feature featureSelected : selectedFeatures) {
                    int i;
                    Geometry geomSelected = (Geometry)featureSelected.getGeometry().clone();
                    LineString newPath = this.getLineString();
                    Geometry newGeometry = geomSelected;
                    if (geomSelected.isEmpty() || geomSelected.intersection((Geometry)newPath).getNumPoints() < 2) continue;
                    if (geomSelected.getClass().getSimpleName().equals("GeometryCollection")) {
                        context.getWorkbench().getFrame().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.RemodelerTool.geometrycollection-cannot-be-processed"));
                        continue;
                    }
                    if (!newPath.intersects(geomSelected)) continue;
                    if (geomSelected instanceof MultiPolygon) {
                        Polygon[] polys = new Polygon[geomSelected.getNumGeometries()];
                        for (i = 0; i < geomSelected.getNumGeometries(); ++i) {
                            polys[i] = this.getNewPolygon((Polygon)geomSelected.getGeometryN(i), newPath);
                        }
                        newGeometry = geomSelected.getFactory().createMultiPolygon(polys);
                    } else if (geomSelected instanceof Polygon) {
                        newGeometry = this.getNewPolygon((Polygon)geomSelected, newPath);
                    } else if (geomSelected instanceof MultiLineString) {
                        LineString[] lines = new LineString[geomSelected.getNumGeometries()];
                        for (i = 0; i < geomSelected.getNumGeometries(); ++i) {
                            lines[i] = this.getNewLineString((LineString)geomSelected.getGeometryN(i), newPath);
                        }
                        newGeometry = geomSelected.getFactory().createMultiLineString(lines);
                    } else if (geomSelected instanceof LineString) {
                        newGeometry = this.getNewLineString((LineString)geomSelected, newPath);
                    }
                    transaction.modifyFeatureGeometry(featureSelected, newGeometry);
                }
                transaction.commit();
                activeLayer.getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
            finally {
                activeLayer.getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
        }
    }

    private Polygon getNewPolygon(Polygon selection, LineString newPath) {
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        rings.add(selection.getExteriorRing());
        for (int i = 0; i < selection.getNumInteriorRing(); ++i) {
            rings.add(selection.getInteriorRingN(i));
        }
        boolean intersected = false;
        block1: for (int i = 0; i < newPath.getNumPoints() - 1; ++i) {
            LineString segment = selection.getFactory().createLineString(new Coordinate[]{newPath.getCoordinateN(i), newPath.getCoordinateN(i + 1)});
            if (segment.intersects((Geometry)selection.getExteriorRing())) {
                rings.set(0, this.getNewLinearRing(selection.getExteriorRing(), newPath));
                break;
            }
            for (int j = 0; j < selection.getNumInteriorRing(); ++j) {
                if (segment.intersects((Geometry)selection.getInteriorRingN(j))) {
                    rings.set(j + 1, this.getNewLinearRing(selection.getInteriorRingN(j), newPath));
                    intersected = true;
                    continue block1;
                }
                if (intersected) continue block1;
            }
        }
        LinearRing ext = (LinearRing)rings.get(0);
        rings.remove(0);
        LinearRing[] holes = rings.toArray(new LinearRing[0]);
        return selection.getFactory().createPolygon(ext, holes);
    }

    private LinearRing getNewLinearRing(LinearRing selection, LineString newPath) {
        int i;
        newPath = this.clipNewPath((LineString)selection, newPath);
        LocationIndexedLine selectionIndexedLine = new LocationIndexedLine((Geometry)selection);
        LinearLocation loc1 = selectionIndexedLine.indexOf(newPath.getStartPoint().getCoordinate());
        LinearLocation loc2 = selectionIndexedLine.indexOf(newPath.getEndPoint().getCoordinate());
        newPath.getPointN((int)0).getCoordinate().z = this.interpolateZ(loc1, (LineString)selection);
        newPath.getPointN((int)(newPath.getNumPoints() - 1)).getCoordinate().z = this.interpolateZ(loc2, (LineString)selection);
        this.interpolateZ(newPath);
        LinearLocation locMin = loc1.compareTo((Object)loc2) <= 0 ? loc1 : loc2;
        LinearLocation locMax = loc1.compareTo((Object)loc2) <= 0 ? loc2 : loc1;
        CoordinateList list = new CoordinateList();
        list.add(selectionIndexedLine.extractLine(locMax, selectionIndexedLine.getEndIndex()).getCoordinates(), false);
        list.add(selectionIndexedLine.extractLine(selectionIndexedLine.getStartIndex(), locMin).getCoordinates(), false);
        LineString subLinePassingThrough0 = selection.getFactory().createLineString(list.toCoordinateArray());
        LineString oppositeSubLine = (LineString)selectionIndexedLine.extractLine(locMin, locMax);
        double d1 = DiscreteHausdorffDistance.distance((Geometry)newPath, (Geometry)subLinePassingThrough0);
        double d2 = DiscreteHausdorffDistance.distance((Geometry)newPath, (Geometry)oppositeSubLine);
        if (d1 < d2) {
            int i2;
            if (locMin == loc1) {
                newPath = newPath.reverse();
            }
            list = new CoordinateList();
            for (i2 = 0; i2 < oppositeSubLine.getNumPoints() - 1; ++i2) {
                list.add(oppositeSubLine.getCoordinateN(i2), false);
            }
            for (i2 = 0; i2 < newPath.getNumPoints() - 1; ++i2) {
                list.add(newPath.getCoordinateN(i2), false);
            }
            list.closeRing();
            return selection.getFactory().createLinearRing(list.toCoordinateArray());
        }
        if (locMin == loc2) {
            newPath = newPath.reverse();
        }
        list = new CoordinateList();
        for (i = 0; i < subLinePassingThrough0.getNumPoints() - 1; ++i) {
            list.add(subLinePassingThrough0.getCoordinateN(i), false);
        }
        for (i = 0; i < newPath.getNumPoints() - 1; ++i) {
            list.add(newPath.getCoordinateN(i), false);
        }
        list.closeRing();
        return selection.getFactory().createLinearRing(list.toCoordinateArray());
    }

    private LineString getNewLineString(LineString selection, LineString newPath) {
        LinearLocation loc2;
        LocationIndexedLine selectionIndexedLine = new LocationIndexedLine((Geometry)selection);
        LinearLocation loc1 = selectionIndexedLine.indexOf((newPath = this.clipNewPath(selection, newPath)).getStartPoint().getCoordinate());
        boolean direct = loc1.compareTo((Object)(loc2 = selectionIndexedLine.indexOf(newPath.getEndPoint().getCoordinate()))) <= 0;
        CoordinateList list = new CoordinateList();
        list.add(selectionIndexedLine.extractLine(selectionIndexedLine.getStartIndex(), direct ? loc1 : loc2).getCoordinates(), false);
        if (!direct) {
            newPath = newPath.reverse();
        }
        newPath.getPointN((int)0).getCoordinate().z = this.interpolateZ(direct ? loc1 : loc2, selection);
        newPath.getPointN((int)(newPath.getNumPoints() - 1)).getCoordinate().z = this.interpolateZ(direct ? loc2 : loc1, selection);
        this.interpolateZ(newPath);
        for (int i = 1; i < newPath.getNumPoints() - 1; ++i) {
            list.add(newPath.getCoordinateN(i), false);
        }
        list.add(selectionIndexedLine.extractLine(direct ? loc2 : loc1, selectionIndexedLine.getEndIndex()).getCoordinates(), false);
        return selection.getFactory().createLineString(list.toCoordinateArray());
    }

    private LineString clipNewPath(LineString selection, LineString newPath) {
        Coordinate c1 = this.firstIntersectionAlongNewPath(selection, newPath);
        Coordinate c2 = this.firstIntersectionAlongNewPath(selection, newPath.reverse());
        LocationIndexedLine pathIndexedLine = new LocationIndexedLine((Geometry)newPath);
        return (LineString)pathIndexedLine.extractLine(pathIndexedLine.indexOf(c1), pathIndexedLine.indexOf(c2));
    }

    private Coordinate firstIntersectionAlongNewPath(LineString selection, LineString newPath) {
        for (int i = 0; i < newPath.getNumPoints() - 1; ++i) {
            LineSegment newPathSegment = new LineSegment(newPath.getCoordinateN(i), newPath.getCoordinateN(i + 1));
            double minDist = Double.MAX_VALUE;
            Coordinate intersection = null;
            for (int j = 0; j < selection.getNumPoints() - 1; ++j) {
                double dist;
                LineSegment selectionSegment = new LineSegment(selection.getCoordinateN(j), selection.getCoordinateN(j + 1));
                Coordinate newIntersection = newPathSegment.intersection(selectionSegment);
                if (newIntersection == null || !((dist = newIntersection.distance(newPathSegment.getCoordinate(0))) < minDist)) continue;
                minDist = dist;
                intersection = newIntersection;
            }
            if (intersection == null) continue;
            return intersection;
        }
        return null;
    }

    protected boolean isRollingBackInvalidEdits(WorkbenchContext context) {
        return PersistentBlackboardPlugIn.get(context).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    private LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    private double interpolateZ(LinearLocation loc, LineString lineString) {
        if (loc.getSegmentFraction() == 0.0) {
            return lineString.getPointN((int)loc.getSegmentIndex()).getCoordinate().z;
        }
        double previousZ = lineString.getPointN((int)loc.getSegmentIndex()).getCoordinate().z;
        double nextZ = lineString.getPointN((int)(loc.getSegmentIndex() + 1)).getCoordinate().z;
        if (Double.isNaN(previousZ) || Double.isNaN(nextZ)) {
            return Double.NaN;
        }
        return previousZ + (nextZ - previousZ) * loc.getSegmentFraction();
    }

    private void interpolateZbetweenIndices(LineString lineString, int start, int end) {
        double zi = lineString.getCoordinateN((int)start).z;
        double zj = lineString.getCoordinateN((int)end).z;
        if (Double.isNaN(zi) || Double.isNaN(zj)) {
            return;
        }
        double totalLength = 0.0;
        for (int i = start; i < end; ++i) {
            totalLength += lineString.getPointN(i).distance((Geometry)lineString.getPointN(i + 1));
        }
        double dz = zj - zi;
        double partialLength = 0.0;
        for (int i = start + 1; i < end; ++i) {
            lineString.getPointN((int)i).getCoordinate().z = zi + dz * ((partialLength += lineString.getPointN(i - 1).distance((Geometry)lineString.getPointN(i))) / totalLength);
        }
    }

    private void interpolateZ(LineString lineString) {
        int start = -1;
        for (int i = 0; i < lineString.getNumPoints(); ++i) {
            if (Double.isNaN(lineString.getPointN((int)i).getCoordinate().z)) continue;
            if (start == -1) {
                start = i;
                continue;
            }
            this.interpolateZbetweenIndices(lineString, start, i);
            start = -1;
        }
    }
}

