/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit.helpclassesselection;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class SelectItemsByCircleTool
extends DragTool {
    private Shape selectedFeaturesShape;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private List verticesToSnap = null;
    private double diameter = 0.0;
    private Point mp = null;

    public SelectItemsByCircleTool(WorkbenchContext context, double diameter, Coordinate initCoo) {
        super(context);
        this.diameter = diameter;
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
        this.calculateCircle(initCoo);
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            Point p;
            this.mp = p = new GeometryFactory().createPoint(this.getModelDestination());
            Geometry circle = p.buffer(this.diameter);
            this.selectItems(circle);
            Enumeration<AbstractButton> buttons = this.getWorkbenchContext().getWorkbench().getFrame().getToolBar().getButtonGroup().getElements();
            AbstractButton myButton = buttons.nextElement();
            int j = 0;
            while (buttons.hasMoreElements()) {
                myButton = buttons.nextElement();
                if (++j != 1) continue;
                myButton.doClick();
            }
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Collection verticesToSnap() {
        return this.verticesToSnap;
    }

    @Override
    protected Shape getShape() throws Exception {
        this.calculateCircle(this.modelDestination);
        return this.selectedFeaturesShape;
    }

    @Override
    protected void setModelDestination(Coordinate modelDestination) {
        this.modelDestination = modelDestination;
    }

    private void calculateCircle(Coordinate middlePoint) {
        Point p;
        this.mp = p = new GeometryFactory().createPoint(middlePoint);
        Geometry buffer = p.buffer(this.diameter);
        Geometry[] geomArray = new Geometry[]{buffer};
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(geomArray);
        try {
            this.selectedFeaturesShape = this.getWorkbenchContext().getLayerViewPanel().getJava2DConverter().toShape((Geometry)gc);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("SelectItemsByCircleTool:Exception " + e);
        }
    }

    private void selectItems(Geometry circle) {
        int count = 0;
        PlugInContext context = this.getWorkbenchContext().createPlugInContext();
        Layer[] selectedLayers = context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            FeatureCollection fc = context.getSelectedLayer(i).getFeatureCollectionWrapper().getWrappee();
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Feature element : fc) {
                if (circle.disjoint(element.getGeometry())) continue;
                features.add(element);
                ++count;
            }
            context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
        Collection<Feature> myf = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        context.getWorkbenchFrame().setTimeMessage(I18N.getInstance().get("org.openjump.core.ui.plugin.edit.helpclassesselection.SelectItemsByCircleTool.layer-items") + ": " + count + ", " + I18N.getInstance().get("org.openjump.core.ui.plugin.edit.helpclassesselection.SelectItemsByCircleTool.selected-items") + ": " + myf.size());
    }
}

