/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.transaction;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerAdapter;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.transaction.Evolution;
import org.openjump.core.ui.plugin.datastore.transaction.EvolutionOperationException;

public class DataStoreTransactionManager {
    final String KEY = DataStoreTransactionManager.class.getName();
    private static final Map<String, DataStoreTransactionManager> transactionManagers = new HashMap<String, DataStoreTransactionManager>();
    private WeakHashMap<Layer, Task> registeredLayers = new WeakHashMap();
    private WeakHashMap<Task, LayerListener> registeredListeners = new WeakHashMap();

    protected DataStoreTransactionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DataStoreTransactionManager> T getTxInstance(String clazz) {
        try {
            Map<String, DataStoreTransactionManager> map = transactionManagers;
            synchronized (map) {
                DataStoreTransactionManager tx = transactionManagers.get(clazz);
                if (null == tx) {
                    tx = (DataStoreTransactionManager)Class.forName(clazz).newInstance();
                    transactionManagers.put(clazz, tx);
                }
                DataStoreTransactionManager tmp = tx;
                return (T)tmp;
            }
        }
        catch (Exception e) {
            Logger.info("Unable to create DataStoreTransactionManager for " + clazz);
            throw new RuntimeException(e);
        }
    }

    public void registerLayer(Layer layer, Task task) {
        if (!this.registeredListeners.containsKey(task)) {
            LayerListener listener = this.getLayerListener();
            task.getLayerManager().addLayerListener(listener);
            this.registeredListeners.put(task, listener);
        }
        this.registeredLayers.put(layer, task);
        Logger.info("Register layer '" + layer.getName() + "' (" + task.getName() + ") in the DataStoreTransactionManager");
    }

    private LayerListener getLayerListener() {
        return new LayerAdapter(){

            @Override
            public void featuresChanged(FeatureEvent e) {
                Layer layer = e.getLayer();
                if (DataStoreTransactionManager.this.registeredLayers.containsKey(layer)) {
                    DataSource dataSource = layer.getDataSourceQuery().getDataSource();
                    if (dataSource instanceof WritableDataStoreDataSource) {
                        WritableDataStoreDataSource source = (WritableDataStoreDataSource)dataSource;
                        if (e.getType() == FeatureEventType.ADDED) {
                            for (Feature feature : e.getFeatures()) {
                                try {
                                    Logger.debug("FeatureEventType: ADDED " + feature.getID());
                                    source.addCreation(feature);
                                }
                                catch (EvolutionOperationException ex) {
                                    Logger.error("Error during creation of feature " + feature.getID(), ex);
                                }
                            }
                        } else if (e.getType() == FeatureEventType.DELETED) {
                            for (Feature feature : e.getFeatures()) {
                                try {
                                    Logger.debug("FeatureEventType: DELETED " + feature.getID());
                                    source.addSuppression(feature);
                                }
                                catch (EvolutionOperationException ex) {
                                    Logger.error("Error during suppression of feature " + feature.getID(), ex);
                                }
                            }
                        } else if (e.getType() == FeatureEventType.ATTRIBUTES_MODIFIED) {
                            assert (e.getFeatures().size() == e.getOldFeatureAttClones().size()) : "There is a problem with the size of FeatureEvent collections";
                            Iterator oldFeatures = e.getOldFeatureAttClones().iterator();
                            for (Feature feature : e.getFeatures()) {
                                try {
                                    Logger.debug("FeatureEventType: ATTRIBUTES_MODIFIED " + feature.getID());
                                    source.addModification(feature, (Feature)oldFeatures.next());
                                }
                                catch (EvolutionOperationException ex) {
                                    Logger.error("Error during modification of feature " + feature.getID(), ex);
                                }
                            }
                        } else if (e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                            assert (e.getFeatures().size() == e.getOldFeatureClones().size()) : "There is a problem with the size of FeatureEvent collections";
                            Iterator<Feature> oldFeatures = e.getOldFeatureClones().iterator();
                            for (Feature feature : e.getFeatures()) {
                                try {
                                    Logger.debug("FeatureEventType: GEOMETRY_MODIFIED " + feature.getID());
                                    source.addModification(feature, oldFeatures.next());
                                }
                                catch (EvolutionOperationException ex) {
                                    Logger.error("Error during modification of feature " + feature.getID(), ex);
                                }
                            }
                        } else {
                            Logger.error(e.getType() + " is an unknown FeatureEventType");
                        }
                    } else {
                        Logger.error("DataStoreTransactionManager should never contain a reference to a layer which does not use a WritableDataStoreDataSource");
                    }
                }
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.REMOVED && e.getLayerable() instanceof Layer && ((Layer)e.getLayerable()).getDataSourceQuery() != null) {
                    if (((Layer)e.getLayerable()).getDataSourceQuery().getDataSource() instanceof WritableDataStoreDataSource) {
                        ((WritableDataStoreDataSource)((Layer)e.getLayerable()).getDataSourceQuery().getDataSource()).getUncommittedEvolutions().clear();
                    }
                    DataStoreTransactionManager.this.registeredLayers.remove(e.getLayerable());
                    Logger.info("Unregister layer " + e.getLayerable().getName() + " from the DataStoreTransactionManager");
                }
            }
        };
    }

    public Collection<Layer> getLayers() {
        return this.registeredLayers.keySet();
    }

    public Task getTask(Layer layer) {
        return this.registeredLayers.get(layer);
    }

    public Collection<Layer> getLayers(Task task) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Map.Entry<Layer, Task> entry : this.registeredLayers.entrySet()) {
            if (entry.getValue() != task) continue;
            layers.add(entry.getKey());
        }
        return layers;
    }

    private boolean commit(Layer layer) throws Exception {
        DataSource source = layer.getDataSourceQuery().getDataSource();
        if (source instanceof WritableDataStoreDataSource) {
            WritableDataStoreDataSource writableSource = (WritableDataStoreDataSource)source;
            try {
                Logger.info("Commit layer \"" + layer.getName() + "\"");
                writableSource.getConnection().executeUpdate(null, layer.getFeatureCollectionWrapper(), new DummyTaskMonitor());
            }
            catch (Exception e) {
                Logger.error("Error occurred while comitting layer \"" + layer.getName() + "\"", e);
                throw e;
            }
            return true;
        }
        return false;
    }

    private int update(TaskFrame taskFrame, Layer layer) {
        DataSource source = layer.getDataSourceQuery().getDataSource();
        if (source instanceof WritableDataStoreDataSource) {
            int conflicts;
            WritableDataStoreDataSource writableSource = (WritableDataStoreDataSource)source;
            try {
                Logger.info("Update layer \"" + layer.getName() + "\"");
                FeatureCollection fc = writableSource.getConnection().executeQuery(null, new DummyTaskMonitor());
                conflicts = this.manageConflicts(taskFrame, layer, fc);
                layer.getLayerManager().setFiringEvents(false);
                layer.setFeatureCollection(fc);
                Logger.info("" + fc.size() + " features uploaded");
                layer.getLayerManager().setFiringEvents(true);
                Logger.info("" + conflicts + " conflicts detected");
            }
            catch (Exception e) {
                Logger.error("Error occurred while updating layer \"" + layer.getName() + "\"", e);
                return -1;
            }
            return conflicts;
        }
        return -1;
    }

    public void update(TaskFrame taskFrame) {
        Logger.info("Update project \"" + taskFrame.getTask().getName() + "\"");
        int total_conflicts = 0;
        boolean no_error = true;
        for (Layer layer : this.registeredLayers.keySet()) {
            if (!taskFrame.getLayerManager().getLayers().contains(layer)) continue;
            int conflicts = this.update(taskFrame, layer);
            if (conflicts < 0) {
                no_error = false;
                continue;
            }
            total_conflicts += conflicts;
        }
        taskFrame.getLayerViewPanel().getSelectionManager().clear();
        taskFrame.getLayerViewPanel().repaint();
        if (no_error) {
            Logger.info("Project update finished with 0 error and " + total_conflicts + " conflicts");
        } else {
            Logger.info("Project update finished with errors");
        }
    }

    private void inspect(TaskFrame taskFrame, Layer layer) {
        DataSource source = layer.getDataSourceQuery().getDataSource();
        if (source instanceof WritableDataStoreDataSource) {
            WritableDataStoreDataSource writableSource = (WritableDataStoreDataSource)source;
            Layer layer_c = taskFrame.getLayerManager().getLayer(layer.getName() + "-uncommitted-creation");
            if (layer_c == null) {
                layer_c = taskFrame.getLayerManager().addLayer("Next-commit", layer.getName() + "-uncommitted-creation", new FeatureDataset(layer.getFeatureCollectionWrapper().getFeatureSchema()));
            } else {
                layer_c.getFeatureCollectionWrapper().clear();
            }
            Layer layer_m = taskFrame.getLayerManager().getLayer(layer.getName() + "-uncommitted-modification");
            if (layer_m == null) {
                layer_m = taskFrame.getLayerManager().addLayer("Next-commit", layer.getName() + "-uncommitted-modification", new FeatureDataset(layer.getFeatureCollectionWrapper().getFeatureSchema()));
            } else {
                layer_m.getFeatureCollectionWrapper().clear();
            }
            Layer layer_s = taskFrame.getLayerManager().getLayer(layer.getName() + "-uncommitted-suppression");
            if (layer_s == null) {
                layer_s = taskFrame.getLayerManager().addLayer("Next-commit", layer.getName() + "-uncommitted-suppression", new FeatureDataset(layer.getFeatureCollectionWrapper().getFeatureSchema()));
            } else {
                layer_s.getFeatureCollectionWrapper().clear();
            }
            for (Evolution evolution : writableSource.getUncommittedEvolutions()) {
                if (evolution.getType() == Evolution.Type.CREATION) {
                    layer_c.getFeatureCollectionWrapper().add(evolution.getNewFeature());
                    continue;
                }
                if (evolution.getType() == Evolution.Type.MODIFICATION) {
                    layer_m.getFeatureCollectionWrapper().add(evolution.getOldFeature());
                    continue;
                }
                if (evolution.getType() == Evolution.Type.SUPPRESSION) {
                    layer_s.getFeatureCollectionWrapper().add(evolution.getOldFeature());
                    continue;
                }
                Logger.error("Tried to inspect an evolution which is neither a creation nor a modification or a suppression");
            }
        }
    }

    public void inspect(TaskFrame taskFrame) {
        for (Layer layer : this.registeredLayers.keySet()) {
            if (!taskFrame.getTask().getLayerManager().getLayers().contains(layer)) continue;
            this.inspect(taskFrame, layer);
        }
    }

    public void commit() throws Exception {
        TaskFrame activeFrame = JUMPWorkbench.getInstance().getFrame().getActiveTaskFrame();
        if (activeFrame == null) {
            return;
        }
        Logger.info("Commit evolutions on project \"" + activeFrame.getTask().getName() + "\"");
        boolean no_error = true;
        for (Layer layer : this.registeredLayers.keySet()) {
            if (!activeFrame.getTask().getLayerManager().getLayers().contains(layer)) continue;
            no_error = this.commit(layer) && no_error;
        }
        if (no_error) {
            Logger.info("Commit finished without error");
        } else {
            Logger.info("Commit finished with error");
        }
        this.update(activeFrame);
    }

    private int manageConflicts(TaskFrame taskFrame, Layer layer, FeatureCollection fc) {
        assert (layer.getDataSourceQuery().getDataSource() instanceof WritableDataStoreDataSource);
        WritableDataStoreDataSource dataSource = (WritableDataStoreDataSource)layer.getDataSourceQuery().getDataSource();
        Map<Object, Evolution> index = dataSource.getIndexedEvolutions();
        String pk = dataSource.getProperties().get("External PK").toString();
        boolean manageConflicts = (Boolean)dataSource.getProperties().get("Manage conflicts");
        int conflicts = 0;
        ArrayList<Feature> toBeDeleted = new ArrayList<Feature>();
        for (Feature feature : fc.getFeatures()) {
            Evolution evo = index.get(feature.getAttribute(pk));
            if (evo == null) continue;
            if (evo.getType() == Evolution.Type.MODIFICATION) {
                if (!Arrays.equals(feature.getAttributes(), evo.getOldFeature().getAttributes())) {
                    if (!Arrays.equals(feature.getAttributes(), evo.getNewFeature().getAttributes())) {
                        Logger.warn("Conflict detected for feature " + evo.getNewFeature().getAttribute(pk));
                        Logger.trace("  - Server: " + feature);
                        Logger.trace("  - Local : " + evo.getNewFeature());
                        ++conflicts;
                        if (manageConflicts) {
                            this.copyLocallyModifiedFeature(taskFrame, layer, evo.getNewFeature());
                        }
                    } else {
                        dataSource.removeEvolution(evo.getNewFeature().getID());
                        Logger.trace("Eliminate an evolution from evolution stack after detection of a false conflict: " + evo.getNewFeature().getAttribute(pk));
                    }
                } else {
                    Logger.trace("Database has not been changed since last transaction : Keep local changes");
                    feature.setAttributes(evo.getNewFeature().getAttributes());
                }
            }
            if (evo.getType() != Evolution.Type.SUPPRESSION) continue;
            if (!Arrays.equals(feature.getAttributes(), evo.getOldFeature().getAttributes())) {
                Logger.warn("Conflict detected for feature " + evo.getNewFeature().getAttribute(pk));
                Logger.trace("  - The feature has been locally deleted");
                ++conflicts;
                this.copyLocallyDeletedFeature(taskFrame, layer, evo.getOldFeature());
                continue;
            }
            Logger.trace("Feature " + feature.getAttribute(pk) + " has been locally deleted, don't update it again !");
            toBeDeleted.add(evo.getOldFeature());
        }
        fc.removeAll(toBeDeleted);
        for (Evolution evo : dataSource.getUncommittedEvolutions()) {
            if (evo.getType() != Evolution.Type.CREATION) continue;
            fc.add(evo.getNewFeature());
        }
        return conflicts;
    }

    private void copyLocallyModifiedFeature(TaskFrame taskFrame, Layer layer, Feature feature) {
        if (taskFrame != null) {
            Layer layer_m = taskFrame.getLayerManager().getLayer(layer.getName() + "-conflict-modification");
            if (layer_m == null) {
                layer_m = taskFrame.getLayerManager().addLayer("Conflict", layer.getName() + "-conflict-modification", new FeatureDataset(layer.getFeatureCollectionWrapper().getFeatureSchema()));
            }
            layer_m.getFeatureCollectionWrapper().add(feature);
        }
    }

    private void copyLocallyDeletedFeature(TaskFrame taskFrame, Layer layer, Feature feature) {
        if (taskFrame != null) {
            Layer layer_m = taskFrame.getLayerManager().getLayer(layer.getName() + "-conflict-suppression");
            if (layer_m == null) {
                layer_m = taskFrame.getLayerManager().addLayer("Conflict", layer.getName() + "-conflict-suppression", new FeatureDataset(layer.getFeatureCollectionWrapper().getFeatureSchema()));
            }
            layer_m.getFeatureCollectionWrapper().add(feature);
        }
    }
}

