/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreDataSource;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager;
import org.openjump.core.ui.plugin.datastore.transaction.Evolution;
import org.openjump.core.ui.plugin.datastore.transaction.EvolutionOperationException;

public abstract class WritableDataStoreDataSource
extends DataStoreDataSource {
    private static final String KEY = WritableDataStoreDataSource.class.getName();
    public static final String LIMITED_TO_VIEW = "Limited To View";
    public static final String MANAGE_CONFLICTS = "Manage conflicts";
    public static final String EXTERNAL_PK_KEY = "External PK";
    public static final String SRID_KEY = "SRID";
    public static final String GEOM_DIM_KEY = "Dimension";
    public static final String NAN_Z_TO_VALUE_KEY = "NaN Z to value";
    public static final String NARROW_GEOMETRY_TYPE_KEY = "Narrow geometry type";
    public static final String CONVERT_TO_MULTIGEOMETRY_KEY = "Convert to multigeometry";
    public static final String CREATE_PK = "Create PK";
    public static final String NORMALIZED_COLUMN_NAMES = "Normalized Column Names";
    public static final String TX_MANAGER_KEY = "TxManager";
    public static final String DEFAULT_PK_NAME = "gid";
    protected final LinkedHashMap<Integer, Evolution> evolutions = new LinkedHashMap();
    private boolean tableAlreadyCreated = true;
    protected String schemaName;
    protected String tableName;
    protected String primaryKeyName = "gid";

    public WritableDataStoreDataSource() {
    }

    public WritableDataStoreDataSource(ConnectionDescriptor connectionDescriptor, String datasetName, String geometryAttributeName, String externalPKName, String txManager, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{"Connection Descriptor", connectionDescriptor, "Dataset Name", datasetName, "Geometry Attribute Name", geometryAttributeName, EXTERNAL_PK_KEY, externalPKName, TX_MANAGER_KEY, txManager}));
        this.getProperties().put("Where Clause", null);
        this.getProperties().put("Max Features", Integer.MAX_VALUE);
        this.getProperties().put(LIMITED_TO_VIEW, false);
        this.getProperties().put(MANAGE_CONFLICTS, false);
        this.getProperties().put(CREATE_PK, false);
        this.getProperties().put(SRID_KEY, 0);
        this.context = context;
    }

    public void setLimitedToView(boolean limitedToView) {
        this.getProperties().put(LIMITED_TO_VIEW, limitedToView);
    }

    public void setManageConflicts(boolean manageConflicts) {
        this.getProperties().put(MANAGE_CONFLICTS, manageConflicts);
    }

    public void setMultiGeometry(boolean multi) {
        this.getProperties().put(CONVERT_TO_MULTIGEOMETRY_KEY, multi);
    }

    public void setCoordDimension(int dbCoordDim) {
        this.getProperties().put(GEOM_DIM_KEY, dbCoordDim);
    }

    public void setSRID(int srid) {
        this.getProperties().put(SRID_KEY, srid);
    }

    public void setTableAlreadyCreated(boolean tableAlreadyCreated) {
        this.tableAlreadyCreated = tableAlreadyCreated;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public Connection getConnection() {
        return new Connection(){

            @Override
            public FeatureCollection executeQuery(String query, Collection<Throwable> exceptions, TaskMonitor monitor) {
                try {
                    String[] datasetName = SQLUtil.splitTableName((String)WritableDataStoreDataSource.this.getProperties().get("Dataset Name"));
                    WritableDataStoreDataSource.this.schemaName = datasetName[0];
                    WritableDataStoreDataSource.this.tableName = datasetName[1];
                    WritableDataStoreDataSource.this.primaryKeyName = (String)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.EXTERNAL_PK_KEY);
                    return WritableDataStoreDataSource.this.createFeatureCollection();
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            @Override
            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)WritableDataStoreDataSource.this.getProperties().get("Connection Descriptor");
                boolean normalizedColumnNames = WritableDataStoreDataSource.this.getProperties().containsKey(WritableDataStoreDataSource.NORMALIZED_COLUMN_NAMES) ? (Boolean)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.NORMALIZED_COLUMN_NAMES) : false;
                String[] datasetName = SQLUtil.splitTableName((String)WritableDataStoreDataSource.this.getProperties().get("Dataset Name"));
                WritableDataStoreDataSource.this.schemaName = datasetName[0];
                WritableDataStoreDataSource.this.tableName = datasetName[1];
                boolean createPrimaryKey = (Boolean)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.CREATE_PK);
                int srid = WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.SRID_KEY) == null ? 0 : (Integer)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.SRID_KEY);
                boolean narrow = WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.NARROW_GEOMETRY_TYPE_KEY) != null && (Boolean)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.NARROW_GEOMETRY_TYPE_KEY) != false;
                boolean multi = WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.CONVERT_TO_MULTIGEOMETRY_KEY) != null && (Boolean)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.CONVERT_TO_MULTIGEOMETRY_KEY) != false;
                Class geometryType = WritableDataStoreDataSource.getGeometryType(featureCollection, narrow, multi);
                int dim = WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.GEOM_DIM_KEY) == null ? WritableDataStoreDataSource.getGeometryDimension(featureCollection, 3) : (Integer)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.GEOM_DIM_KEY);
                DataStoreDriver driver = ConnectionManager.instance(WritableDataStoreDataSource.this.context).getDriver(connectionDescriptor.getDataStoreDriverClassName());
                SpatialDatabasesDSConnection conn = (SpatialDatabasesDSConnection)connectionDescriptor.createConnection(driver);
                java.sql.Connection jdbcConn = conn.getJdbcConnection();
                try {
                    jdbcConn.setAutoCommit(false);
                    if (!WritableDataStoreDataSource.this.tableAlreadyCreated) {
                        Logger.debug("Update mode: create table");
                        boolean exists = WritableDataStoreDataSource.this.tableExists(jdbcConn);
                        if (exists && !WritableDataStoreDataSource.this.confirmOverwrite()) {
                            return;
                        }
                        if (exists) {
                            WritableDataStoreDataSource.this.deleteTableQuery(conn);
                        }
                        featureCollection.getFeatureSchema().removeExternalPrimaryKey();
                        WritableDataStoreDataSource.this.createAndPopulateTable(conn, featureCollection, srid, geometryType.getSimpleName(), multi, dim, normalizedColumnNames);
                        if (createPrimaryKey) {
                            WritableDataStoreDataSource.this.addDBPrimaryKey(conn, WritableDataStoreDataSource.DEFAULT_PK_NAME);
                            jdbcConn.commit();
                            WritableDataStoreDataSource.this.reloadDataFromDataStore(this, monitor);
                        }
                        WritableDataStoreDataSource.this.tableAlreadyCreated = true;
                    } else {
                        Logger.debug("Update mode: update table");
                        WritableDataStoreDataSource.this.primaryKeyName = (String)WritableDataStoreDataSource.this.getProperties().get(WritableDataStoreDataSource.EXTERNAL_PK_KEY);
                        FeatureSchema featureSchema = featureCollection.getFeatureSchema();
                        if (conn.getCompatibleSchemaSubset(WritableDataStoreDataSource.this.schemaName, WritableDataStoreDataSource.this.tableName, featureSchema, normalizedColumnNames).length < featureSchema.getAttributeCount() && !WritableDataStoreDataSource.this.confirmWriteDespiteDifferentSchemas()) {
                            return;
                        }
                        WritableDataStoreDataSource.this.commit(conn, srid, multi, dim, normalizedColumnNames);
                        WritableDataStoreDataSource.this.evolutions.clear();
                    }
                    jdbcConn.commit();
                }
                finally {
                    if (jdbcConn != null) {
                        jdbcConn.setAutoCommit(true);
                    }
                }
            }

            @Override
            public void close() {
            }
        };
    }

    @Deprecated
    public abstract void finalizeUpdate(SpatialDatabasesDSConnection var1) throws Exception;

    private void commit(SpatialDatabasesDSConnection conn, int srid, boolean multi, int dim, boolean normalizedColumnNames) throws Exception {
        Logger.info("Evolutions to commit to " + this.schemaName + "." + this.tableName + " (PK=" + this.primaryKeyName + ")");
        for (Evolution evolution : this.evolutions.values()) {
            if (evolution.getType() == Evolution.Type.CREATION) {
                PreparedStatement pstmt = this.insertStatement(conn, evolution.getNewFeature().getSchema(), multi, normalizedColumnNames);
                pstmt = this.setAttributeValues(pstmt, evolution.getNewFeature(), srid, multi, dim);
                pstmt.execute();
                Logger.info("  create new feature " + evolution.getNewFeature().getID() + "/");
                continue;
            }
            if (evolution.getType() == Evolution.Type.SUPPRESSION) {
                this.deleteStatement(conn, evolution.getOldFeature()).executeUpdate();
                Logger.info("  delete " + evolution.getOldFeature().getID() + "/" + evolution.getOldFeature().getAttribute(this.primaryKeyName));
                continue;
            }
            if (evolution.getType() != Evolution.Type.MODIFICATION) continue;
            Feature oldFeature = evolution.getOldFeature();
            Feature newFeature = evolution.getNewFeature();
            FeatureSchema schema = oldFeature.getSchema();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                if (schema.isAttributeReadOnly(i) || !(oldFeature.getAttribute(i) == null && newFeature.getAttribute(i) != null || oldFeature.getAttribute(i) != null && newFeature.getAttribute(i) == null) && (oldFeature.getAttribute(i) == null || oldFeature.getAttribute(i).equals(newFeature.getAttribute(i)))) continue;
                this.updateOneAttributeStatement(conn, newFeature, i, srid, multi, dim).executeUpdate();
            }
            Logger.info("  modify " + evolution.getNewFeature().getID() + "/" + evolution.getNewFeature().getAttribute(this.primaryKeyName));
        }
        this.evolutions.clear();
    }

    protected PreparedStatement insertStatement(SpatialDatabasesDSConnection conn, FeatureSchema fSchema, boolean multi, boolean normalizedColumnNames) throws SQLException {
        StringBuilder sb = new StringBuilder("INSERT INTO " + SQLUtil.compose(this.schemaName, this.tableName) + "(");
        sb.append(conn.getMetadata().createColumnList(fSchema, false, true, false, false, normalizedColumnNames)).append(") VALUES(");
        boolean first = true;
        for (int i = 0; i < fSchema.getAttributeCount(); ++i) {
            if (fSchema.getExternalPrimaryKeyIndex() == i || fSchema.isAttributeReadOnly(i)) continue;
            if (multi && fSchema.getAttributeType(i) == AttributeType.GEOMETRY) {
                sb.append(first ? "ST_Multi(?)" : ",ST_Multi(?)");
            } else {
                sb.append(first ? "?" : ",?");
            }
            first = false;
        }
        sb.append(");");
        Logger.trace(sb.toString());
        return conn.getJdbcConnection().prepareStatement(sb.toString());
    }

    private PreparedStatement updateOneAttributeStatement(SpatialDatabasesDSConnection conn, Feature feature, int attribute, int srid, boolean multi, int dim) throws SQLException {
        FeatureSchema schema = feature.getSchema();
        boolean quoted = schema.getAttributeType(schema.getExternalPrimaryKeyIndex()) == AttributeType.STRING;
        String quoteKey = quoted ? "'" : "";
        String query = "UPDATE " + SQLUtil.compose(this.schemaName, this.tableName) + " SET \"" + schema.getAttributeName(attribute) + "\" = ? WHERE \"" + this.primaryKeyName + "\" = " + quoteKey + feature.getAttribute(this.primaryKeyName) + quoteKey + ";";
        PreparedStatement pstmt = conn.getJdbcConnection().prepareStatement(query);
        AttributeType type = schema.getAttributeType(attribute);
        if (feature.getAttribute(attribute) == null) {
            pstmt.setObject(1, null);
        } else if (type == AttributeType.STRING) {
            pstmt.setString(1, feature.getString(attribute));
        } else if (type == AttributeType.GEOMETRY) {
            Geometry g = (Geometry)feature.getAttribute(attribute);
            if (multi) {
                if (g instanceof Point) {
                    g = g.getFactory().createMultiPoint(new Point[]{(Point)g});
                } else if (g instanceof LineString) {
                    g = g.getFactory().createMultiLineString(new LineString[]{(LineString)g});
                } else if (g instanceof Polygon) {
                    g = g.getFactory().createMultiPolygon(new Polygon[]{(Polygon)g});
                }
            }
            pstmt.setBytes(1, SQLUtil.getByteArrayFromGeometry(g, srid, dim));
        } else if (type == AttributeType.INTEGER) {
            pstmt.setInt(1, feature.getInteger(attribute));
        } else if (type == AttributeType.LONG) {
            pstmt.setLong(1, (Long)feature.getAttribute(attribute));
        } else if (type == AttributeType.DOUBLE) {
            pstmt.setDouble(1, feature.getDouble(attribute));
        } else if (type == AttributeType.BOOLEAN) {
            pstmt.setBoolean(1, (Boolean)feature.getAttribute(attribute));
        } else if (type == AttributeType.DATE) {
            pstmt.setTimestamp(1, new Timestamp(((Date)feature.getAttribute(attribute)).getTime()));
        } else if (type == AttributeType.OBJECT) {
            pstmt.setObject(1, feature.getAttribute(attribute));
        } else {
            throw new IllegalArgumentException(type + " is an unknown AttributeType !");
        }
        Logger.debug(pstmt.toString());
        return pstmt;
    }

    private PreparedStatement deleteStatement(SpatialDatabasesDSConnection conn, Feature feature) throws SQLException {
        PreparedStatement pstmt = conn.getJdbcConnection().prepareStatement("DELETE FROM " + SQLUtil.compose(this.schemaName, this.tableName) + " WHERE \"" + this.primaryKeyName + "\" = ?");
        pstmt.setObject(1, feature.getAttribute(this.primaryKeyName));
        Logger.debug(pstmt.toString());
        return pstmt;
    }

    protected PreparedStatement setAttributeValues(PreparedStatement pstmt, Feature feature, int srid, boolean multi, int dim) throws SQLException {
        FeatureSchema schema = feature.getSchema();
        HashSet<String> excludedAttributes = new HashSet<String>();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (!schema.isAttributeReadOnly(i)) continue;
            excludedAttributes.add(schema.getAttributeName(i));
        }
        int index = 1;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeType type = schema.getAttributeType(i);
            if (excludedAttributes.contains(schema.getAttributeName(i))) continue;
            if (schema.getExternalPrimaryKeyIndex() == i) {
                pstmt.setObject(index++, null);
            }
            if (feature.getAttribute(i) == null) {
                pstmt.setObject(index++, null);
                continue;
            }
            if (type == AttributeType.STRING) {
                pstmt.setString(index++, feature.getString(i));
                continue;
            }
            if (type == AttributeType.GEOMETRY) {
                Geometry g = (Geometry)feature.getAttribute(i);
                if (multi) {
                    if (g instanceof Point) {
                        g = g.getFactory().createMultiPoint(new Point[]{(Point)g});
                    } else if (g instanceof LineString) {
                        g = g.getFactory().createMultiLineString(new LineString[]{(LineString)g});
                    } else if (g instanceof Polygon) {
                        g = g.getFactory().createMultiPolygon(new Polygon[]{(Polygon)g});
                    }
                }
                pstmt.setBytes(index++, SQLUtil.getByteArrayFromGeometry(g, srid, dim));
                continue;
            }
            if (type == AttributeType.INTEGER) {
                pstmt.setInt(index++, feature.getInteger(i));
                continue;
            }
            if (type == AttributeType.LONG) {
                pstmt.setLong(index++, (Long)feature.getAttribute(i));
                continue;
            }
            if (type == AttributeType.DOUBLE) {
                pstmt.setDouble(index++, feature.getDouble(i));
                continue;
            }
            if (type == AttributeType.BOOLEAN) {
                pstmt.setBoolean(index++, (Boolean)feature.getAttribute(i));
                continue;
            }
            if (type == AttributeType.DATE) {
                pstmt.setTimestamp(index++, new Timestamp(((Date)feature.getAttribute(i)).getTime()));
                continue;
            }
            if (type == AttributeType.OBJECT) {
                if (feature.getAttribute(i) instanceof Geometry) {
                    int object_srid = ((Geometry)feature.getAttribute(i)).getSRID();
                    pstmt.setBytes(index++, SQLUtil.getByteArrayFromGeometry((Geometry)feature.getAttribute(i), object_srid, 2));
                    continue;
                }
                if (feature.getAttribute(i) instanceof String) {
                    pstmt.setBytes(index++, feature.getAttribute(i).toString().getBytes());
                    continue;
                }
                pstmt.setObject(index++, feature.getAttribute(i));
                continue;
            }
            throw new IllegalArgumentException(type + " is an unknown AttributeType !");
        }
        Logger.debug(pstmt.toString());
        return pstmt;
    }

    protected abstract int getTableSRID(java.sql.Connection var1, String var2) throws SQLException;

    protected Geometry getViewEnvelope() {
        return new GeometryFactory().toGeometry(JUMPWorkbench.getInstance().getFrame().getActiveTaskFrame().getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates());
    }

    private boolean confirmWriteDespiteDifferentSchemas() {
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource.schema-mismatch-dialog-message"), I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource.schema-mismatch-dialog-title"), 0);
        return false;
    }

    public void addCreation(Feature feature) throws EvolutionOperationException {
        Evolution oldEvo = (Evolution)this.evolutions.remove(feature.getID());
        Evolution newEvo = Evolution.createCreation(feature.clone(true, true)).mergeToPrevious(oldEvo);
        if (newEvo != null) {
            this.evolutions.put(feature.getID(), newEvo);
        }
    }

    public void addModification(Feature feature, Feature oldFeature) throws EvolutionOperationException {
        Evolution oldEvo = (Evolution)this.evolutions.remove(feature.getID());
        Evolution newEvo = Evolution.createModification(feature.clone(true, true), oldFeature.clone(true, true)).mergeToPrevious(oldEvo);
        if (newEvo != null) {
            this.evolutions.put(feature.getID(), newEvo);
        }
    }

    public void addSuppression(Feature feature) throws EvolutionOperationException {
        Evolution oldEvo = (Evolution)this.evolutions.remove(feature.getID());
        Evolution newEvo = Evolution.createSuppression(feature.clone(true, true)).mergeToPrevious(oldEvo);
        if (newEvo != null) {
            this.evolutions.put(feature.getID(), newEvo);
        }
    }

    public void removeEvolution(int fid) {
        this.evolutions.remove(fid);
    }

    public Collection<Evolution> getUncommittedEvolutions() {
        return this.evolutions.values();
    }

    public Map<Object, Evolution> getIndexedEvolutions() {
        TreeMap<Object, Evolution> index = new TreeMap<Object, Evolution>();
        for (Evolution evolution : this.evolutions.values()) {
            Object dbid;
            Evolution.Type type = evolution.getType();
            if (type != Evolution.Type.MODIFICATION && type != Evolution.Type.SUPPRESSION || (dbid = evolution.getOldFeature().getAttribute(this.primaryKeyName)) == null) continue;
            index.put(dbid, evolution);
        }
        return index;
    }

    private boolean confirmOverwrite() {
        this.setWorkbenchContext(JUMPWorkbench.getInstance().getContext());
        int opt = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getWorkbench().getFrame(), I18N.getInstance().get(KEY + ".overwrite-dialog-message"), I18N.getInstance().get(KEY + ".overwrite-dialog-title"), 0);
        return opt != 1;
    }

    private boolean tableExists(java.sql.Connection conn) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        return metadata.getTables(null, this.schemaName, this.tableName, new String[]{"TABLE"}).next();
    }

    protected abstract void deleteTableQuery(SpatialDatabasesDSConnection var1) throws SQLException;

    protected abstract void createAndPopulateTable(SpatialDatabasesDSConnection var1, FeatureCollection var2, int var3, String var4, boolean var5, int var6, boolean var7) throws SQLException;

    protected abstract void addDBPrimaryKey(SpatialDatabasesDSConnection var1, String var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadDataFromDataStore(Connection conn, TaskMonitor monitor) throws Exception {
        Layer[] selectedLayers = JUMPWorkbench.getInstance().getContext().getLayerableNamePanel().getSelectedLayers();
        if (selectedLayers != null && selectedLayers.length == 1) {
            boolean oldFiringEvents = JUMPWorkbench.getInstance().getContext().getLayerManager().isFiringEvents();
            JUMPWorkbench.getInstance().getContext().getLayerManager().setFiringEvents(false);
            try {
                selectedLayers[0].setFeatureCollection(conn.executeQuery(null, monitor));
                if (!this.tableAlreadyCreated) {
                    Object txManager = DataStoreTransactionManager.getTxInstance("org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager");
                    ((DataStoreTransactionManager)txManager).registerLayer(selectedLayers[0], JUMPWorkbench.getInstance().getContext().getTask());
                    this.tableAlreadyCreated = true;
                }
            }
            finally {
                JUMPWorkbench.getInstance().getContext().getLayerManager().setFiringEvents(oldFiringEvents);
            }
        }
    }

    protected static int getGeometryDimension(FeatureCollection coll, int defaultDim) {
        if (!coll.isEmpty()) {
            int step = 1 + coll.size() / 1000;
            int count = 0;
            for (Feature f : coll) {
                if (count % step == 0 && WritableDataStoreDataSource.getGeometryDimension(f.getGeometry()) == 3) {
                    return 3;
                }
                ++count;
            }
            return 2;
        }
        return defaultDim;
    }

    private static int getGeometryDimension(Geometry g) {
        Coordinate[] cc;
        for (Coordinate c : cc = g.getCoordinates()) {
            if (Double.isNaN(c.z)) continue;
            return 3;
        }
        return 2;
    }

    protected static Class getGeometryType(FeatureCollection coll, boolean narrow, boolean multi) {
        if (!narrow && !multi) {
            return Geometry.class;
        }
        Class[] classes = new Class[]{Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class};
        int[] types = new int[]{0, 0, 0, 0, 0, 0};
        Iterator<Feature> it = coll.iterator();
        while (it.hasNext()) {
            int index;
            Geometry geom = it.next().getGeometry();
            Class<?> currentClazz = geom.getClass();
            if (currentClazz == GeometryCollection.class) {
                return Geometry.class;
            }
            int n = index = geom.getDimension() + (geom instanceof GeometryCollection ? 3 : 0);
            types[n] = types[n] + 1;
        }
        if (multi) {
            types = new int[]{0, 0, 0, types[0] + types[3], types[1] + types[4], types[2] + types[5]};
        }
        Class firstClass = null;
        Class lastClass = null;
        for (int i = 0; i < 6; ++i) {
            if (firstClass == null && types[i] > 0) {
                firstClass = classes[i];
            }
            if (types[i] <= 0) continue;
            lastClass = classes[i];
        }
        if (firstClass == lastClass) {
            return firstClass;
        }
        return Geometry.class;
    }
}

