/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.famfam.IconLoaderFamFam;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.plugin.datastore.DataStoreDataSourceFactory;
import org.openjump.core.ui.plugin.datastore.SaveToDataStoreDataSourceQuery;
import org.openjump.core.ui.plugin.datastore.SaveToDataStorePanel;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;

public class SaveToDataStoreWizard
extends AbstractWizardGroup {
    public static final String KEY = SaveToDataStoreWizard.class.getName();
    private DataStoreTransactionManager txManager;
    private PlugInContext context;

    public SaveToDataStoreWizard(PlugInContext context, DataStoreTransactionManager txManager) {
        super(I18N.getInstance().get(KEY), IconLoaderFamFam.icon("database_save.png"), SaveToDataStorePanel.KEY);
        this.txManager = txManager;
        this.context = context;
    }

    @Override
    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        if (!this.getPanels().isEmpty()) {
            return;
        }
        SaveToDataStorePanel saveToDataStorePanel = new SaveToDataStorePanel(workbenchContext);
        this.addPanel(saveToDataStorePanel);
    }

    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) throws Exception {
        Layer[] layers = this.context.getWorkbenchContext().getLayerableNamePanel().getSelectedLayers();
        if (layers.length == 0) {
            throw new Exception("No layer has been selected");
        }
        Layer layer = this.context.getWorkbenchContext().getLayerableNamePanel().getSelectedLayers()[0];
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        String geometryAttributeName = schema.getAttributeName(schema.getGeometryIndex());
        WritableDataStoreDataSource writableDS = DataStoreDataSourceFactory.createWritableDataStoreDataSource((ConnectionDescriptor)dialog.getData("Connection Descriptor"), (String)dialog.getData("Dataset Name"), geometryAttributeName, "gid", false, "org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager", this.context.getWorkbenchContext());
        writableDS.getProperties().put("Connection Descriptor", dialog.getData("Connection Descriptor"));
        writableDS.getProperties().put("Dataset Name", dialog.getData("Dataset Name"));
        writableDS.getProperties().put("Create PK", dialog.getData("Create PK"));
        writableDS.getProperties().put("Dimension", dialog.getData("Dimension"));
        writableDS.getProperties().put("NaN Z to value", dialog.getData("NaN Z to value"));
        writableDS.getProperties().put("Narrow geometry type", dialog.getData("Narrow geometry type"));
        writableDS.getProperties().put("Convert to multigeometry", dialog.getData("Convert to multigeometry"));
        if (((Boolean)dialog.getData("Create PK")).booleanValue()) {
            writableDS.getProperties().put("External PK", "gid");
        }
        writableDS.getProperties().put("Geometry Attribute Name", (Boolean)dialog.getData("Normalized Column Names") != false ? SQLUtil.normalize(schema.getAttributeName(schema.getGeometryIndex())) : schema.getAttributeName(schema.getGeometryIndex()));
        SRIDStyle sridStyle = (SRIDStyle)layers[0].getStyle(SRIDStyle.class);
        writableDS.getProperties().put("SRID", sridStyle.getSRID());
        writableDS.getProperties().put("Normalized Column Names", (boolean)((Boolean)dialog.getData("Normalized Column Names")));
        writableDS.getProperties().put("Limited To View", false);
        writableDS.getProperties().put("Max Features", Integer.MAX_VALUE);
        writableDS.getProperties().put("Where Clause", "");
        writableDS.getProperties().put("Manage conflicts", true);
        SaveToDataStoreDataSourceQuery query = new SaveToDataStoreDataSourceQuery(writableDS, (String)writableDS.getProperties().get("Dataset Name"), (String)writableDS.getProperties().get("Dataset Name"));
        query.setProperties(writableDS.getProperties());
        query.getDataSource().getConnection().executeUpdate("Dataset Name", layer.getFeatureCollectionWrapper(), new DummyTaskMonitor());
        layer.setDataSourceQuery(query);
    }
}

