/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.PrimaryKeyColumn;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openjump.core.ui.plugin.datastore.AddWritableDataStoreLayerWizardPanel;

public class AddWritableDataStoreLayerPanel
extends ConnectionPanel {
    private static final String KEY = AddWritableDataStoreLayerPanel.class.getName();
    private Map<ConnectionDescriptor, String[]> connectionDescriptorToDatasetNamesMap = new HashMap<ConnectionDescriptor, String[]>();
    private JComboBox<Object> datasetComboBox = null;
    private JComboBox<GeometryColumn> geometryAttributeComboBox = null;
    private JComboBox<PrimaryKeyColumn> identifierAttributeComboBox = null;
    private JTextField maxFeaturesTextField = null;
    private JTextArea whereTextArea = null;
    private JCheckBox limitedToViewCheckBox = null;
    private JCheckBox manageConflictsCheckBox = null;

    public AddWritableDataStoreLayerPanel(WorkbenchContext context) {
        super(context);
        this.initialize();
        this.getConnectionComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddWritableDataStoreLayerPanel.this.getDatasetComboBox().setSelectedItem(null);
                Container c = AddWritableDataStoreLayerPanel.this;
                while ((c = c.getParent()) != null) {
                    if (!(c instanceof WizardPanel)) continue;
                    ((AddWritableDataStoreLayerWizardPanel)c).selectionChanged();
                    break;
                }
            }
        });
    }

    private static <T> T runInKillableThread(final String description, WorkbenchContext context, final Block<T> block) {
        final ArrayList result = new ArrayList();
        AbstractPlugIn.toActionListener(new ThreadedBasePlugIn(){

            @Override
            public String getName() {
                return description;
            }

            @Override
            public boolean execute(PlugInContext context) {
                return true;
            }

            @Override
            public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
                monitor.report(description);
                result.add(block.yield());
            }
        }, context, new TaskMonitorManager()).actionPerformed(null);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public String getDatasetName() {
        return this.datasetComboBox.getSelectedItem() != null ? ((String)this.datasetComboBox.getSelectedItem()).trim() : null;
    }

    public GeometryColumn getGeometryColumn() {
        return this.geometryAttributeComboBox.getSelectedItem() != null ? (GeometryColumn)this.geometryAttributeComboBox.getSelectedItem() : null;
    }

    public PrimaryKeyColumn getIdentifierColumn() throws Exception {
        Object selectedItem = this.identifierAttributeComboBox.getSelectedItem();
        if (selectedItem != null) {
            if (selectedItem instanceof PrimaryKeyColumn) {
                return (PrimaryKeyColumn)this.identifierAttributeComboBox.getSelectedItem();
            }
            throw new SQLException(I18N.getInstance().get(KEY + ".invalid-primary-key"));
        }
        return null;
    }

    public String getGeometryAttributeName() {
        return this.geometryAttributeComboBox.getSelectedItem() != null ? this.getGeometryColumn().getName().trim() : null;
    }

    public String getIdentifierAttributeName() throws Exception {
        return this.identifierAttributeComboBox.getSelectedItem() != null ? this.getIdentifierColumn().getName().trim() : null;
    }

    public Integer getMaxFeatures() {
        if (this.maxFeaturesTextField.getText() == null) {
            return Integer.MAX_VALUE;
        }
        if (this.maxFeaturesTextField.getText().trim().length() == 0) {
            return Integer.MAX_VALUE;
        }
        if (this.maxFeaturesTextField.getText().trim().equals("-")) {
            return Integer.MAX_VALUE;
        }
        return Integer.valueOf(this.maxFeaturesTextField.getText().trim());
    }

    public String getWhereClause() {
        return this.getWhereClauseProper().toLowerCase().startsWith("where") ? this.getWhereClauseProper().substring("where".length()).trim() : this.getWhereClauseProper();
    }

    public String getWhereClauseProper() {
        return this.whereTextArea.getText().trim();
    }

    public boolean isLimitedToView() {
        return this.getLimitedToViewCheckBox().isSelected();
    }

    void setLimitedToView(boolean limitedToView) {
        this.getLimitedToViewCheckBox().setSelected(limitedToView);
    }

    public boolean isManageConfictsActive() {
        return this.getManageConflictsCheckBox().isSelected();
    }

    void setManageConfictsActive(boolean manageConflicts) {
        this.getManageConflictsCheckBox().setSelected(manageConflicts);
    }

    @Override
    public String validateInput() {
        String validation = super.validateInput();
        if (validation != null) {
            return validation;
        }
        if (((String)LangUtil.ifNull(this.getDatasetName(), "")).length() == 0) {
            return I18N.getInstance().get(KEY + ".missing-dataset-name");
        }
        if (((String)LangUtil.ifNull(this.getGeometryAttributeName(), "")).length() == 0) {
            return I18N.getInstance().get(KEY + ".missing-geometry-column-name");
        }
        try {
            if (((String)LangUtil.ifNull(this.getIdentifierAttributeName(), "")).length() == 0) {
                return I18N.getInstance().get(KEY + ".missing-pk-name");
            }
        }
        catch (Exception e) {
            return I18N.getInstance().get(KEY + ".invalid-primary-key");
        }
        return null;
    }

    private JTextArea getWhereTextArea() {
        if (this.whereTextArea == null) {
            this.whereTextArea = new JTextArea();
        }
        return this.whereTextArea;
    }

    private JComboBox getDatasetComboBox() {
        if (this.datasetComboBox == null) {
            this.datasetComboBox = new JComboBox();
            this.datasetComboBox.setPreferredSize(new Dimension(550, (int)this.datasetComboBox.getPreferredSize().getHeight()));
            this.datasetComboBox.setEditable(true);
            this.datasetComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddWritableDataStoreLayerPanel.this.populateGeometryAttributeComboBox();
                    if (AddWritableDataStoreLayerPanel.this.geometryAttributeComboBox.getItemCount() > 0) {
                        AddWritableDataStoreLayerPanel.this.geometryAttributeComboBox.setSelectedIndex(0);
                    }
                    AddWritableDataStoreLayerPanel.this.populateIdentifierAttributeComboBox();
                    if (AddWritableDataStoreLayerPanel.this.identifierAttributeComboBox.getItemCount() > 0) {
                        AddWritableDataStoreLayerPanel.this.identifierAttributeComboBox.setSelectedIndex(0);
                    }
                    Container c = AddWritableDataStoreLayerPanel.this;
                    while ((c = c.getParent()) != null) {
                        if (!(c instanceof WizardPanel)) continue;
                        ((AddWritableDataStoreLayerWizardPanel)c).selectionChanged();
                        break;
                    }
                }
            });
            this.addSafePopupListener(this.datasetComboBox, new Block(){

                public Object yield() throws Exception {
                    AddWritableDataStoreLayerPanel.this.populateDatasetComboBox();
                    return null;
                }
            });
        }
        return this.datasetComboBox;
    }

    private JComboBox getGeometryAttributeComboBox() {
        if (this.geometryAttributeComboBox == null) {
            this.geometryAttributeComboBox = new JComboBox();
            this.geometryAttributeComboBox.setPreferredSize(new Dimension(550, (int)this.geometryAttributeComboBox.getPreferredSize().getHeight()));
            this.geometryAttributeComboBox.setEditable(true);
        }
        return this.geometryAttributeComboBox;
    }

    private JComboBox getIdentifierAttributeComboBox() {
        if (this.identifierAttributeComboBox == null) {
            this.identifierAttributeComboBox = new JComboBox();
            this.identifierAttributeComboBox.setPreferredSize(new Dimension(550, (int)this.identifierAttributeComboBox.getPreferredSize().getHeight()));
            this.identifierAttributeComboBox.setEditable(true);
        }
        return this.identifierAttributeComboBox;
    }

    private JTextField getMaxFeaturesTextField() {
        if (this.maxFeaturesTextField == null) {
            this.maxFeaturesTextField = new ValidatingTextField("", 10, new ValidatingTextField.BoundedIntValidator(1, Integer.MAX_VALUE));
        }
        return this.maxFeaturesTextField;
    }

    private JCheckBox getLimitedToViewCheckBox() {
        if (this.limitedToViewCheckBox == null) {
            this.limitedToViewCheckBox = new JCheckBox();
            this.limitedToViewCheckBox.setText(I18N.getInstance().get(KEY + ".limit-to-view"));
            String s1 = I18N.getInstance().get(KEY + ".limited-updates-to-the-viewport");
            this.limitedToViewCheckBox.setToolTipText("<html>" + s1 + "</html>");
            this.limitedToViewCheckBox.setSelected(false);
        }
        return this.limitedToViewCheckBox;
    }

    private JCheckBox getManageConflictsCheckBox() {
        if (this.manageConflictsCheckBox == null) {
            this.manageConflictsCheckBox = new JCheckBox();
            this.manageConflictsCheckBox.setText(I18N.getInstance().get(KEY + ".manage-conflicts"));
            String s1 = I18N.getInstance().get(KEY + ".manage-conflicts-tooltip");
            this.manageConflictsCheckBox.setToolTipText("<html>" + s1 + "</html>");
            this.manageConflictsCheckBox.setSelected(true);
        }
        return this.manageConflictsCheckBox;
    }

    private void populateGeometryAttributeComboBox() {
        if (this.getConnectionDescriptor() == null) {
            return;
        }
        if (this.getDatasetName() == null) {
            return;
        }
        if (this.getDatasetName().length() == 0) {
            return;
        }
        try {
            GeometryColumn selectedGeometryColumn = this.getGeometryColumn();
            this.geometryAttributeComboBox.setModel(new DefaultComboBoxModel<GeometryColumn>(this.sortGeometryColumns(this.getGeometryAttributes(this.getDatasetName(), this.getConnectionDescriptor()))));
            this.geometryAttributeComboBox.setSelectedItem(selectedGeometryColumn);
        }
        catch (Exception e) {
            this.getContext().getErrorHandler().handleThrowable(e);
            this.geometryAttributeComboBox.setModel(new DefaultComboBoxModel());
        }
    }

    private void populateIdentifierAttributeComboBox() {
        if (this.getConnectionDescriptor() == null) {
            return;
        }
        if (this.getDatasetName() == null) {
            return;
        }
        if (this.getDatasetName().length() == 0) {
            return;
        }
        try {
            PrimaryKeyColumn selectedIdentifierColumn = this.getIdentifierColumn();
            PrimaryKeyColumn[] pks = this.sortIdentifierColumns(this.getIdentifierAttributes(this.getDatasetName(), this.getConnectionDescriptor()));
            this.identifierAttributeComboBox.setModel(new DefaultComboBoxModel<PrimaryKeyColumn>(pks));
            if (pks.length > 0) {
                this.identifierAttributeComboBox.setSelectedItem(selectedIdentifierColumn);
            }
        }
        catch (Exception e) {
            this.getContext().getErrorHandler().handleThrowable(e);
            this.identifierAttributeComboBox.setModel(new DefaultComboBoxModel());
        }
    }

    private GeometryColumn[] sortGeometryColumns(List<GeometryColumn> list) {
        Collections.sort(list, new Comparator<GeometryColumn>(){

            @Override
            public int compare(GeometryColumn o1, GeometryColumn o2) {
                return o1.getName().compareTo(o2.getName());
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        return list.toArray(new GeometryColumn[list.size()]);
    }

    private PrimaryKeyColumn[] sortIdentifierColumns(List<PrimaryKeyColumn> list) {
        Collections.sort(list, new Comparator<PrimaryKeyColumn>(){

            @Override
            public int compare(PrimaryKeyColumn o1, PrimaryKeyColumn o2) {
                return o1.getName().compareTo(o2.getName());
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        return list.toArray(new PrimaryKeyColumn[list.size()]);
    }

    private void populateDatasetComboBox() {
        if (this.getConnectionDescriptor() == null) {
            return;
        }
        try {
            String selectedDatasetName = this.getDatasetName();
            Object[] datasetNames = this.datasetNames(this.getConnectionDescriptor());
            if (datasetNames != null) {
                this.datasetComboBox.setModel(new DefaultComboBoxModel<Object>(this.sortByString(datasetNames)));
                this.datasetComboBox.setSelectedItem(selectedDatasetName);
            }
        }
        catch (Exception e) {
            this.getContext().getErrorHandler().handleThrowable(e);
            this.datasetComboBox.setModel(new DefaultComboBoxModel());
        }
    }

    private List<GeometryColumn> getGeometryAttributes(final String datasetName, final ConnectionDescriptor connectionDescriptor) throws Exception {
        new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
        return AddWritableDataStoreLayerPanel.runInKillableThread(I18N.getInstance().get(KEY + ".retrieving-list-of-geometry-attributes"), this.getContext(), new Block<List<GeometryColumn>>(){

            @Override
            public List<GeometryColumn> yield() throws Exception {
                try {
                    return new PasswordPrompter().getOpenConnection(AddWritableDataStoreLayerPanel.this.connectionManager(), connectionDescriptor, AddWritableDataStoreLayerPanel.this).getMetadata().getGeometryAttributes(datasetName);
                }
                catch (Exception e) {
                    Logger.warn("Exception thrown while retrieving GeometryColumns from the database", e);
                    return new ArrayList<GeometryColumn>();
                }
            }
        });
    }

    private List<PrimaryKeyColumn> getIdentifierAttributes(final String datasetName, final ConnectionDescriptor connectionDescriptor) throws Exception {
        new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
        return AddWritableDataStoreLayerPanel.runInKillableThread(I18N.getInstance().get(KEY + ".retrieving-list-of-geometry-attributes"), this.getContext(), new Block<List<PrimaryKeyColumn>>(){

            @Override
            public List<PrimaryKeyColumn> yield() throws Exception {
                try {
                    return new PasswordPrompter().getOpenConnection(AddWritableDataStoreLayerPanel.this.connectionManager(), connectionDescriptor, AddWritableDataStoreLayerPanel.this).getMetadata().getPrimaryKeyColumns(datasetName);
                }
                catch (Exception e) {
                    Logger.warn("Exception thrown while retrieving PrimaryKeyColumn from the database", e);
                    return new ArrayList<PrimaryKeyColumn>();
                }
            }
        });
    }

    private String[] datasetNames(final ConnectionDescriptor connectionDescriptor) throws Exception {
        new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
        String[] datasetNames = AddWritableDataStoreLayerPanel.runInKillableThread(I18N.getInstance().get(KEY + ".retrieving-list-of-tables"), this.getContext(), new Block<String[]>(){

            @Override
            public String[] yield() throws Exception {
                return new PasswordPrompter().getOpenConnection(AddWritableDataStoreLayerPanel.this.connectionManager(), connectionDescriptor, AddWritableDataStoreLayerPanel.this).getMetadata().getDatasetNames();
            }
        });
        if (datasetNames != null && datasetNames.length != 0) {
            this.connectionDescriptorToDatasetNamesMap.put(connectionDescriptor, datasetNames);
        }
        return this.connectionDescriptorToDatasetNamesMap.get(connectionDescriptor);
    }

    private void initialize() {
        JScrollPane sp = new JScrollPane(this.getWhereTextArea());
        sp.setPreferredSize(new Dimension(550, 100));
        this.addRow("Dataset", this.getDatasetComboBox(), null, false);
        this.addRow("Geometry", this.getGeometryAttributeComboBox(), null, false);
        this.addRow("Identifier", this.getIdentifierAttributeComboBox(), null, false);
        this.addRow("Max-Features", this.getMaxFeaturesTextField(), null, false);
        this.addRow("Where", sp, null, true);
        this.addRow(null, this.getLimitedToViewCheckBox(), null, false);
        this.addRow(null, this.getManageConflictsCheckBox(), null, true);
    }

    private void addSafePopupListener(final JComboBox comboBox, final Block listener) {
        comboBox.addPopupMenuListener(new PopupMenuListener(){
            private boolean ignoringPopupEvent = false;

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (this.ignoringPopupEvent) {
                    this.ignoringPopupEvent = false;
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        comboBox.hidePopup();
                        try {
                            listener.yield();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            ignoringPopupEvent = true;
                            comboBox.showPopup();
                        }
                    }
                });
            }
        });
    }

    public static interface Block<T> {
        public T yield() throws Exception;
    }
}

