/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.AbstractSelectionRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectionStyllingOptionsPanel
extends JPanel
implements OptionsPanel {
    public static final String BB_SELECTION_STYLE_COLOR = SelectionStyllingOptionsPanel.class.getName() + " SELECTION_STYLE_COLOR";
    public static final String BB_SELECTION_STYLE_FILL_COLOR = SelectionStyllingOptionsPanel.class.getName() + " SELECTION_STYLE_FILL_COLOR";
    public static final String BB_SELECTION_STYLE_FILL_OPACITY = SelectionStyllingOptionsPanel.class.getName() + " SELECTION_STYLE_FILL_OPACITY";
    public static final String BB_SELECTION_STYLE_POINT_FORM = SelectionStyllingOptionsPanel.class.getName() + " SELECTION_STYLE_POINT_FORM";
    public static final String BB_SELECTION_STYLE_POINT_SIZE = SelectionStyllingOptionsPanel.class.getName() + " SELECTION_STYLE_POINT_SIZE";
    public static final Color DEFAULT_SELECTION_STYLE_COLOR = Color.yellow;
    public static final Color DEFAULT_SELECTION_STYLE_FILL_COLOR = GUIUtil.alphaColor(Color.white, 75);
    public static final int DEFAULT_SELECTION_STYLE_FILL_OPACITY = 75;
    public static final String DEFAULT_SELECTION_STYLE_POINT_FORM = "SQUARE";
    public static final Integer DEFAULT_SELECTION_STYLE_POINT_SIZE = 5;
    private JPanel mainPanel;
    private JLabel lineColorLabel;
    private ColorChooserPanel lineColorChooserPanel;
    private JLabel fillColorLabel;
    private ColorChooserPanel fillColorChooserPanel;
    private JLabel fillOpacityLabel;
    private JSlider fillOpacitySlider;
    private JComboBox pointStyleComboBox;
    private JLabel pointStyleLabel;
    private JLabel pointSizeLabel;
    private JSlider pointSizeSlider;
    private JPanel fillPanel;
    private JButton restoreDefaultsButton;
    private Blackboard blackboard = null;
    private WorkbenchContext context = null;

    public SelectionStyllingOptionsPanel(WorkbenchContext context) {
        this.context = context;
        this.blackboard = PersistentBlackboardPlugIn.get(context);
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.lineColorLabel = new JLabel();
        this.lineColorChooserPanel = new ColorChooserPanel();
        this.fillColorLabel = new JLabel();
        this.fillColorChooserPanel = new ColorChooserPanel();
        this.fillOpacityLabel = new JLabel();
        this.fillOpacitySlider = new JSlider();
        this.pointStyleLabel = new JLabel();
        this.restoreDefaultsButton = new JButton();
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionStyllingOptionsPanel.this.lineColorChooserPanel.setColor(DEFAULT_SELECTION_STYLE_COLOR);
                SelectionStyllingOptionsPanel.this.fillColorChooserPanel.setColor(DEFAULT_SELECTION_STYLE_FILL_COLOR);
                SelectionStyllingOptionsPanel.this.fillOpacitySlider.setValue(75);
                SelectionStyllingOptionsPanel.this.pointSizeSlider.setValue(DEFAULT_SELECTION_STYLE_POINT_SIZE);
                int count = SelectionStyllingOptionsPanel.this.pointStyleComboBox.getItemCount();
                for (int i = 0; i < count; ++i) {
                    String[] item = (String[])SelectionStyllingOptionsPanel.this.pointStyleComboBox.getItemAt(i);
                    if (!item[1].equals(SelectionStyllingOptionsPanel.DEFAULT_SELECTION_STYLE_POINT_FORM)) continue;
                    SelectionStyllingOptionsPanel.this.pointStyleComboBox.setSelectedIndex(i);
                    break;
                }
            }
        });
        this.lineColorChooserPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserPanel ccp = (ColorChooserPanel)e.getSource();
                ccp.setAlpha(255);
            }
        });
        this.lineColorChooserPanel.setAlpha(255);
        this.fillColorChooserPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserPanel ccp = (ColorChooserPanel)e.getSource();
                ccp.setAlpha(SelectionStyllingOptionsPanel.this.fillOpacitySlider.getValue());
            }
        });
        this.fillOpacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectionStyllingOptionsPanel.this.fillColorChooserPanel.setAlpha(((JSlider)e.getSource()).getValue());
            }
        });
        this.pointStyleComboBox = new JComboBox();
        this.pointStyleComboBox.setRenderer(new ComboRenderer());
        this.pointStyleComboBox.setEditable(false);
        this.pointStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.square"), DEFAULT_SELECTION_STYLE_POINT_FORM});
        this.pointStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.circle"), "CIRCLE"});
        this.pointStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.triangle"), "TRIANGLE"});
        this.pointStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.cross"), "CROSS"});
        this.pointStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.star"), "STAR"});
        this.pointSizeLabel = new JLabel();
        this.pointSizeSlider = new JSlider();
        this.fillPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.mainPanel.setLayout(new GridBagLayout());
        this.add((Component)this.mainPanel, "Center");
        this.lineColorLabel.setText(I18N.getInstance().get("ui.SelectionStyllingOptionsPanel.LineColor"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.lineColorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.lineColorChooserPanel, gridBagConstraints);
        this.fillColorLabel.setText(I18N.getInstance().get("ui.SelectionStyllingOptionsPanel.FillColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.fillColorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.fillColorChooserPanel, gridBagConstraints);
        this.fillOpacityLabel.setText(I18N.getInstance().get("ui.SelectionStyllingOptionsPanel.FillOpacity"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.fillOpacityLabel, gridBagConstraints);
        Hashtable<Integer, JLabel> opLabelTable = new Hashtable<Integer, JLabel>();
        opLabelTable.put(new Integer(0), new JLabel("0"));
        opLabelTable.put(new Integer(64), new JLabel("64"));
        opLabelTable.put(new Integer(128), new JLabel("128"));
        opLabelTable.put(new Integer(192), new JLabel("192"));
        opLabelTable.put(new Integer(255), new JLabel("255"));
        this.fillOpacitySlider.setLabelTable(opLabelTable);
        this.fillOpacitySlider.setMinorTickSpacing(1);
        this.fillOpacitySlider.setMajorTickSpacing(0);
        this.fillOpacitySlider.setPaintLabels(true);
        this.fillOpacitySlider.setMinimum(0);
        this.fillOpacitySlider.setValue(75);
        this.fillOpacitySlider.setMaximum(255);
        this.fillOpacitySlider.setSnapToTicks(false);
        this.fillOpacitySlider.setPreferredSize(new Dimension(130, 49));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.fillOpacitySlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)GUIUtil.createSyncdTextField(this.fillOpacitySlider, 3), gridBagConstraints);
        this.pointStyleLabel.setText(I18N.getInstance().get("ui.SelectionStyllingOptionsPanel.PointStyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.pointStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.pointStyleComboBox, gridBagConstraints);
        this.pointSizeLabel.setText(I18N.getInstance().get("ui.SelectionStyllingOptionsPanel.PointSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.pointSizeLabel, gridBagConstraints);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("1"));
        labelTable.put(new Integer(5), new JLabel("5"));
        labelTable.put(new Integer(10), new JLabel("10"));
        labelTable.put(new Integer(15), new JLabel("15"));
        labelTable.put(new Integer(20), new JLabel("20"));
        this.pointSizeSlider.setLabelTable(labelTable);
        this.pointSizeSlider.setMinorTickSpacing(1);
        this.pointSizeSlider.setMajorTickSpacing(0);
        this.pointSizeSlider.setPaintLabels(true);
        this.pointSizeSlider.setMinimum(1);
        this.pointSizeSlider.setValue(2);
        this.pointSizeSlider.setMaximum(20);
        this.pointSizeSlider.setSnapToTicks(true);
        this.pointSizeSlider.setPreferredSize(new Dimension(130, 49));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.pointSizeSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)GUIUtil.createSyncdTextField(this.pointSizeSlider, 3), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.fillPanel, gridBagConstraints);
        this.restoreDefaultsButton.setText(I18N.getInstance().get("ui.SelectionStyllingOptionsPanel.RestoreDefaultsSettings"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.restoreDefaultsButton, gridBagConstraints);
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public void okPressed() {
        this.blackboard.put(BB_SELECTION_STYLE_COLOR, this.lineColorChooserPanel.getColor());
        this.blackboard.put(BB_SELECTION_STYLE_FILL_COLOR, this.fillColorChooserPanel.getColor());
        this.blackboard.put(BB_SELECTION_STYLE_FILL_OPACITY, this.fillColorChooserPanel.getAlpha());
        this.blackboard.put(BB_SELECTION_STYLE_POINT_SIZE, this.pointSizeSlider.getValue());
        this.blackboard.put(BB_SELECTION_STYLE_POINT_FORM, ((String[])this.pointStyleComboBox.getSelectedItem())[1]);
        LayerViewPanel layerViewPanel = this.context.getLayerViewPanel();
        if (layerViewPanel != null) {
            AbstractSelectionRenderer renderer = (AbstractSelectionRenderer)layerViewPanel.getRenderingManager().getRenderer("SELECTED_FEATURES");
            renderer.setSelectionLineColor(this.lineColorChooserPanel.getColor());
            renderer.setSelectionFillColor(GUIUtil.alphaColor(this.fillColorChooserPanel.getColor(), this.fillColorChooserPanel.getAlpha()));
            renderer.setSelectionPointSize(this.pointSizeSlider.getValue());
            renderer.setSelectionPointForm(((String[])this.pointStyleComboBox.getSelectedItem())[1]);
            layerViewPanel.repaint();
        }
    }

    @Override
    public void init() {
        Object size;
        Integer opacity;
        Object color = this.blackboard.get(BB_SELECTION_STYLE_COLOR, DEFAULT_SELECTION_STYLE_COLOR);
        if (color instanceof Color) {
            this.lineColorChooserPanel.setColor((Color)color);
        }
        if ((color = this.blackboard.get(BB_SELECTION_STYLE_FILL_COLOR, DEFAULT_SELECTION_STYLE_COLOR)) instanceof Color) {
            this.fillColorChooserPanel.setColor((Color)color);
        }
        if ((opacity = Integer.valueOf(this.blackboard.get(BB_SELECTION_STYLE_FILL_OPACITY, 75))) instanceof Integer) {
            this.fillOpacitySlider.setValue(this.blackboard.get(BB_SELECTION_STYLE_FILL_OPACITY, 75));
        }
        if ((size = this.blackboard.get(BB_SELECTION_STYLE_POINT_SIZE, DEFAULT_SELECTION_STYLE_POINT_SIZE)) instanceof Integer) {
            this.pointSizeSlider.setValue((Integer)this.blackboard.get(BB_SELECTION_STYLE_POINT_SIZE, DEFAULT_SELECTION_STYLE_POINT_SIZE));
        }
        String style = (String)this.blackboard.get(BB_SELECTION_STYLE_POINT_FORM, DEFAULT_SELECTION_STYLE_POINT_FORM);
        int count = this.pointStyleComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            String[] item = (String[])this.pointStyleComboBox.getItemAt(i);
            if (!item[1].equals(style)) continue;
            this.pointStyleComboBox.setSelectedIndex(i);
            break;
        }
    }

    private class ComboRenderer
    implements ListCellRenderer {
        private ComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel(((String[])value)[0]);
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(new Color(163, 184, 204));
            }
            return label;
        }
    }
}

