/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.workbench.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.ui.ColorsTablePanel;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;
import org.openjump.core.rasterimage.styler.ui.GradientTablePanel;

public class CustomGradientColorsDialog
extends JDialog {
    private JButton jButton_AddRow;
    private JButton jButton_Cancel;
    private JButton jButton_Ok;
    private JButton jButton_RemoveRow;
    private JLabel jLabel_Max;
    private JLabel jLabel_Min;
    private JPanel jPanel_ColorTable;
    private JPanel jPanel_Gradient;
    private JPanel jPanel_Table;
    private GradientTablePanel colorsTablePanel;
    private ColorMapEntry[] colorMapEntries;

    public CustomGradientColorsDialog(Frame parent, boolean modal, ColorMapEntry[] colorMapEntries) {
        super(parent, modal);
        this.colorMapEntries = colorMapEntries;
        this.initComponents();
        this.fixComponents();
    }

    private void initComponents() {
        this.jPanel_ColorTable = new JPanel();
        this.jButton_RemoveRow = new JButton();
        this.jButton_AddRow = new JButton();
        this.jPanel_Table = new JPanel();
        this.jPanel_Gradient = new JPanel();
        this.jLabel_Min = new JLabel();
        this.jLabel_Max = new JLabel();
        this.jButton_Cancel = new JButton();
        this.jButton_Ok = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(340, 220));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_ColorTable.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel_ColorTable.setMinimumSize(new Dimension(300, 200));
        this.jPanel_ColorTable.setPreferredSize(new Dimension(320, 150));
        this.jPanel_ColorTable.setLayout(new GridBagLayout());
        this.jButton_RemoveRow.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_RemoveRow.text"));
        this.jButton_RemoveRow.setToolTipText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_RemoveRow.toolTipText"));
        this.jButton_RemoveRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomGradientColorsDialog.this.jButton_RemoveRowActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 2);
        this.jPanel_ColorTable.add((Component)this.jButton_RemoveRow, gridBagConstraints);
        this.jButton_AddRow.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_AddRow.text"));
        this.jButton_AddRow.setMaximumSize(new Dimension(93, 23));
        this.jButton_AddRow.setMinimumSize(new Dimension(93, 23));
        this.jButton_AddRow.setPreferredSize(new Dimension(93, 23));
        this.jButton_AddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomGradientColorsDialog.this.jButton_AddRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.jPanel_ColorTable.add((Component)this.jButton_AddRow, gridBagConstraints);
        this.jPanel_Table.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel_Table.setMinimumSize(new Dimension(250, 80));
        this.jPanel_Table.setPreferredSize(new Dimension(250, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel_ColorTable.add((Component)this.jPanel_Table, gridBagConstraints);
        this.jPanel_Gradient.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel_Gradient.setMinimumSize(new Dimension(40, 80));
        this.jPanel_Gradient.setPreferredSize(new Dimension(40, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel_ColorTable.add((Component)this.jPanel_Gradient, gridBagConstraints);
        this.jLabel_Min.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jLabel_Min.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel_ColorTable.add((Component)this.jLabel_Min, gridBagConstraints);
        this.jLabel_Max.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jLabel_Max.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 10);
        this.jPanel_ColorTable.add((Component)this.jLabel_Max, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.getContentPane().add((Component)this.jPanel_ColorTable, gridBagConstraints);
        this.jButton_Cancel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_Cancel.text"));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomGradientColorsDialog.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_Ok.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_Ok.text"));
        this.jButton_Ok.setMaximumSize(new Dimension(65, 23));
        this.jButton_Ok.setMinimumSize(new Dimension(65, 23));
        this.jButton_Ok.setPreferredSize(new Dimension(65, 23));
        this.jButton_Ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomGradientColorsDialog.this.jButton_OkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.jButton_Ok, gridBagConstraints);
        this.pack();
    }

    private void jButton_AddRowActionPerformed(ActionEvent evt) {
        this.addRow();
    }

    private void jButton_RemoveRowActionPerformed(ActionEvent evt) {
        this.removeRow();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.colorMapEntries = null;
        this.dispose();
    }

    private void jButton_OkActionPerformed(ActionEvent evt) {
        try {
            this.okButton();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void fixComponents() {
        this.setTitle("Raster Styles");
        this.colorsTablePanel = new GradientTablePanel(this, ColorsTablePanel.TableType.VALUES, this.colorMapEntries, -9999.0, false, this.jPanel_Gradient);
        this.colorsTablePanel.setMinimumSize(new Dimension(250, 80));
        this.colorsTablePanel.setPreferredSize(new Dimension(250, 80));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel_ColorTable.remove(this.jPanel_Table);
        this.jPanel_ColorTable.add((Component)this.colorsTablePanel, gridBagConstraints);
        GUIUtils utils = new GUIUtils();
        utils.setGradientPanel(this.jPanel_Gradient, this.colorMapEntries);
        this.validate();
    }

    private void okButton() throws Exception {
        ColorMapEntry[] cme = this.colorsTablePanel.getColorMapEntries();
        if (cme.length < 2) {
            JOptionPane.showMessageDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.GradientTablePanel.ColorsNumber.message"), "Raster Styles", 1);
            return;
        }
        double[] values = new double[cme.length];
        for (int n = 0; n < values.length; ++n) {
            values[n] = cme[n].getUpperValue();
        }
        double tempValue = values[0];
        for (int v = 1; v < values.length; ++v) {
            if (values[v] <= tempValue || values[v] > 1.0) {
                JOptionPane.showMessageDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.GradientTablePanel.FractionValues.message"), "Raster Styles", 1);
                return;
            }
            tempValue = values[v];
        }
        this.colorMapEntries = cme;
        this.dispose();
    }

    public ColorMapEntry[] getColorMapEntries() {
        return this.colorMapEntries;
    }

    private void addRow() {
        this.colorsTablePanel.addRows();
    }

    private void removeRow() {
        this.colorsTablePanel.removeRow();
    }
}

