/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codecimpl.TIFFCodec;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import com.vividsolutions.jump.workbench.model.LayerManager;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.rasterimage.sextante.AbstractSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridExtent;

public class OpenJUMPSextanteRasterLayer
extends AbstractSextanteRasterLayer {
    private static final double DEFAULT_NO_DATA_VALUE = -99999.0;
    private String m_sFilename;
    private String m_sName = "";
    private GridExtent m_LayerExtent;
    private double m_dNoDataValue;
    private Raster m_Raster;

    public void create(RasterImageLayer layer) throws IOException {
        this.create(layer, true);
    }

    public void create(RasterImageLayer layer, boolean loadFromFile) throws IOException {
        if (!loadFromFile) {
            this.m_BaseDataObject = layer;
            this.m_Raster = layer.getRasterData(null);
            this.m_sName = layer.getName();
            this.m_sFilename = layer.getImageFileName();
            Envelope env = layer.getActualImageEnvelope();
            this.m_LayerExtent = new GridExtent();
            this.m_LayerExtent.setCellSize((env.getMaxX() - env.getMinX()) / (double)this.m_Raster.getWidth(), (env.getMaxY() - env.getMinY()) / (double)this.m_Raster.getHeight());
            this.m_LayerExtent.setXRange(env.getMinX(), env.getMaxX());
            this.m_LayerExtent.setYRange(env.getMinY(), env.getMaxY());
            this.m_dNoDataValue = layer.getNoDataValue();
        } else {
            RasterImageLayer rasterLayer = new RasterImageLayer(layer.getName(), layer.getLayerManager(), layer.getImageFileName(), null, layer.getWholeImageEnvelope());
            this.m_BaseDataObject = rasterLayer;
            this.m_Raster = rasterLayer.getRasterData(null);
            this.m_sName = rasterLayer.getName();
            this.m_sFilename = rasterLayer.getImageFileName();
            Envelope env = rasterLayer.getWholeImageEnvelope();
            this.m_LayerExtent = new GridExtent();
            this.m_LayerExtent.setCellSize((env.getMaxX() - env.getMinX()) / (double)this.m_Raster.getWidth(), (env.getMaxY() - env.getMinY()) / (double)this.m_Raster.getHeight());
            this.m_LayerExtent.setXRange(env.getMinX(), env.getMaxX());
            this.m_LayerExtent.setYRange(env.getMinY(), env.getMaxY());
            this.m_dNoDataValue = layer.getNoDataValue();
        }
    }

    public void create(String name, String filename, GridExtent ge, int dataType, int numBands, Object crs, LayerManager layerManager) {
        this.m_Raster = RasterFactory.createBandedRaster((int)dataType, (int)ge.getNX(), (int)ge.getNY(), (int)numBands, null);
        Envelope envelope = new Envelope();
        envelope.init(ge.getXMin(), ge.getXMax(), ge.getYMin(), ge.getYMax());
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)this.m_Raster.getSampleModel());
        BufferedImage bufimg = new BufferedImage(colorModel, (WritableRaster)this.m_Raster, false, null);
        this.m_BaseDataObject = new RasterImageLayer(name, layerManager, filename, bufimg, envelope);
        this.m_sName = name;
        this.m_sFilename = filename;
        this.m_LayerExtent = ge;
        this.m_dNoDataValue = -99999.0;
    }

    @Override
    public void fitToGridExtent(GridExtent ge, LayerManager layerManager) {
        WritableRaster raster = RasterFactory.createBandedRaster((int)this.m_Raster.getDataBuffer().getDataType(), (int)ge.getNX(), (int)ge.getNY(), (int)this.m_Raster.getNumBands(), null);
        this.setWindowExtent(ge);
        for (int x = 0; x < ge.getNX(); ++x) {
            for (int y = 0; y < ge.getNY(); ++y) {
                for (int i = 0; i < this.getBandsCount(); ++i) {
                    raster.setSample(x, y, i, this.getCellValueAsDouble(x, y, i));
                }
            }
        }
        Envelope envelope = new Envelope();
        envelope.init(ge.getXMin(), ge.getXMax(), ge.getYMin(), ge.getYMax());
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)this.m_Raster.getSampleModel());
        BufferedImage bufimg = new BufferedImage(colorModel, (WritableRaster)this.m_Raster, false, null);
        RasterImageLayer imageLayer = new RasterImageLayer(this.m_sName, layerManager, this.m_sFilename, bufimg, envelope);
        this.m_Raster = raster;
        this.m_BaseDataObject = imageLayer;
        this.m_LayerExtent = ge;
    }

    @Override
    public int getBandsCount() {
        if (this.m_Raster != null) {
            return this.m_Raster.getNumBands();
        }
        return 0;
    }

    @Override
    public double getCellValueInLayerCoords(int x, int y, int band) {
        if (this.m_Raster != null) {
            return this.m_Raster.getSampleDouble(x, y, band);
        }
        return this.getNoDataValue();
    }

    @Override
    public int getDataType() {
        if (this.m_Raster != null) {
            return this.m_Raster.getDataBuffer().getDataType();
        }
        return 5;
    }

    @Override
    public Point2D.Double getLayerCellSize() {
        if (this.m_LayerExtent != null) {
            return this.m_LayerExtent.getCellSize();
        }
        return new Point2D.Double(0.0, 0.0);
    }

    @Override
    public GridExtent getLayerGridExtent() {
        return this.m_LayerExtent;
    }

    @Override
    public double getNoDataValue() {
        return this.m_dNoDataValue;
    }

    @Override
    public void setCellValue(int x, int y, int band, double value) {
        if (this.m_Raster instanceof WritableRaster && this.getWindowGridExtent().containsCell(x, y)) {
            ((WritableRaster)this.m_Raster).setSample(x, y, band, value);
        }
    }

    @Override
    public void setNoDataValue(double noDataValue) {
        this.m_dNoDataValue = noDataValue;
    }

    @Override
    public Object getCRS() {
        return null;
    }

    @Override
    public Rectangle2D getFullExtent() {
        if (this.m_BaseDataObject != null) {
            RasterImageLayer layer = (RasterImageLayer)this.m_BaseDataObject;
            Envelope envelope = layer.getWholeImageEnvelope();
            return new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
        }
        return null;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void postProcess() throws Exception {
        if (this.m_BaseDataObject != null) {
            RasterImageLayer layer = (RasterImageLayer)this.m_BaseDataObject;
            FileOutputStream tifOut = new FileOutputStream(this.m_sFilename);
            TIFFEncodeParam param = new TIFFEncodeParam();
            param.setCompression(1);
            TIFFImageEncoder encoder = (TIFFImageEncoder)TIFFCodec.createImageEncoder((String)"tiff", (OutputStream)tifOut, (ImageEncodeParam)param);
            ColorModel colorModel = PlanarImage.createColorModel((SampleModel)this.m_Raster.getSampleModel());
            BufferedImage image = new BufferedImage(colorModel, (WritableRaster)this.m_Raster, false, null);
            encoder.encode((RenderedImage)image);
            tifOut.close();
            Envelope envelope = layer.getWholeImageEnvelope();
            WorldFileHandler worldFileHandler = new WorldFileHandler(this.m_sFilename, false);
            worldFileHandler.writeWorldFile(envelope, image.getWidth(), image.getHeight());
            layer.setImageFileName(this.m_sFilename);
            layer.setNeedToKeepImage(false);
        }
    }

    @Override
    public String getFilename() {
        return this.m_sFilename;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void setName(String sName) {
        this.m_sName = sName;
        if (this.m_BaseDataObject != null) {
            RasterImageLayer layer = (RasterImageLayer)this.m_BaseDataObject;
            layer.setName(sName);
        }
    }
}

