/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

public class Stats {
    private final int bandCount;
    private final double[] min;
    private final double[] max;
    private final double[] mean;
    private final double[] stdDev;

    public Stats(int bandCount) {
        this.bandCount = bandCount;
        this.min = new double[bandCount];
        this.max = new double[bandCount];
        this.mean = new double[bandCount];
        this.stdDev = new double[bandCount];
    }

    public void setStatsForBand(int band, double min, double max, double mean, double stdDev) {
        this.min[band] = min;
        this.max[band] = max;
        this.mean[band] = mean;
        this.stdDev[band] = stdDev;
    }

    public int getBandCount() {
        return this.bandCount;
    }

    public double getMin(int band) {
        return this.min[band];
    }

    public double getMax(int band) {
        return this.max[band];
    }

    public double getMean(int band) {
        return this.mean[band];
    }

    public double getStdDev(int band) {
        return this.stdDev[band];
    }

    public static Stats defaultRGBStats() {
        Stats stats = new Stats(3);
        stats.setStatsForBand(0, 0.0, 255.0, 127.0, 30.0);
        stats.setStatsForBand(1, 0.0, 255.0, 127.0, 30.0);
        stats.setStatsForBand(2, 0.0, 255.0, 127.0, 30.0);
        return stats;
    }
}

