/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.polygongraph;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.openjump.core.graph.polygongraph.PolygonGraphNode;

public class PolygonGraphEdge {
    private static int edgeIds = 0;
    public int edgeId = -1;
    public PolygonGraphNode node1 = null;
    public PolygonGraphNode node2 = null;
    private ArrayList<Geometry> boundaries = new ArrayList();
    public boolean boundaryCalculated = false;

    public PolygonGraphEdge(PolygonGraphNode node1, PolygonGraphNode node2) {
        this.node1 = node1;
        this.node2 = node2;
        this.edgeId = ++edgeIds;
    }

    private void calculateBoundary() {
        this.boundaryCalculated = true;
        Geometry intersection = this.node1.geometry.intersection(this.node2.geometry);
        LineMerger lineMerger = new LineMerger();
        for (int i = 0; i < intersection.getNumGeometries(); ++i) {
            lineMerger.add(intersection.getGeometryN(i));
        }
        Collection edges = lineMerger.getMergedLineStrings();
        this.boundaries.addAll(edges);
    }

    public boolean hasNodes(int nodeId1, int nodeId2) {
        boolean found = false;
        if (!(this.node1.nodeId != nodeId1 && this.node1.nodeId != nodeId2 || this.node2.nodeId != nodeId1 && this.node2.nodeId != nodeId2)) {
            found = true;
            return true;
        }
        return found;
    }

    public LineString getEdgeAsInterriorPointLineString() {
        LineString ls = null;
        Coordinate[] coords = new Coordinate[2];
        Point c1 = this.node1.geometry.getInteriorPoint();
        Point c2 = this.node2.geometry.getInteriorPoint();
        coords[0] = new Coordinate(c1.getX(), c1.getY());
        coords[1] = new Coordinate(c2.getX(), c2.getY());
        ls = new GeometryFactory().createLineString(coords);
        return ls;
    }

    public Feature getEdgeBetweenInterriorPointsAsFeature() {
        BasicFeature f = new BasicFeature(PolygonGraphEdge.getEdgeFeatureSchema());
        f.setGeometry((Geometry)this.getEdgeAsInterriorPointLineString());
        f.setAttribute("edgeId", (Object)this.edgeId);
        f.setAttribute("startNode", (Object)this.node1.nodeId);
        f.setAttribute("endNode", (Object)this.node2.nodeId);
        return f;
    }

    public static FeatureSchema getEdgeFeatureSchema() {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("Geometry", AttributeType.GEOMETRY);
        fs.addAttribute("edgeId", AttributeType.INTEGER);
        fs.addAttribute("startNode", AttributeType.INTEGER);
        fs.addAttribute("endNode", AttributeType.INTEGER);
        return fs;
    }

    public ArrayList<Geometry> getBoundaries() {
        if (!this.boundaryCalculated) {
            this.calculateBoundary();
            this.boundaryCalculated = true;
        }
        return this.boundaries;
    }

    public ArrayList<Feature> getBoundariesAsFeature() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Feature> fbds = new ArrayList<Feature>();
        ArrayList<Geometry> geoms = this.getBoundaries();
        int bdcount = 0;
        for (Geometry geometry : geoms) {
            ++bdcount;
            BasicFeature fnew = new BasicFeature(PolygonGraphNode.getBoundaryFeatureSchema());
            if (geometry instanceof LinearRing) {
                geometry = gf.createLineString(((LinearRing)geometry).getCoordinateSequence());
            }
            fnew.setGeometry(geometry);
            fnew.setAttribute("edgeId", (Object)this.edgeId);
            fnew.setAttribute("boundaryId", (Object)bdcount);
            fnew.setAttribute("startNode", (Object)this.node1.nodeId);
            fnew.setAttribute("endNode", (Object)this.node2.nodeId);
            fbds.add(fnew);
        }
        return fbds;
    }
}

