/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.pirolProject;

import org.locationtech.jts.geom.Coordinate;
import org.openjump.core.apitools.comparisonandsorting.CoordinateComparator;
import org.openjump.core.apitools.comparisonandsorting.Sortable;
import org.openjump.core.graph.pirolProject.ScaleChanger;

public class PirolPoint
extends Sortable {
    protected double[] coordinates = null;
    protected int dimension = 0;
    protected int index = -1;
    public static final PirolPoint NULLPUNKT = new PirolPoint(new double[]{0.0, 0.0, 0.0});
    protected ScaleChanger scaler = null;
    protected boolean scaled = false;
    protected boolean marked = false;

    public PirolPoint() {
    }

    public PirolPoint(double[] coords) {
        this.coordinates = coords;
        this.index = -1;
        this.dimension = coords.length;
    }

    public PirolPoint(double[] coords, int index) {
        this.coordinates = coords;
        this.index = index;
        this.dimension = coords.length;
    }

    public PirolPoint(double[] coords, int index, ScaleChanger scaler, boolean prescaled) {
        this.coordinates = coords;
        this.index = index;
        this.scaler = scaler;
        this.dimension = coords.length;
        this.scaled = prescaled;
    }

    public PirolPoint(double[] coords, int index, ScaleChanger scaler) {
        this.coordinates = coords;
        this.index = index;
        this.scaler = scaler;
        this.dimension = coords.length;
    }

    public static PirolPoint createVector(PirolPoint from, PirolPoint to) {
        int dim = Math.min(from.getDimension(), to.getDimension());
        double[] vectorComponents = new double[dim];
        for (int i = 0; i < dim; ++i) {
            try {
                vectorComponents[i] = to.getCoordinate(i) - from.getCoordinate(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PirolPoint(vectorComponents);
    }

    public static PirolPoint clone(PirolPoint pkt) {
        double[] newCoords = new double[pkt.getDimension()];
        for (int i = 0; i < pkt.getDimension(); ++i) {
            try {
                newCoords[i] = pkt.getCoordinate(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PirolPoint cloned = new PirolPoint(newCoords, pkt.index);
        cloned.setMarked(pkt.isMarked());
        cloned.setScaler(pkt.scaler);
        cloned.setSortFor(pkt.sortFor);
        return cloned;
    }

    public PirolPoint clonePunkt() {
        return PirolPoint.clone(this);
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean liegtAuf(PirolPoint p) {
        try {
            if (this == p) {
                return true;
            }
            if (p.getX() == this.getX() && p.getY() == this.getY()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean equals(Object obj) {
        PirolPoint p;
        try {
            p = (PirolPoint)obj;
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (this == p) {
                return true;
            }
            if (p.getIndex() == this.getIndex() && this.getIndex() >= 0) {
                return true;
            }
            if (Math.min(p.getDimension(), this.getDimension()) >= 3 && p.getX() == this.getX() && p.getY() == this.getY() && p.getZ() == this.getZ()) {
                return true;
            }
            if (p.getX() == this.getX() && p.getY() == this.getY()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getSortFor() {
        return this.sortFor;
    }

    @Override
    public void setSortFor(int sortFor) {
        this.sortFor = sortFor;
    }

    public void setScaler(ScaleChanger scaler) {
        this.scaler = scaler;
    }

    public void scale() throws RuntimeException {
        if (this.scaled || this.scaler == null) {
            return;
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.setCoordinate(this.scaler.scale(this.getCoordinate(i), i), i);
        }
        this.scaled = true;
    }

    public void unScale() throws RuntimeException {
        if (!this.scaled || this.scaler == null) {
            return;
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.setCoordinate(this.scaler.unScale(this.getCoordinate(i), i), i);
        }
        this.scaled = false;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        this.coordinates = coordinates;
        this.dimension = coordinates.length;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getCoordinate(int nr) {
        if (this.dimension > nr) {
            return this.coordinates[nr];
        }
        throw new RuntimeException("invalid dimension: " + nr + " (vs. " + this.dimension + ")");
    }

    public void setCoordinate(double newCoord, int nr) {
        if (this.dimension > nr) {
            this.coordinates[nr] = newCoord;
        }
    }

    public double getX() {
        return this.getCoordinate(0);
    }

    public double getY() {
        return this.getCoordinate(1);
    }

    public double getZ() {
        return this.getCoordinate(2);
    }

    public void setX(double val) {
        this.setCoordinate(val, 0);
    }

    public void setY(double val) {
        this.setCoordinate(val, 1);
    }

    public void setZ(double val) {
        this.setCoordinate(val, 2);
    }

    public double distanceTo(PirolPoint p) {
        return PirolPoint.distanceBetween(this, p);
    }

    public static double distanceBetween(PirolPoint p1, PirolPoint p2) {
        int checkDim = Math.min(p2.dimension, p1.getDimension());
        double checkSum = 0.0;
        for (int i = 0; i < checkDim; ++i) {
            checkSum += Math.pow(p2.getCoordinate(i) - p1.getCoordinate(i), 2.0);
        }
        return Math.sqrt(checkSum);
    }

    public String toString() {
        String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
        String str = className + " #" + this.index + "(";
        for (int i = 0; i < this.dimension; ++i) {
            try {
                double c = this.getCoordinate(i);
                if (this.scaled && this.scaler != null) {
                    c = this.scaler.unScale(c, i);
                }
                String tmp = Double.toString(c);
                str = str + tmp;
            }
            catch (Exception e) {
                str = str + "NAN";
                e.printStackTrace();
            }
            if (i == this.dimension - 1) continue;
            str = str + ",";
        }
        str = str + ")";
        return str;
    }

    @Override
    public int compareTo(Object arg0) {
        double remote;
        double local;
        if (this.getSortFor() != ((PirolPoint)arg0).getSortFor()) {
            return 0;
        }
        try {
            if (this.getSortFor() != CoordinateComparator.SORTFOR_XY) {
                local = this.getCoordinate(this.sortFor);
                remote = ((PirolPoint)arg0).getCoordinate(((PirolPoint)arg0).getSortFor());
            } else {
                local = this.getCoordinate(CoordinateComparator.SORTFOR_X) + this.getCoordinate(CoordinateComparator.SORTFOR_Y);
                remote = ((PirolPoint)arg0).getCoordinate(CoordinateComparator.SORTFOR_X) + ((PirolPoint)arg0).getCoordinate(CoordinateComparator.SORTFOR_Y);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        if (local < remote) {
            return -1;
        }
        if (local > remote) {
            return 1;
        }
        return 0;
    }

    public Coordinate toCoordinate() throws RuntimeException {
        return PirolPoint.toCoordinate(this);
    }

    public static Coordinate toCoordinate(PirolPoint p) throws RuntimeException {
        if (p.getDimension() == 2) {
            return new Coordinate(p.getX(), p.getY());
        }
        return new Coordinate(p.getX(), p.getY(), p.getZ());
    }
}

