/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;
import org.openjump.core.geomutils.Arc;
import org.openjump.core.geomutils.MathVector;

public class GeoUtils {
    public static final int emptyBit = 0;
    public static final int pointBit = 1;
    public static final int lineBit = 2;
    public static final int polyBit = 3;

    public static double mag(Coordinate q) {
        return Math.sqrt(q.x * q.x + q.y * q.y);
    }

    public static double distance(Coordinate p1, Coordinate p2) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static Coordinate unitVec(Coordinate q) {
        double m = GeoUtils.mag(q);
        if (m == 0.0) {
            m = 1.0;
        }
        return new Coordinate(q.x / m, q.y / m);
    }

    public static Coordinate vectorAdd(Coordinate q, Coordinate r) {
        return new Coordinate(q.x + r.x, q.y + r.y);
    }

    public static Coordinate vectorBetween(Coordinate q, Coordinate r) {
        return new Coordinate(r.x - q.x, r.y - q.y);
    }

    public static Coordinate vectorTimesScalar(Coordinate q, double m) {
        return new Coordinate(q.x * m, q.y * m);
    }

    public static double dot(Coordinate p, Coordinate q) {
        return p.x * q.x + p.y * q.y;
    }

    public static Coordinate rotPt(Coordinate inpt, Coordinate rpt, double theta) {
        double tr = Math.toRadians(theta);
        double ct = Math.cos(tr);
        double st = Math.sin(tr);
        double x = inpt.x - rpt.x;
        double y = inpt.y - rpt.y;
        double xout = rpt.x + x * ct + y * st;
        double yout = rpt.y + y * ct - st * x;
        return new Coordinate(xout, yout);
    }

    public static boolean pointToRight(Coordinate pt, Coordinate p1, Coordinate p2) {
        double a = p2.x - p1.x;
        double b = p2.y - p1.y;
        double c = p1.y * a - p1.x * b;
        double fpt = a * pt.y - b * pt.x - c;
        return fpt < 0.0;
    }

    public static Coordinate perpendicularVector(Coordinate v1, Coordinate v2, double dist, boolean toLeft) {
        Coordinate v3 = GeoUtils.vectorBetween(v1, v2);
        Coordinate v4 = new Coordinate();
        if (toLeft) {
            v4.x = -v3.y;
            v4.y = v3.x;
        } else {
            v4.x = v3.y;
            v4.y = -v3.x;
        }
        return GeoUtils.vectorAdd(v1, GeoUtils.vectorTimesScalar(GeoUtils.unitVec(v4), dist));
    }

    public static double getBearing180(Coordinate startPt, Coordinate endPt) {
        Coordinate r = new Coordinate(endPt.x - startPt.x, endPt.y - startPt.y);
        double rMag = Math.sqrt(r.x * r.x + r.y * r.y);
        if (rMag == 0.0) {
            return 0.0;
        }
        double rCos = r.x / rMag;
        double rAng = Math.acos(rCos);
        if (r.y < 0.0) {
            rAng = -rAng;
        }
        return rAng * 360.0 / (Math.PI * 2);
    }

    public static double getBearingRadians(Coordinate startPt, Coordinate endPt) {
        Coordinate r = new Coordinate(endPt.x - startPt.x, endPt.y - startPt.y);
        double rMag = Math.sqrt(r.x * r.x + r.y * r.y);
        if (rMag == 0.0) {
            return 0.0;
        }
        double rCos = r.x / rMag;
        double rAng = Math.acos(rCos);
        if (r.y < 0.0) {
            rAng = -rAng;
        }
        return rAng;
    }

    public static double getBearing360(Coordinate startPt, Coordinate endPt) {
        double bearing = GeoUtils.getBearing180(startPt, endPt);
        if (bearing < 0.0) {
            bearing = 360.0 + bearing;
        }
        return bearing;
    }

    public static double theta(Coordinate p1, Coordinate p2) {
        double ay;
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double ax = Math.abs(dx);
        double t = ax + (ay = Math.abs(dy));
        if (t != 0.0) {
            t = dy / t;
        }
        if (dx < 0.0) {
            t = 2.0 - t;
        } else if (dy < 0.0) {
            t = 4.0 + t;
        }
        return t * 90.0;
    }

    public static CoordinateList ConvexHullWrap(CoordinateList coords) {
        int i;
        CoordinateList newcoords = new CoordinateList();
        int n = coords.size();
        Coordinate[] p = new Coordinate[n + 1];
        for (i = 0; i < n; ++i) {
            p[i] = coords.getCoordinate(i);
        }
        int min = 0;
        for (i = 1; i < n; ++i) {
            if (!(p[i].y < p[min].y)) continue;
            min = i;
        }
        p[n] = coords.getCoordinate(min);
        double minAngle = 0.0;
        double distMax = 0.0;
        for (int m = 0; m < n; ++m) {
            LinearRing lr;
            Coordinate temp = p[m];
            p[m] = p[min];
            p[min] = temp;
            min = n;
            double v = minAngle;
            double vdist = distMax;
            minAngle = 360.0;
            for (i = m + 1; i <= n; ++i) {
                double t = GeoUtils.theta(p[m], p[i]);
                double dist = p[m].distance(p[i]);
                if (!(t > v) && (t != v || !(dist > vdist)) || !(t < minAngle) && (t != minAngle || !(dist > distMax))) continue;
                min = i;
                minAngle = t;
                distMax = dist;
            }
            if (min != n) continue;
            for (int j = 0; j <= m; ++j) {
                newcoords.add(p[j], true);
            }
            if (!p[0].equals2D(p[m])) {
                newcoords.add(p[0], true);
            }
            if (!GeoUtils.clockwise((Geometry)(lr = new GeometryFactory().createLinearRing(newcoords.toCoordinateArray())))) {
                CoordinateList newcoordsCW = new CoordinateList();
                for (int j = newcoords.size() - 1; j >= 0; --j) {
                    newcoordsCW.add((Object)newcoords.getCoordinate(j));
                }
                return newcoordsCW;
            }
            return newcoords;
        }
        return newcoords;
    }

    public static double getDistance(Coordinate pt, Coordinate p0, Coordinate p1) {
        return pt.distance(GeoUtils.getClosestPointOnSegment(pt, p0, p1));
    }

    public static Coordinate getClosestPointOnSegment(Coordinate pt, Coordinate p0, Coordinate p1) {
        Coordinate coordOut = new Coordinate(0.0, 0.0);
        double X0 = p0.x;
        double Y0 = p0.y;
        double X1 = p1.x;
        double Y1 = p1.y;
        double Xr = pt.x;
        double Yr = pt.y;
        double Xv = X1 - X0;
        double Yv = Y1 - Y0;
        double VdotV = Xv * Xv + Yv * Yv;
        double Xp0r = Xr - X0;
        double Yp0r = Yr - Y0;
        double DistP0toR = Math.sqrt(Xp0r * Xp0r + Yp0r * Yp0r);
        if (VdotV == 0.0) {
            coordOut.x = p0.x;
            coordOut.y = p0.y;
            return coordOut;
        }
        double t = (Xp0r * Xv + Yp0r * Yv) / VdotV;
        if (t >= 0.0 && t <= 1.0) {
            double Xp = X0 + t * Xv - Xr;
            double Yp = Y0 + t * Yv - Yr;
            coordOut.x = pt.x + Xp;
            coordOut.y = pt.y + Yp;
        } else {
            double Xp1r = Xr - X1;
            double Yp1r = Yr - Y1;
            double DistP1toR = Math.sqrt(Xp1r * Xp1r + Yp1r * Yp1r);
            if (DistP1toR < DistP0toR) {
                coordOut = new Coordinate(p1);
                coordOut.x = p1.x;
                coordOut.y = p1.y;
            } else {
                coordOut = new Coordinate(p0);
                coordOut.x = p0.x;
                coordOut.y = p0.y;
            }
        }
        return coordOut;
    }

    public static Coordinate getClosestPointOnLine(Coordinate pt, Coordinate p0, Coordinate p1) {
        MathVector vpt = new MathVector(pt);
        MathVector vp0 = new MathVector(p0);
        MathVector vp1 = new MathVector(p1);
        MathVector v = vp0.vectorBetween(vp1);
        double vdotv = v.dot(v);
        if (vdotv == 0.0) {
            return p0;
        }
        double t = vp0.vectorBetween(vpt).dot(v) / vdotv;
        MathVector vt = v.scale(t);
        vpt = vp0.add(vt);
        return vpt.getCoord();
    }

    public static Coordinate along(double d, Coordinate q, Coordinate r) {
        Coordinate n = (Coordinate)r.clone();
        double ux = r.x - q.x;
        double uy = r.y - q.y;
        double m = Math.sqrt(ux * ux + uy * uy);
        if (m != 0.0) {
            ux = d * ux / m;
            uy = d * uy / m;
            n.x = q.x + ux;
            n.y = q.y + uy;
        }
        return n;
    }

    public static double interiorAngle(Coordinate p1, Coordinate p2, Coordinate p3) {
        Coordinate q;
        Coordinate p = GeoUtils.vectorBetween(p1, p2);
        double arg = GeoUtils.dot(p, q = GeoUtils.vectorBetween(p3, p2)) / (GeoUtils.mag(p) * GeoUtils.mag(q));
        if (arg < -1.0) {
            arg = -1.0;
        } else if (arg > 1.0) {
            arg = 1.0;
        }
        return Math.toDegrees(Math.acos(arg));
    }

    public static Coordinate[] getDistanceBearingArray(LineString ring) {
        Coordinate p1;
        Coordinate[] coords = new Coordinate[ring.getNumPoints()];
        coords[0] = p1 = new Coordinate(ring.getCoordinateN(0));
        for (int i = 1; i < coords.length; ++i) {
            coords[i] = new Coordinate(ring.getCoordinateN(i));
            Coordinate p2 = coords[i];
            double angle = GeoUtils.getBearing360(p1, p2);
            double distance = p1.distance(p2);
            p1.x = p2.x;
            p1.y = p2.y;
            coords[i].x = distance;
            coords[i].y = angle;
        }
        return coords;
    }

    public static Coordinate[] getDistanceAngleArray(LineString ring) {
        int n = ring.getNumPoints();
        Coordinate[] coords = new Coordinate[n];
        for (int i = 0; i < coords.length; ++i) {
            Coordinate pb = ring.getCoordinateN(i == 0 ? n - 2 : i - 1);
            Coordinate p = ring.getCoordinateN(i);
            Coordinate pn = ring.getCoordinateN(i == n - 1 ? 1 : i + 1);
            double angle = GeoUtils.interiorAngle(pb, p, pn);
            double distance = p.distance(pn);
            coords[i] = new Coordinate(distance, angle, Double.NaN);
        }
        return coords;
    }

    public static LinearRing removeRedundantPoints(LineString ring) {
        double epsilon = 1.0E-6;
        Coordinate[] coords = new Coordinate[ring.getNumPoints()];
        int n = coords.length;
        boolean[] remove = new boolean[n];
        for (int i = 0; i < n; ++i) {
            coords[i] = new Coordinate(ring.getCoordinateN(i));
            remove[i] = false;
        }
        Coordinate p2 = null;
        Coordinate p3 = null;
        for (int i = 0; i < coords.length; ++i) {
            Coordinate p1 = coords[i];
            if (i > 1) {
                boolean colinear;
                double dist = GeoUtils.getDistance(p2, p1, p3);
                boolean bl = colinear = dist <= 1.0E-6;
                if (colinear) {
                    remove[i - 1] = colinear;
                    --n;
                }
            }
            p3 = p2;
            p2 = p1;
        }
        Coordinate[] newCoords = new Coordinate[n];
        int j = 0;
        for (int i = 0; i < coords.length; ++i) {
            if (remove[i]) continue;
            newCoords[j++] = new Coordinate(coords[i]);
        }
        LinearRing linearRing = new LinearRing(newCoords, ring.getPrecisionModel(), ring.getSRID());
        return linearRing;
    }

    public static Geometry reducePoints(Geometry geo, double tolerance) {
        int maxIndex;
        CoordinateList coords = new CoordinateList();
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        geo.apply((CoordinateFilter)filter);
        coords.add(filter.getCoordinates(), false);
        if (geo instanceof Polygon || geo instanceof LinearRing) {
            coords.add((Object)coords.getCoordinate(0));
        }
        int temp = maxIndex = coords.size() - 1;
        do {
            temp = maxIndex;
            int i = 0;
            do {
                Coordinate anchor = coords.getCoordinate(i);
                boolean pointDeleted = false;
                int k = maxIndex;
                do {
                    Coordinate floater = coords.getCoordinate(k);
                    double dmax = -1.0;
                    int j = k;
                    while (j > i + 1) {
                        Coordinate cp;
                        Coordinate pt;
                        double d;
                        if (!((d = (pt = coords.getCoordinate(--j)).distance(cp = GeoUtils.getClosestPointOnLine(pt, anchor, floater))) > dmax)) continue;
                        dmax = d;
                        k = j;
                    }
                    if (!(dmax < tolerance) || !(dmax > -1.0) || maxIndex <= 1) continue;
                    pointDeleted = true;
                    coords.remove(k);
                    k = --maxIndex;
                } while (!pointDeleted && k > i + 1);
            } while (++i <= maxIndex - 2);
        } while (temp != maxIndex);
        if (geo instanceof LineString) {
            return new GeometryFactory().createLineString(coords.toCoordinateArray());
        }
        if (geo instanceof LinearRing) {
            return new GeometryFactory().createLinearRing(coords.toCoordinateArray());
        }
        if (geo instanceof Polygon) {
            return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(coords.toCoordinateArray()), null);
        }
        return geo;
    }

    public static boolean clockwise(Geometry geo) {
        if (geo instanceof Polygon || geo instanceof LinearRing) {
            Coordinate[] geoCoords = geo.getCoordinates();
            int maxIndex = geoCoords.length - 1;
            double t1 = geoCoords[maxIndex].x * geoCoords[0].y;
            double t2 = -geoCoords[0].x * geoCoords[maxIndex].y;
            for (int i = 0; i < maxIndex; ++i) {
                t1 += geoCoords[i].x * geoCoords[i + 1].y;
                t2 -= geoCoords[i + 1].x * geoCoords[i].y;
            }
            double geoArea = 0.5 * (t1 + t2);
            return geoArea < 0.0;
        }
        return true;
    }

    public static Coordinate intersect(Coordinate P1, Coordinate P2, Coordinate P3, Coordinate P4) {
        Coordinate V = new Coordinate(P2.x - P1.x, P2.y - P1.y);
        Coordinate W = new Coordinate(P4.x - P3.x, P4.y - P3.y);
        double n = W.y * (P3.x - P1.x) - W.x * (P3.y - P1.y);
        double d = W.y * V.x - W.x * V.y;
        if (d != 0.0) {
            double t1 = n / d;
            Coordinate E = new Coordinate(P1.x + V.x * t1, P1.y + V.y * t1);
            return E;
        }
        return null;
    }

    public static Coordinate getIntersection(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        Coordinate e = new Coordinate(0.0, 0.0, 0.0);
        Coordinate v = new Coordinate(0.0, 0.0);
        Coordinate w = new Coordinate(0.0, 0.0);
        double t1 = 0.0;
        double n = 0.0;
        double d = 0.0;
        v.x = p2.x - p1.x;
        v.y = p2.y - p1.y;
        w.x = p4.x - p3.x;
        w.y = p4.y - p3.y;
        n = w.y * (p3.x - p1.x) - w.x * (p3.y - p1.y);
        d = w.y * v.x - w.x * v.y;
        if (d != 0.0) {
            t1 = n / d;
            e.x = p1.x + v.x * t1;
            e.y = p1.y + v.y * t1;
        } else {
            e.z = 999.0;
        }
        return e;
    }

    public static Coordinate intersectSegments(Coordinate P1, Coordinate P2, Coordinate P3, Coordinate P4) {
        Coordinate V = new Coordinate(P2.x - P1.x, P2.y - P1.y);
        Coordinate W = new Coordinate(P4.x - P3.x, P4.y - P3.y);
        double n1 = W.y * (P3.x - P1.x) - W.x * (P3.y - P1.y);
        double n2 = V.y * (P3.x - P1.x) - V.x * (P3.y - P1.y);
        double d = W.y * V.x - W.x * V.y;
        if (d != 0.0) {
            boolean onP3P4;
            double t1 = n1 / d;
            double t2 = n2 / d;
            Coordinate E = new Coordinate(P1.x + V.x * t1, P1.y + V.y * t1);
            double epsilon = 0.001;
            double lowbound = 0.0 - epsilon;
            double hibound = 1.0 + epsilon;
            boolean onP1P2 = t1 >= lowbound && t1 <= hibound;
            boolean bl = onP3P4 = t2 >= lowbound && t2 <= hibound;
            if (onP1P2 && onP3P4) {
                return E;
            }
            return null;
        }
        return null;
    }

    public static Coordinate getCenter(Coordinate p1, Coordinate p2, Coordinate p3) {
        double x = p1.x + (p2.x - p1.x) / 2.0;
        double y = p1.y + (p2.y - p1.y) / 2.0;
        Coordinate p12 = new Coordinate(x, y);
        p1 = GeoUtils.pointToRight(p3, p1, p2) ? GeoUtils.rotPt(p1, p12, -90.0) : GeoUtils.rotPt(p1, p12, 90.0);
        x = p2.x + (p3.x - p2.x) / 2.0;
        y = p2.y + (p3.y - p2.y) / 2.0;
        Coordinate p23 = new Coordinate(x, y);
        Coordinate center = GeoUtils.intersect(p1, p12, p3 = GeoUtils.pointToRight(p1, p3, p2) ? GeoUtils.rotPt(p3, p23, -90.0) : GeoUtils.rotPt(p3, p23, 90.0), p23);
        if (center == null) {
            return p2;
        }
        return center;
    }

    public static BitSet setBit(BitSet bitSet, Geometry geometry) {
        BitSet newBitSet = (BitSet)bitSet.clone();
        if (geometry.isEmpty()) {
            newBitSet.set(0);
        } else if (geometry instanceof Point) {
            newBitSet.set(1);
        } else if (geometry instanceof MultiPoint) {
            newBitSet.set(1);
        } else if (geometry instanceof LineString) {
            newBitSet.set(2);
        } else if (geometry instanceof LinearRing) {
            newBitSet.set(2);
        } else if (geometry instanceof MultiLineString) {
            newBitSet.set(2);
        } else if (geometry instanceof Polygon) {
            newBitSet.set(3);
        } else if (geometry instanceof MultiPolygon) {
            newBitSet.set(3);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                newBitSet = GeoUtils.setBit(newBitSet, geometryCollection.getGeometryN(i));
            }
        }
        return newBitSet;
    }

    public static LineString MakeRoundCorner(Coordinate A, Coordinate B, Coordinate C, Coordinate D, double r, boolean arcOnly) {
        MathVector Gv = new MathVector();
        Coordinate E = GeoUtils.intersect(A, B, C, D);
        if (E != null) {
            Coordinate temp;
            MathVector Ev = new MathVector(E);
            if (E.distance(B) > E.distance(A)) {
                temp = A;
                A = B;
                B = temp;
            }
            if (E.distance(D) > E.distance(C)) {
                temp = C;
                C = D;
                D = temp;
            }
            MathVector Av = new MathVector(A);
            MathVector Cv = new MathVector(C);
            double alpha = Ev.vectorBetween(Av).angleRad(Ev.vectorBetween(Cv)) / 2.0;
            double h1 = Math.abs(r / Math.sin(alpha));
            if (h1 * h1 - r * r >= 0.0) {
                double d1 = Math.sqrt(h1 * h1 - r * r);
                double theta = 1.5707963267948966 - alpha;
                theta *= 2.0;
                Gv = Ev.add(Ev.vectorBetween(Av).unit().scale(d1));
                MathVector Hv = Ev.add(Ev.vectorBetween(Cv).unit().scale(d1));
                MathVector Fv = Ev.add(Ev.vectorBetween(Gv).rotateRad(alpha).unit().scale(h1));
                if (Math.abs(Fv.distance(Hv) - Fv.distance(Gv)) > 1.0) {
                    Fv = Ev.add(Ev.vectorBetween(Gv).rotateRad(-alpha).unit().scale(h1));
                    theta = -theta;
                }
                CoordinateList coordinates = new CoordinateList();
                if (!arcOnly) {
                    coordinates.add((Object)C);
                }
                Arc arc = new Arc(Fv.getCoord(), Hv.getCoord(), Math.toDegrees(theta));
                LineString lineString = arc.getLineString();
                coordinates.add(lineString.getCoordinates(), false);
                if (!arcOnly) {
                    coordinates.add((Object)A);
                }
                return new GeometryFactory().createLineString(coordinates.toCoordinateArray());
            }
        }
        return null;
    }

    public static boolean geometriesEqual(Geometry geo1, Geometry geo2) {
        int numGeos2;
        if (!(geo1 instanceof GeometryCollection) && !(geo2 instanceof GeometryCollection)) {
            return geo1.equals(geo2);
        }
        if (!(geo1 instanceof GeometryCollection) && geo2 instanceof GeometryCollection) {
            return false;
        }
        if (geo1 instanceof GeometryCollection && !(geo2 instanceof GeometryCollection)) {
            return false;
        }
        int numGeos1 = ((GeometryCollection)geo1).getNumGeometries();
        if (numGeos1 != (numGeos2 = ((GeometryCollection)geo2).getNumGeometries())) {
            return false;
        }
        for (int index = 0; index < numGeos1; ++index) {
            Geometry internalGeo2;
            Geometry internalGeo1 = ((GeometryCollection)geo1).getGeometryN(index);
            if (GeoUtils.geometriesEqual(internalGeo1, internalGeo2 = ((GeometryCollection)geo2).getGeometryN(index))) continue;
            return false;
        }
        return true;
    }

    public static double getDistanceFromPointToGeometry(Coordinate coord, Geometry geo) {
        double closestDist = 9.99999999E8;
        for (int i = 0; i < geo.getNumGeometries(); ++i) {
            double newDist;
            Geometry internalGeo = geo.getGeometryN(i);
            if (internalGeo instanceof Point) {
                newDist = coord.distance(internalGeo.getCoordinate());
                if (!(newDist < closestDist)) continue;
                closestDist = newDist;
                continue;
            }
            if (internalGeo instanceof LineString) {
                Coordinate[] coords = internalGeo.getCoordinates();
                for (int j = 0; j < coords.length - 1; ++j) {
                    newDist = GeoUtils.getDistance(coord, coords[j], coords[j + 1]);
                    if (!(newDist < closestDist)) continue;
                    closestDist = newDist;
                }
                continue;
            }
            if (internalGeo instanceof Polygon) {
                Geometry newGeo = internalGeo.getBoundary();
                newDist = GeoUtils.getDistanceFromPointToGeometry(coord, newGeo);
                if (!(newDist < closestDist)) continue;
                closestDist = newDist;
                continue;
            }
            if (internalGeo instanceof MultiPoint) {
                Coordinate[] coords = internalGeo.getCoordinates();
                for (int k = 0; k < coords.length; ++k) {
                    newDist = coord.distance(coords[k]);
                    if (!(newDist < closestDist)) continue;
                    closestDist = newDist;
                }
                continue;
            }
            for (int m = 0; m < internalGeo.getNumGeometries(); ++m) {
                newDist = GeoUtils.getDistanceFromPointToGeometry(coord, internalGeo.getGeometryN(m));
                if (!(newDist < closestDist)) continue;
                closestDist = newDist;
            }
        }
        return closestDist;
    }

    public static boolean geometryIsSegmentOf(Geometry geo1, Geometry geo2) {
        if (geo1.getNumPoints() > geo2.getNumPoints()) {
            return false;
        }
        int numGeos1 = geo1.getNumGeometries();
        int numGeos2 = geo2.getNumGeometries();
        if (numGeos1 == 1 && numGeos2 == 1) {
            int i2;
            Coordinate[] coords1 = geo1.getCoordinates();
            Coordinate[] coords2 = geo2.getCoordinates();
            int i1 = 0;
            for (i2 = 0; i2 < coords2.length && !coords1[0].equals2D(coords2[i2]); ++i2) {
            }
            if (i2 == coords2.length) {
                return false;
            }
            while (i1 < coords1.length && i2 < coords2.length) {
                if (!coords1[i1].equals2D(coords2[i2])) {
                    return false;
                }
                ++i1;
                ++i2;
            }
            return i1 == coords1.length;
        }
        boolean foundMatch = false;
        for (int i = 0; i < numGeos1; ++i) {
            foundMatch = false;
            for (int j = 0; j < numGeos2; ++j) {
                if (!GeoUtils.geometryIsSegmentOf(geo1.getGeometryN(i), geo2.getGeometryN(j))) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return foundMatch;
    }

    public static Geometry createPlume(Coordinate[] coords, double radius1, double radius2) {
        int n = coords.length;
        double radiusInc = (radius2 - radius1) / (double)(n - 1);
        double r1 = radius1;
        Object plume = null;
        for (int i = 0; i < n - 1; ++i) {
            Coordinate p0 = coords[i];
            Coordinate p1 = coords[i + 1];
            double r2 = r1 + radiusInc;
            Polygon buf = GeoUtils.taperedBufferSegment(p0, p1, r1, r2);
            plume = plume == null ? buf : plume.union((Geometry)buf);
            r1 = r2;
        }
        return plume;
    }

    public static Polygon taperedBufferSegment(Coordinate p0, Coordinate p1, double d1, double d2) {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        Coordinate p0Right = GeoUtils.perpendicularVector(p0, p1, d1, false);
        Coordinate p0Left = GeoUtils.perpendicularVector(p0, p1, d1, true);
        coordList.addAll((Collection<Coordinate>)new Arc(p0, p0Right, 180.0).getCoordinates());
        coordList.add(p0Left);
        Coordinate p1Left = GeoUtils.perpendicularVector(p1, p0, d2, false);
        coordList.addAll((Collection<Coordinate>)new Arc(p1, p1Left, 180.0).getCoordinates());
        Coordinate p1Right = GeoUtils.perpendicularVector(p1, p0, d2, true);
        coordList.add(p1Right);
        coordList.add(p0Right);
        Coordinate[] coords = coordList.toArray(new Coordinate[0]);
        LinearRing linearRing = new GeometryFactory().createLinearRing(coords);
        return new GeometryFactory().createPolygon(linearRing, null);
    }
}

