/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.openjump.core.attributeoperations.AttributeOp;
import org.openjump.core.attributeoperations.SpatialRelationOp;

public class JoinAttributes {
    public static FeatureDataset joinAttributes(Collection sourceFeatures, Collection targetFeatures, String attributeName, int attributeOp, int spatialRelation, double bufferRadius, TaskMonitor monitor) {
        FeatureDataset fd = null;
        AttributeType newAttributeType = AttributeType.DOUBLE;
        String newAttributeName = attributeName + "_" + AttributeOp.getName(attributeOp);
        if (attributeOp == 8) {
            newAttributeName = AttributeOp.getName(attributeOp);
        }
        Quadtree fqTree = new Quadtree();
        FeatureSchema sourceFS = null;
        int count = 0;
        for (Feature pt : sourceFeatures) {
            fqTree.insert(pt.getGeometry().getEnvelopeInternal(), (Object)pt);
            if (count == 0) {
                sourceFS = pt.getSchema();
            }
            ++count;
        }
        AttributeType at = null;
        try {
            at = sourceFS.getAttributeType(attributeName);
        }
        catch (Exception e) {
            at = AttributeType.GEOMETRY;
            attributeName = sourceFS.getAttributeName(0);
            System.out.println("JoinAttributes.joinAttributes: replace unknown attribute name by geometry");
        }
        ArrayList<Feature> outPolys = new ArrayList<Feature>();
        int size = targetFeatures.size();
        FeatureSchema targetFSnew = null;
        count = 0;
        Iterator iterp = targetFeatures.iterator();
        while (iterp.hasNext()) {
            FeatureSchema targetFs;
            ++count;
            if (monitor != null) {
                monitor.report("item: " + count + " of " + size);
            }
            Feature p = (Feature)iterp.next();
            if (count == 1 && !(targetFSnew = JoinAttributes.copyFeatureSchema(targetFs = p.getSchema())).hasAttribute(newAttributeName)) {
                targetFSnew.addAttribute(newAttributeName, newAttributeType);
            }
            double value = JoinAttributes.evaluateSinglePolygon(p.getGeometry(), fqTree, attributeName, attributeOp, spatialRelation, bufferRadius);
            Feature fcopy = JoinAttributes.copyFeature(p, targetFSnew);
            fcopy.setAttribute(newAttributeName, (Object)new Double(value));
            outPolys.add(fcopy);
        }
        fd = new FeatureDataset(targetFSnew);
        fd.addAll(outPolys);
        return fd;
    }

    private static double evaluateSinglePolygon(Geometry poly, Quadtree fqTree, String attributeName, int attributeOp, int spatialRelation, double bufferRadius) {
        List items = SpatialRelationOp.evaluateSpatial(spatialRelation, fqTree, poly, bufferRadius);
        double val = AttributeOp.evaluateAttributes(attributeOp, items, attributeName);
        return val;
    }

    public static FeatureSchema copyFeatureSchema(FeatureSchema oldSchema) {
        FeatureSchema fs = new FeatureSchema();
        for (int i = 0; i < oldSchema.getAttributeCount(); ++i) {
            AttributeType at = oldSchema.getAttributeType(i);
            String aname = oldSchema.getAttributeName(i);
            fs.addAttribute(aname, at);
            fs.setCoordinateSystem(oldSchema.getCoordinateSystem());
        }
        return fs;
    }

    public static Feature copyFeature(Feature feature, FeatureSchema newSchema) {
        FeatureSchema oldSchema = feature.getSchema();
        BasicFeature newF = new BasicFeature(newSchema);
        int n = 0;
        n = oldSchema.getAttributeCount() > newSchema.getAttributeCount() ? newSchema.getAttributeCount() : oldSchema.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String aname = oldSchema.getAttributeName(i);
            Object value = feature.getAttribute(aname);
            newF.setAttribute(aname, value);
        }
        return newF;
    }
}

