/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools.objecttyperoles;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.CollectionsTools;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRole;
import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRoleTypes;
import org.openjump.util.metaData.MetaDataMap;
import org.openjump.util.metaData.ObjectContainingMetaInformation;

public class PirolFeatureCollection
implements FeatureCollection,
ObjectContainingMetaInformation {
    private static final long serialVersionUID = 1997134887214940597L;
    protected FeatureCollection featureDataSet = null;
    protected MetaDataMap metaInformation = null;
    protected FeatureCollectionRole[] roles = null;

    public PirolFeatureCollection(FeatureCollection featureDataSet, FeatureCollectionRole initRole) {
        this.featureDataSet = featureDataSet;
        this.roles = new FeatureCollectionRole[FeatureCollectionRole.numOfExistentRoles];
        this.roles[0] = initRole;
    }

    public PirolFeatureCollection() {
    }

    public Collection getXmlRoles() {
        ArrayList rolesForXml = new ArrayList();
        CollectionsTools.addArrayToList(rolesForXml, this.roles);
        return rolesForXml;
    }

    public void addXmlRole(FeatureCollectionRole role) {
        this.addRole(role);
    }

    public FeatureCollection getFeatureDataSet() {
        return this.featureDataSet;
    }

    public void setFeatureDataSet(FeatureCollection featureDataSet) {
        this.featureDataSet = featureDataSet;
    }

    public void addRole(FeatureCollectionRole role) {
        for (int i = 0; i < this.roles.length; ++i) {
            if (this.roles[i] == null) {
                this.roles[i] = role;
                return;
            }
            if (!this.roles[i].equalsRole(role)) continue;
            return;
        }
    }

    public void removeRole(FeatureCollectionRole role) {
        int removedRoleIndex = -1;
        for (int i = 0; i < this.roles.length; ++i) {
            if (this.roles[i] == null) {
                return;
            }
            if (this.roles[i].equalsRole(role)) {
                this.roles[i] = null;
                removedRoleIndex = i;
                return;
            }
            if (removedRoleIndex <= -1 || i <= removedRoleIndex) continue;
            this.roles[i - 1] = this.roles[i];
            this.roles[i] = null;
        }
    }

    public FeatureCollectionRole[] getRoles() {
        return this.roles;
    }

    public FeatureCollectionRole getRole(FeatureCollectionRole role) {
        for (int i = 0; i < this.roles.length && this.roles[i] != null; ++i) {
            if (!this.roles[i].equalsRole(role)) continue;
            return this.roles[i];
        }
        return null;
    }

    public FeatureCollectionRole getRole(FeatureCollectionRoleTypes role) {
        for (int i = 0; i < this.roles.length && this.roles[i] != null; ++i) {
            if (!this.roles[i].equalsRole(role)) continue;
            return this.roles[i];
        }
        return null;
    }

    public FeatureCollectionRole getRole(int roleId) {
        for (int i = 0; i < this.roles.length && this.roles[i] != null; ++i) {
            if (!this.roles[i].equalsRole(roleId)) continue;
            return this.roles[i];
        }
        return null;
    }

    @Override
    public MetaDataMap getMetaInformation() {
        return this.metaInformation;
    }

    @Override
    public void setMetaInformation(MetaDataMap metaInformation) {
        this.metaInformation = metaInformation;
    }

    public void invalidateEnvelope(boolean simpleInvalidation) {
        if (FeatureDataset.class.isInstance(this.featureDataSet)) {
            ((FeatureDataset)this.featureDataSet).invalidateEnvelope();
        }
        if (simpleInvalidation) {
            return;
        }
        this.featureDataSet.getEnvelope().setToNull();
        Feature[] features = FeatureCollectionTools.FeatureCollection2FeatureArray(this.featureDataSet);
        for (int i = 0; i < features.length; ++i) {
            features[i].getGeometry().geometryChanged();
        }
    }

    @Override
    public void add(Feature feature) {
        this.invalidateEnvelope(true);
        this.featureDataSet.add(feature);
    }

    public void addAll(Collection features) {
        this.invalidateEnvelope(true);
        this.featureDataSet.addAll(features);
    }

    @Override
    public void clear() {
        this.invalidateEnvelope(true);
        this.featureDataSet.clear();
    }

    public boolean equals(Object arg0) {
        return this.featureDataSet.equals(arg0);
    }

    @Override
    public Envelope getEnvelope() {
        this.invalidateEnvelope(true);
        return this.featureDataSet.getEnvelope();
    }

    public List getFeatures() {
        this.invalidateEnvelope(true);
        return this.featureDataSet.getFeatures();
    }

    @Override
    public FeatureSchema getFeatureSchema() {
        return this.featureDataSet.getFeatureSchema();
    }

    public int hashCode() {
        return this.featureDataSet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.featureDataSet.isEmpty();
    }

    @Override
    public Iterator iterator() {
        this.invalidateEnvelope(true);
        return this.featureDataSet.iterator();
    }

    public List query(Envelope envelope) {
        return this.featureDataSet.query(envelope);
    }

    public Collection remove(Envelope env) {
        this.invalidateEnvelope(true);
        return this.featureDataSet.remove(env);
    }

    @Override
    public void remove(Feature feature) {
        this.invalidateEnvelope(true);
        this.featureDataSet.remove(feature);
    }

    public void removeAll(Collection features) {
        this.invalidateEnvelope(true);
        this.featureDataSet.removeAll(features);
    }

    @Override
    public int size() {
        return this.featureDataSet.size();
    }

    public String toString() {
        return this.featureDataSet.toString();
    }

    public Feature[] toArray() {
        return FeatureCollectionTools.FeatureCollection2FeatureArray(this.featureDataSet);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.roles.length && this.roles[i] != null; ++i) {
            this.roles[i].clearRam();
        }
    }

    public FeatureCollection getWrappee() {
        return this.featureDataSet;
    }
}

