/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class MultiLineHandler
implements ShapeHandler {
    int myShapeType = -1;

    public MultiLineHandler() {
        this.myShapeType = 3;
    }

    public MultiLineHandler(int type) throws InvalidShapefileException {
        if (type != 3 && type != 13 && type != 23) {
            throw new InvalidShapefileException("MultiLineHandler constructor - expected type to be 3, 13 or 23");
        }
        this.myShapeType = type;
    }

    @Override
    public Geometry read(EndianDataInputStream file, GeometryFactory geometryFactory, int contentLength) throws IOException, InvalidShapefileException {
        int actualReadWords = 0;
        Object geom = null;
        int shapeType = file.readIntLE();
        actualReadWords += 2;
        if (shapeType == 0) {
            geom = geometryFactory.createMultiLineString(new LineString[0]);
        } else {
            int fullLength;
            int t;
            if (shapeType != this.myShapeType) {
                throw new InvalidShapefileException("MultilineHandler.read()  - file says its type " + shapeType + " but i'm expecting type " + this.myShapeType);
            }
            double junk = file.readDoubleLE();
            junk = file.readDoubleLE();
            junk = file.readDoubleLE();
            junk = file.readDoubleLE();
            actualReadWords += 16;
            int numParts = file.readIntLE();
            int numPoints = file.readIntLE();
            actualReadWords += 4;
            int[] partOffsets = new int[numParts];
            for (int i = 0; i < numParts; ++i) {
                partOffsets[i] = file.readIntLE();
                actualReadWords += 2;
            }
            LineString[] lines = new LineString[numParts];
            Coordinate[] coords = new Coordinate[numPoints];
            for (t = 0; t < numPoints; ++t) {
                coords[t] = new Coordinate(file.readDoubleLE(), file.readDoubleLE());
                actualReadWords += 8;
            }
            if (this.myShapeType == 13) {
                junk = file.readDoubleLE();
                junk = file.readDoubleLE();
                actualReadWords += 8;
                for (t = 0; t < numPoints; ++t) {
                    coords[t].z = file.readDoubleLE();
                    actualReadWords += 4;
                }
            }
            if (this.myShapeType >= 13 && contentLength >= (fullLength = this.myShapeType == 13 ? 22 + 2 * numParts + numPoints * 8 + 4 + 4 + 4 * numPoints + 4 + 4 + 4 * numPoints : 22 + 2 * numParts + numPoints * 8 + 4 + 4 + 4 * numPoints)) {
                junk = file.readDoubleLE();
                junk = file.readDoubleLE();
                actualReadWords += 8;
                for (int t2 = 0; t2 < numPoints; ++t2) {
                    junk = file.readDoubleLE();
                    actualReadWords += 4;
                }
            }
            int offset = 0;
            for (int part = 0; part < numParts; ++part) {
                int start = partOffsets[part];
                int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                int length = finish - start;
                Coordinate[] points = new Coordinate[length];
                for (int i = 0; i < length; ++i) {
                    points[i] = coords[offset];
                    ++offset;
                }
                lines[part] = geometryFactory.createLineString(points);
            }
            geom = numParts == 1 ? lines[0] : geometryFactory.createMultiLineString(lines);
        }
        while (actualReadWords < contentLength) {
            short junk2 = file.readShortBE();
            ++actualReadWords;
        }
        return geom;
    }

    @Override
    public void write(Geometry geometry, EndianDataOutputStream file) throws IOException {
        if (geometry.isEmpty()) {
            file.writeIntLE(0);
            return;
        }
        MultiLineString multi = (MultiLineString)geometry;
        file.writeIntLE(this.getShapeType());
        Envelope box = multi.getEnvelopeInternal();
        file.writeDoubleLE(box.getMinX());
        file.writeDoubleLE(box.getMinY());
        file.writeDoubleLE(box.getMaxX());
        file.writeDoubleLE(box.getMaxY());
        int numParts = multi.getNumGeometries();
        file.writeIntLE(numParts);
        int npoints = multi.getNumPoints();
        file.writeIntLE(npoints);
        LineString[] lines = new LineString[numParts];
        int idx = 0;
        for (int i = 0; i < numParts; ++i) {
            lines[i] = (LineString)multi.getGeometryN(i);
            file.writeIntLE(idx);
            idx += lines[i].getNumPoints();
        }
        Coordinate[] coords = multi.getCoordinates();
        for (int t = 0; t < npoints; ++t) {
            file.writeDoubleLE(coords[t].x);
            file.writeDoubleLE(coords[t].y);
        }
        if (this.myShapeType == 13) {
            double[] zExtreame = this.zMinMax((Geometry)multi);
            if (Double.isNaN(zExtreame[0])) {
                file.writeDoubleLE(0.0);
                file.writeDoubleLE(0.0);
            } else {
                file.writeDoubleLE(zExtreame[0]);
                file.writeDoubleLE(zExtreame[1]);
            }
            for (int t = 0; t < npoints; ++t) {
                double z = coords[t].z;
                if (Double.isNaN(z)) {
                    file.writeDoubleLE(0.0);
                    continue;
                }
                file.writeDoubleLE(z);
            }
        }
        if (this.myShapeType >= 13) {
            file.writeDoubleLE(-1.0E41);
            file.writeDoubleLE(-1.0E41);
            for (int t = 0; t < npoints; ++t) {
                file.writeDoubleLE(-1.0E41);
            }
        }
    }

    @Override
    public int getShapeType() {
        return this.myShapeType;
    }

    @Override
    public int getLength(Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        MultiLineString multi = (MultiLineString)geometry;
        int numlines = multi.getNumGeometries();
        int numpoints = multi.getNumPoints();
        if (this.myShapeType == 3) {
            return 22 + 2 * numlines + numpoints * 8;
        }
        if (this.myShapeType == 23) {
            return 22 + 2 * numlines + numpoints * 8 + 4 + 4 + 4 * numpoints;
        }
        return 22 + 2 * numlines + numpoints * 8 + 4 + 4 + 4 * numpoints + 4 + 4 + 4 * numpoints;
    }

    double[] zMinMax(Geometry g) {
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        boolean validZFound = false;
        Coordinate[] cs = g.getCoordinates();
        for (int t = 0; t < cs.length; ++t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        return new double[]{zmin, zmax};
    }

    @Override
    public Geometry getEmptyGeometry(GeometryFactory factory) {
        return factory.createMultiLineString(new LineString[0]);
    }
}

