/*
 * Decompiled with CFR 0.152.
 */
package org.geotiff.image.jai;

import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jump.workbench.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeMap;
import org.libtiff.jai.codec.XTIFFDirectory;
import org.libtiff.jai.codec.XTIFFField;

public class GeoTIFFDirectory
extends XTIFFDirectory
implements Serializable {
    private TreeMap geoKeyIndex = new TreeMap();
    private int keyDirectoryVersion;
    private int majorRevision;
    private int minorRevision;
    private int numberOfKeys;
    private double[] tiepoints = null;
    private double[] scales = null;
    private double[] matrix = null;
    private boolean hasGeoKeys = false;

    public GeoTIFFDirectory() {
    }

    public GeoTIFFDirectory(SeekableStream stream, long ifd_offset) throws IOException {
        super(stream, ifd_offset);
        this.readGeoKeys();
        this.log("GeoTIFFDirectory constructor success.");
    }

    public GeoTIFFDirectory(SeekableStream stream, int directory) throws IOException {
        super(stream, directory);
        this.readGeoKeys();
        this.log("GeoTIFFDirectory constructor success.");
    }

    private void log(String msg) {
    }

    private void createGeoTags() {
        if (!this.hasGeoKeys) {
            return;
        }
        char numberOfKeys = (char)this.geoKeyIndex.size();
        char[] keys = new char[(numberOfKeys + '\u0001') * 4];
        keys[0] = '\u0001';
        keys[1] = '\u0001';
        keys[2] = '\u0000';
        keys[3] = numberOfKeys;
        Iterator iter = this.geoKeyIndex.values().iterator();
        double[] doubles = new double[numberOfKeys];
        String strings = "";
        int indx = 4;
        int numDoubles = 0;
        int tag = 0;
        char valueOrOffset = '\u0000';
        while (iter.hasNext()) {
            XTIFFField geoKey = (XTIFFField)iter.next();
            switch (geoKey.getType()) {
                case 3: {
                    tag = 0;
                    valueOrOffset = (char)geoKey.getAsInt(0);
                    break;
                }
                case 12: {
                    tag = 34736;
                    doubles[numDoubles] = geoKey.getAsDouble(0);
                    int n = numDoubles;
                    numDoubles = (char)(numDoubles + 1);
                    valueOrOffset = (char)n;
                    break;
                }
                case 2: {
                    tag = 34737;
                    valueOrOffset = (char)strings.length();
                    strings = strings + geoKey.getAsString(0) + "|";
                }
            }
            keys[indx++] = (char)geoKey.getTag();
            keys[indx++] = tag;
            keys[indx++] = (char)geoKey.getCount();
            keys[indx++] = valueOrOffset;
        }
        this.addField(34735, 3, keys.length, keys);
        if (strings.length() > 0) {
            char zero = '\u0000';
            strings = strings + zero;
            this.addField(34737, 2, strings.length(), new String[]{strings});
        }
        if (numDoubles > 0) {
            double[] doubleVals = new double[numDoubles];
            for (int i = 0; i < numDoubles; ++i) {
                doubleVals = doubles;
            }
            this.addField(34736, 12, numDoubles, doubleVals);
        }
        if (this.matrix != null) {
            this.addField(34264, 12, this.matrix.length, this.matrix);
        }
        if (this.tiepoints != null) {
            this.addField(33922, 12, this.tiepoints.length, this.tiepoints);
        }
        if (this.scales != null) {
            this.addField(33550, 12, this.scales.length, this.scales);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeGeoKey(int keyID, int tiffTag, int valueCount, int valueOrOffset) throws IOException {
        void var6_11;
        int type = 3;
        Object var6_6 = null;
        if (tiffTag > 0) {
            XTIFFField values = this.getField(tiffTag);
            if (values == null) throw new IOException("GeoTIFF tag not found");
            type = values.getType();
            if (type == 2) {
                String svalue = values.getAsString(0).substring(valueOrOffset, valueOrOffset + valueCount - 1);
                String[] stringArray = new String[]{svalue};
            } else if (type == 12) {
                double dvalue = values.getAsDouble(valueOrOffset);
                double[] dArray = new double[]{dvalue};
            }
        } else {
            type = 3;
            char[] cArray = new char[]{(char)valueOrOffset};
        }
        this.addGeoKey(keyID, type, valueCount, var6_11);
    }

    @Override
    public XTIFFField[] getFields() {
        if (this.hasGeoKeys) {
            this.createGeoTags();
        }
        return super.getFields();
    }

    private void readGeoKeys() throws IOException {
        XTIFFField geoKeyTag = this.getField(34735);
        if (geoKeyTag != null) {
            if (geoKeyTag.getType() != 3) {
                Logger.warn("GeoKeyDirectoryTag (34735) cannot be read : it is not of type SHORT");
                return;
            }
            char[] keys = geoKeyTag.getAsChars();
            this.keyDirectoryVersion = keys[0];
            this.majorRevision = keys[1];
            this.minorRevision = keys[2];
            this.numberOfKeys = keys[3];
            for (int i = 4; i < keys.length; i += 4) {
                char keyID = keys[i];
                char tiffTag = keys[i + 1];
                char valueCount = keys[i + 2];
                char valueOrOffset = keys[i + 3];
                this.storeGeoKey(keyID, tiffTag, valueCount, valueOrOffset);
            }
        }
        XTIFFField matrixTag = this.getField(34264);
        XTIFFField tiepointTag = this.getField(33922);
        XTIFFField scaleTag = this.getField(33550);
        if (tiepointTag != null) {
            this.tiepoints = tiepointTag.getAsDoubles();
        }
        if (scaleTag != null) {
            this.scales = scaleTag.getAsDoubles();
        }
        if (matrixTag != null) {
            this.matrix = matrixTag.getAsDoubles();
        }
    }

    public void addGeoKey(int key, int type, int count, Object data) {
        XTIFFField geoKey = GeoTIFFDirectory.createField(key, type, count, data);
        this.addGeoKey(geoKey);
    }

    public void addGeoKey(XTIFFField geoKey) {
        this.geoKeyIndex.put(new Integer(geoKey.getTag()), geoKey);
        this.hasGeoKeys = true;
    }

    public XTIFFField[] getGeoKeys() {
        XTIFFField[] keys = new XTIFFField[this.geoKeyIndex.size()];
        Iterator iter = this.geoKeyIndex.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            keys[i++] = (XTIFFField)iter.next();
        }
        return keys;
    }

    public XTIFFField getGeoKey(int key) {
        return (XTIFFField)this.geoKeyIndex.get(new Integer(key));
    }

    public double[] getTiepoints() {
        return this.tiepoints;
    }

    public double[] getPixelScale() {
        return this.scales;
    }

    public double[] getTransformationMatrix() {
        return this.matrix;
    }

    public void setTiepoints(double[] tiepoints) {
        this.tiepoints = tiepoints;
    }

    public void setPixelScale(double[] scales) {
        this.scales = scales;
    }

    public void setTransformationMatrix(double[] matrix) {
        this.matrix = matrix;
    }
}

