/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.jumpcore;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class FlexibleClassLoader
extends URLClassLoader {
    private String id = null;
    private Vector<URLClassLoader> cls = new Vector();
    private Vector<String> blacklist = new Vector();
    private FlexibleClassLoader finalCl = new FlexibleClassLoader();

    public FlexibleClassLoader() {
        super(new URL[0], (ClassLoader)null);
        this.id = this.getCaller();
    }

    public FlexibleClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
        this.id = this.getCaller();
    }

    public FlexibleClassLoader(ClassLoader parent, boolean set_parent) {
        super(new URL[]{}, set_parent ? parent : null);
        this.id = this.getCaller();
        if (!set_parent) {
            this.addCL(parent);
        }
    }

    public FlexibleClassLoader(URL[] urls, ClassLoader parent, boolean set_parent) {
        super(urls, set_parent ? parent : null);
        this.id = this.getCaller();
        if (!set_parent) {
            this.addCL(parent);
        }
    }

    public void prepend(String path) {
        try {
            super.addURL(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void prependURL(URL url) {
        super.addURL(url);
    }

    public void prependURLs(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            super.addURL(urls[i]);
        }
    }

    public boolean prependAllFiles(String path) {
        return this.addAllFiles(path, null, false, true);
    }

    public boolean prependAllFilesRecursive(String path) {
        return this.addAllFiles(path, null, true, true);
    }

    public boolean prependAllFilesRecursive(String path, String suffix) {
        return this.addAllFiles(path, suffix, true, true);
    }

    public void append(String path) {
        try {
            this.finalCl.addURL(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void appendURL(URL url) {
        this.finalCl.addURL(url);
    }

    public void appendURLs(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            this.finalCl.addURL(urls[i]);
        }
    }

    public boolean appendAllFiles(String path) {
        return this.addAllFiles(path, null, false, false);
    }

    public boolean appendAllFilesRecursive(String path) {
        return this.addAllFiles(path, null, true, false);
    }

    public boolean appendAllFilesRecursive(String path, String suffix) {
        return this.addAllFiles(path, suffix, true, false);
    }

    public boolean addAllFiles(String path, String suffix, boolean recursive, boolean prepend) {
        suffix = suffix instanceof String ? suffix : "";
        File file = new File(path);
        File[] files = file.listFiles();
        if (!(files instanceof File[])) {
            files = new File[]{file};
        }
        for (int i = 0; files != null && i < files.length; ++i) {
            file = files[i];
            if (recursive && file.isDirectory()) {
                this.addAllFiles(file.getAbsolutePath(), suffix, recursive, prepend);
                continue;
            }
            if (!file.getName().endsWith(suffix)) continue;
            if (prepend) {
                this.prepend(file.getAbsolutePath());
                continue;
            }
            this.append(file.getAbsolutePath());
        }
        return true;
    }

    public boolean addCL(ClassLoader cl) {
        if (FlexibleClassLoader.isURLCL(cl) && !this.cls.contains(cl)) {
            this.cls.add(0, (URLClassLoader)cl);
            return true;
        }
        return false;
    }

    public boolean remCL(ClassLoader cl) {
        return this.cls.remove(cl);
    }

    public boolean isBlacklisted(String name) {
        for (String entry : this.blacklist) {
            if (!name.matches(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean blacklist(String regexp) {
        for (String entry : this.blacklist) {
            if (!entry.equals(regexp)) continue;
            return false;
        }
        this.blacklist.add(0, regexp);
        return true;
    }

    public boolean whitelist(String regexp) {
        boolean res = false;
        for (String entry : this.blacklist) {
            if (!entry.equals(regexp)) continue;
            res = this.blacklist.remove(entry);
        }
        return res;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        System.out.println(this.getClass().getName() + " loadClass(" + name + ")");
        if (!this.isBlacklisted(name)) {
            try {
                return super.loadClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        System.out.println(this.getClass().getName() + " loadClass parent(" + name + ")");
        for (URLClassLoader cl : this.cls) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        try {
            return this.finalCl.loadClass(name, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public URL findResource(String name) {
        URL url = null;
        if (!(url instanceof URL)) {
            url = super.findResource(name);
        }
        Iterator<URLClassLoader> it = this.cls.iterator();
        while (it.hasNext() && !(url instanceof URL)) {
            URLClassLoader cl = it.next();
            url = cl.findResource(name);
        }
        if (!(url instanceof URL)) {
            url = this.finalCl.findResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Vector<Enumeration<URL>> enums = new Vector<Enumeration<URL>>();
        enums.add(super.findResources(name));
        for (URLClassLoader cl : this.cls) {
            enums.add(cl.findResources(name));
        }
        enums.add(this.finalCl.findResources(name));
        final Vector enums_final = new Vector(enums);
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                URL url = null;
                Iterator it = enums_final.iterator();
                while (it.hasNext() && url == null) {
                    Enumeration urls = (Enumeration)it.next();
                    while (urls.hasMoreElements() && url == null) {
                        url = (URL)urls.nextElement();
                    }
                }
                return url;
            }

            @Override
            public boolean hasMoreElements() {
                Iterator it = enums_final.iterator();
                boolean more = false;
                while (it.hasNext() && !more) {
                    Enumeration urls = (Enumeration)it.next();
                    more = urls.hasMoreElements();
                }
                return more;
            }
        };
    }

    @Override
    public URL[] getURLs() {
        Vector<URL> urls = new Vector<URL>(Arrays.asList(super.getURLs()));
        for (URLClassLoader cl : this.cls) {
            if (cl == this) break;
            URL[] parents = cl.getURLs();
            urls.addAll(Arrays.asList(parents));
        }
        urls.addAll(Arrays.asList(this.finalCl.getURLs()));
        return urls.toArray(new URL[urls.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString() + " --> " + this.id + "\n");
        for (URL url : this.getURLs()) {
            buf.append(url + "\n");
        }
        return buf.toString();
    }

    public static boolean isURLCL(ClassLoader cl) {
        return cl instanceof URLClassLoader;
    }

    public String getCaller() {
        return Thread.currentThread().getStackTrace()[3].toString();
    }

    public static String getBase() {
        return FlexibleClassLoader.getBase(null);
    }

    public static String getBase(Class clazz) {
        URL whereami;
        URL uRL = whereami = clazz instanceof Class ? clazz.getProtectionDomain().getCodeSource().getLocation() : FlexibleClassLoader.class.getProtectionDomain().getCodeSource().getLocation();
        if (whereami == null) {
            return "";
        }
        String path = whereami.toString();
        path = path.endsWith("!/") ? path.subSequence(0, path.length() - 2).toString() : path;
        path = path.startsWith("jar:") ? path.subSequence(4, path.length()).toString() : path;
        path = path.startsWith("file:") ? path.subSequence(5, path.length()).toString() : path;
        File basefile = new File(path);
        String baseFolder = basefile.getAbsolutePath();
        return baseFolder;
    }

    public static String getBaseFolder() {
        return new File(FlexibleClassLoader.getBase()).getParent();
    }
}

