/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.XBasicStyle;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.latlon.deejump.plugin.style.BitmapVertexStyle;
import de.latlon.deejump.plugin.style.CircleVertexStyle;
import de.latlon.deejump.plugin.style.CrossVertexStyle;
import de.latlon.deejump.plugin.style.StarVertexStyle;
import de.latlon.deejump.plugin.style.TriangleVertexStyle;
import de.latlon.deejump.plugin.style.VertexStyleChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Assert;

public class DeeRenderingStylePanel
extends BasicStylePanel
implements StylePanel {
    private static final long serialVersionUID = 2657390245955765563L;
    private Layer layer;
    boolean initialized = false;
    private final JCheckBox vertexCheckBox = new JCheckBox();
    private final VertexStyleChooser vertexStyleChooser = new VertexStyleChooser(false);
    private final JSlider vertexSlider = new JSlider();
    private final JTextField vertexSize = new JTextField();
    private final JPanel previewPanel = new JPanel(){
        private static final long serialVersionUID = -2316761329707400966L;
        private final LayerViewPanel dummyLayerViewPanel;
        private final Viewport viewport;
        private final Feature feature;
        {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setMaximumSize(new Dimension(200, 40));
            this.setMinimumSize(new Dimension(200, 40));
            this.setPreferredSize(new Dimension(200, 40));
            this.dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(){

                @Override
                public void setStatusMessage(String message) {
                }

                @Override
                public void warnUser(String warning) {
                }

                @Override
                public void handleThrowable(Throwable t) {
                }
            });
            this.viewport = new Viewport(this.dummyLayerViewPanel){
                private final AffineTransform transform;
                {
                    this.transform = new AffineTransform();
                }

                @Override
                public Envelope getEnvelopeInModelCoordinates() {
                    return new Envelope(0.0, 200.0, 0.0, 40.0);
                }

                @Override
                public AffineTransform getModelToViewTransform() {
                    return this.transform;
                }

                @Override
                public Point2D toViewPoint(Coordinate modelCoordinate) {
                    return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
                }
            };
            this.feature = this.createFeature();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Style style, Graphics2D g) {
            Stroke originalStroke = g.getStroke();
            try {
                style.paint(this.feature, g, this.viewport);
            }
            catch (Exception exception) {
            }
            finally {
                g.setStroke(originalStroke);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(DeeRenderingStylePanel.this.getBasicStyle(), (Graphics2D)g);
            if (DeeRenderingStylePanel.this.vertexCheckBox.isSelected()) {
                VertexStyle vertexStyle = DeeRenderingStylePanel.this.getVertexStyle();
                vertexStyle.initialize(new Layer(){

                    @Override
                    public BasicStyle getBasicStyle() {
                        return DeeRenderingStylePanel.this.getBasicStyle();
                    }
                });
                this.paint(vertexStyle, (Graphics2D)g);
            }
        }

        private Feature createFeature() {
            try {
                return FeatureUtil.toFeature(new WKTReader().read("POLYGON ((-200 80, 100 20, 400 -40, 400 80, -200 80))"), new FeatureSchema(){
                    private static final long serialVersionUID = -8627306219650589202L;
                    {
                        this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                    }
                });
            }
            catch (ParseException e) {
                Assert.shouldNeverReachHere();
                return null;
            }
        }
    };

    public DeeRenderingStylePanel() {
        this.vertexStyleChooser.sizeSlider = this.vertexSlider;
    }

    String getCurrentVertexStyle() {
        VertexStyle currentVertexStyle = this.layer.getVertexStyle();
        if (currentVertexStyle instanceof SquareVertexStyle) {
            return "SQUARE";
        }
        if (currentVertexStyle instanceof CircleVertexStyle) {
            return "CIRCLE";
        }
        if (currentVertexStyle instanceof CrossVertexStyle) {
            return "CROSS";
        }
        if (currentVertexStyle instanceof TriangleVertexStyle) {
            return "TRIANGLE";
        }
        if (currentVertexStyle instanceof StarVertexStyle) {
            return "STAR";
        }
        if (currentVertexStyle instanceof BitmapVertexStyle) {
            return "BITMAP";
        }
        return "";
    }

    public DeeRenderingStylePanel(Blackboard blackboard, Layer layer, Blackboard persistentBlackboard) {
        super(blackboard, 21);
        this.vertexStyleChooser.setBlackboard(persistentBlackboard);
        this.vertexStyleChooser.setStylePanel(this);
        this.layer = layer;
        this.setBasicStyle(layer.getBasicStyle());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayer(layer);
        if (layer.getVertexStyle() instanceof BitmapVertexStyle) {
            String fileName = ((BitmapVertexStyle)layer.getVertexStyle()).getFileName();
            this.vertexStyleChooser.setCurrentFileName(fileName);
        }
        this.vertexStyleChooser.setSelectedStyle(this.getCurrentVertexStyle());
    }

    @Override
    public void setBasicStyle(BasicStyle basicStyle) {
        super.setBasicStyle(basicStyle);
        if (basicStyle instanceof XBasicStyle) {
            VertexStyle vStyle = ((XBasicStyle)basicStyle).getVertexStyle();
            this.vertexCheckBox.setSelected(vStyle.isEnabled());
            this.vertexSlider.setValue(this.sizeToSlider(vStyle.getSize()));
            this.vertexSize.setText(Integer.toString(vStyle.getSize()));
            if (vStyle instanceof BitmapVertexStyle) {
                String fileName = ((BitmapVertexStyle)vStyle).getFileName();
                this.vertexStyleChooser.setCurrentFileName(fileName);
            } else {
                this.vertexStyleChooser.setSelectedStyle(this.getCurrentVertexStyle());
            }
        }
    }

    @Override
    public void updateControls() {
        super.updateControls();
        if (this.initialized) {
            this.vertexSlider.setEnabled(this.vertexCheckBox.isSelected());
            this.vertexSize.setEnabled(this.vertexCheckBox.isSelected());
            this.vertexStyleChooser.setEnabled(this.vertexCheckBox.isSelected());
            Enumeration e = this.vertexSlider.getLabelTable().elements();
            while (e.hasMoreElements()) {
                JLabel label = (JLabel)e.nextElement();
                label.setEnabled(this.vertexCheckBox.isSelected());
            }
            this.previewPanel.repaint();
        }
    }

    @Override
    public String getTitle() {
        return I18N.getInstance().get("ui.style.RenderingStylePanel.rendering");
    }

    private void setLayer(Layer layer) {
        this.layer = layer;
        VertexStyle vStyle = layer.getVertexStyle();
        this.setSynchronizingLineColor(layer.isSynchronizingLineColor());
        this.vertexCheckBox.setSelected(vStyle.isEnabled());
        this.vertexSlider.setEnabled(vStyle.isEnabled());
        this.vertexSlider.setValue(this.sizeToSlider(vStyle.getSize()));
        this.vertexSize.setEnabled(vStyle.isEnabled());
        this.vertexStyleChooser.setEnabled(vStyle.isEnabled());
        Enumeration e = this.vertexSlider.getLabelTable().elements();
        while (e.hasMoreElements()) {
            ((JLabel)e.nextElement()).setEnabled(vStyle.isEnabled());
        }
        this.previewPanel.repaint();
    }

    @Override
    protected void jbInit() throws Exception {
        if (this.vertexSlider == null) {
            super.jbInit();
            return;
        }
        this.vertexCheckBox.setText(I18N.getInstance().get("ui.style.RenderingStylePanel.vertices-size"));
        this.vertexCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeeRenderingStylePanel.this.updateControls();
            }
        });
        this.vertexSlider.setMinorTickSpacing(1);
        this.vertexSlider.setMajorTickSpacing(0);
        this.vertexSlider.setPaintLabels(true);
        this.vertexSlider.setMinimum(0);
        this.vertexSlider.setValue(0);
        this.vertexSlider.setMaximum(100);
        this.vertexSlider.setSnapToTicks(true);
        this.vertexSlider.setPreferredSize(SLIDER_DIMENSION);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("" + this.sizeFromSlider(0)));
        labelTable.put(new Integer(25), new JLabel("" + this.sizeFromSlider(25)));
        labelTable.put(new Integer(50), new JLabel("" + this.sizeFromSlider(50)));
        labelTable.put(new Integer(75), new JLabel("" + this.sizeFromSlider(75)));
        labelTable.put(new Integer(100), new JLabel("" + this.sizeFromSlider(100)));
        this.vertexSlider.setLabelTable(labelTable);
        this.vertexSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DeeRenderingStylePanel.this.vertexSize.setText(Integer.toString(DeeRenderingStylePanel.this.sizeFromSlider()));
                DeeRenderingStylePanel.this.previewPanel.repaint();
            }
        });
        this.vertexSize.setColumns(3);
        this.vertexSize.setText(Integer.toString(this.sizeFromSlider()));
        this.vertexSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int newValue = Integer.parseInt(DeeRenderingStylePanel.this.vertexSize.getText());
                    if (newValue < DeeRenderingStylePanel.this.sizeFromSlider(0) || newValue > DeeRenderingStylePanel.this.sizeFromSlider(100)) {
                        throw new NumberFormatException();
                    }
                    DeeRenderingStylePanel.this.vertexSlider.setValue(DeeRenderingStylePanel.this.sizeToSlider(newValue));
                    DeeRenderingStylePanel.this.previewPanel.repaint();
                }
                catch (NumberFormatException nfe) {
                    DeeRenderingStylePanel.this.vertexSize.setText("" + DeeRenderingStylePanel.this.sizeFromSlider());
                }
            }
        });
        this.vertexSize.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                block7: {
                    String oldValue = DeeRenderingStylePanel.this.vertexSize.getText();
                    int newValue = 0;
                    try {
                        newValue = Integer.parseInt(oldValue);
                        if (newValue < DeeRenderingStylePanel.this.sizeFromSlider(0) || newValue > DeeRenderingStylePanel.this.sizeFromSlider(100)) {
                            throw new Exception();
                        }
                        DeeRenderingStylePanel.this.vertexSlider.setValue(DeeRenderingStylePanel.this.sizeToSlider(newValue));
                        DeeRenderingStylePanel.this.previewPanel.repaint();
                    }
                    catch (NumberFormatException nfe) {
                        if (DeeRenderingStylePanel.this.vertexSize.getText().equals("")) {
                            DeeRenderingStylePanel.this.vertexSlider.setValue(0);
                        } else {
                            DeeRenderingStylePanel.this.vertexSize.setText("" + DeeRenderingStylePanel.this.sizeFromSlider(DeeRenderingStylePanel.this.vertexSlider.getValue()));
                        }
                    }
                    catch (Exception ex) {
                        if (newValue < DeeRenderingStylePanel.this.sizeFromSlider(0)) {
                            DeeRenderingStylePanel.this.vertexSlider.setValue(0);
                        }
                        if (newValue <= DeeRenderingStylePanel.this.sizeFromSlider(100)) break block7;
                        DeeRenderingStylePanel.this.vertexSize.setText("" + DeeRenderingStylePanel.this.sizeFromSlider(100));
                        DeeRenderingStylePanel.this.vertexSlider.setValue(100);
                    }
                }
            }
        });
        this.centerPanel.add((Component)this.vertexSlider, new GridBagConstraints(1, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexSize, new GridBagConstraints(2, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexCheckBox, new GridBagConstraints(0, 35, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)new JLabel(I18N.getInstance().get("ui.style.RenderingStylePanel.preview")), new GridBagConstraints(0, 40, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.centerPanel.add((Component)this.previewPanel, new GridBagConstraints(0, 45, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexStyleChooser, new GridBagConstraints(0, 50, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.vertexStyleChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeeRenderingStylePanel.this.previewPanel.repaint();
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeeRenderingStylePanel.this.changeVertexStyle();
            }
        };
        this.fillColorChooserPanel.addActionListener(listener);
        this.lineColorChooserPanel.addActionListener(listener);
        this.initialized = true;
    }

    protected void changeVertexStyle() {
        Style st = this.layer.getStyle(VertexStyle.class);
        this.layer.removeStyle(st);
        this.layer.addStyle(this.getVertexStyle());
        this.previewPanel.repaint();
    }

    public VertexStyle getVertexStyle() {
        VertexStyle vStyle = this.vertexStyleChooser.getSelectedStyle();
        vStyle.setEnabled(this.vertexCheckBox.isSelected());
        vStyle.setSize(this.sizeFromSlider());
        return vStyle;
    }

    @Override
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            VertexStyle newVertexStyle = this.getVertexStyle();
            this.layer.removeStyle(this.layer.getBasicStyle());
            this.layer.addStyle(this.getBasicStyle());
            this.layer.removeStyle(this.layer.getVertexStyle());
            this.layer.addStyle(newVertexStyle);
            if (newVertexStyle.isEnabled()) {
                this.layer.getBasicStyle().setRenderingVertices(false);
            }
            this.layer.setSynchronizingLineColor(this.synchronizeCheckBox.isSelected());
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    @Override
    public String validateInput() {
        return null;
    }

    private int sizeFromSlider() {
        return this.sizeFromSlider(this.vertexSlider.getValue());
    }

    private int sizeFromSlider(int i) {
        return (int)Math.rint(Math.pow(1.6, (double)i / 10.0)) + 0;
    }

    private int sizeToSlider(int i) {
        return (int)Math.rint(10.0 * Math.log((double)i - 0.0) / Math.log(1.6));
    }
}

