/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;

public class MapLayer {
    private MapLayer parent = null;
    private final String name;
    private final String title;
    private final List<String> srsList;
    private final BoundingBox bbox;
    private final List<BoundingBox> boundingBoxList;
    private List<MapLayer> subLayers;
    private List<MapStyle> styles;

    public MapLayer(String name, String title, Collection<String> srsList, Collection<MapLayer> subLayers, BoundingBox bbox, List<MapStyle> styles) {
        this.name = name;
        this.title = title;
        this.srsList = new ArrayList<String>(srsList);
        this.setStyles(styles);
        this.subLayers = new ArrayList<MapLayer>(subLayers);
        for (MapLayer subLayer : subLayers) {
            subLayer.parent = this;
        }
        this.bbox = bbox;
        this.boundingBoxList = new ArrayList<BoundingBox>();
    }

    public MapLayer(String name, String title, Collection<String> srsList, Collection<MapLayer> subLayers, BoundingBox bbox, List<BoundingBox> boundingBoxList, List<MapStyle> styles) {
        this(name, title, srsList, subLayers, bbox, styles);
        this.boundingBoxList.addAll(boundingBoxList);
    }

    public List<BoundingBox> getAllBoundingBoxList() {
        ArrayList boundingBoxes = this.getBoundingBoxList();
        if ((boundingBoxes == null || boundingBoxes.size() == 0) && this.getParent() != null) {
            return this.getParent().getAllBoundingBoxList();
        }
        return boundingBoxes == null ? new ArrayList() : boundingBoxes;
    }

    public MapLayer getSubLayer(int n) {
        return this.subLayers.get(n);
    }

    public List<MapLayer> getSubLayerList() {
        return new ArrayList<MapLayer>(this.subLayers);
    }

    public List<MapLayer> getLayerList() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        list.add(this);
        for (MapLayer mapLayer : this.subLayers) {
            list.addAll(mapLayer.getLayerList());
        }
        return list;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public MapLayer getParent() {
        return this.parent;
    }

    public BoundingBox getBoundingBox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        if (this.parent != null) {
            return this.parent.getBoundingBox();
        }
        return null;
    }

    public BoundingBox getBoundingBox(String srs) {
        Envelope envelope = MapLayer.getBoundingBox(srs, this, new Envelope());
        MapLayer p = this;
        while (envelope.getMinX() > envelope.getMaxX() && p.getParent() != null) {
            p = p.getParent();
            for (BoundingBox bb : p.getBoundingBoxList()) {
                if (!srs.equals(bb.getSRS())) continue;
                envelope.expandToInclude(bb.getEnvelope());
                return new BoundingBox(srs, envelope);
            }
        }
        return new BoundingBox(srs, envelope);
    }

    public static Envelope getBoundingBox(String srs, MapLayer lyr, Envelope env) {
        for (BoundingBox bb : lyr.getBoundingBoxList()) {
            if (!srs.equals(bb.getSRS())) continue;
            env.expandToInclude(bb.getEnvelope());
            return env;
        }
        for (MapLayer child : lyr.getSubLayerList()) {
            env.expandToInclude(MapLayer.getBoundingBox(srs, child, env));
        }
        return env;
    }

    public BoundingBox getLatLonBoundingBox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        if (this.parent != null) {
            return this.parent.getBoundingBox();
        }
        return null;
    }

    public List<BoundingBox> getBoundingBoxList() {
        return new ArrayList<BoundingBox>(this.boundingBoxList);
    }

    public List<String> getSRSList() {
        return new ArrayList<String>(this.srsList);
    }

    public Collection<String> getFullSRSList() {
        String firstBBoxSrs;
        LinkedHashSet<String> fullSRSSet = new LinkedHashSet<String>(this.getSRSList());
        if (this.parent != null) {
            fullSRSSet.addAll(this.parent.getFullSRSList());
        }
        LinkedList<String> fullSRSList = new LinkedList<String>(fullSRSSet);
        if (!this.boundingBoxList.isEmpty() && fullSRSList.contains(firstBBoxSrs = this.boundingBoxList.get(0).getSRS())) {
            fullSRSList.remove(firstBBoxSrs);
            fullSRSList.add(0, firstBBoxSrs);
        }
        return fullSRSList;
    }

    public void setSelectedStyle(MapStyle selectedStyle) {
        for (MapStyle style : this.styles) {
            style.setSelected(false, false);
        }
        selectedStyle.setSelected(true, false);
    }

    public MapStyle getStyle(String styleName) {
        for (MapStyle style : this.styles) {
            if (!style.getName().equals(styleName)) continue;
            return style;
        }
        return null;
    }

    public List<MapStyle> getStyles() {
        return this.styles;
    }

    public void setSublayer(ArrayList<MapLayer> sublayer) {
        this.subLayers = sublayer;
    }

    public void setStyles(List<MapStyle> newStyles) {
        this.styles = newStyles;
        for (MapStyle style : this.styles) {
            style.setLayer(this);
        }
        if (!this.styles.isEmpty()) {
            this.styles.get(0).setSelected(true, true);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("WMSLayer {\n  name: \"" + this.name + "\"\n  title: \"" + this.title + "\"\n  srsList: " + this.srsList.toString() + "\n  subLayers: [\n");
        for (MapLayer subLayer : this.subLayers) {
            s.append(subLayer.toString()).append(", ");
        }
        s.append("  ]\n  bbox: ");
        if (this.bbox != null) {
            s.append(this.bbox.toString());
        } else {
            s.append("null");
        }
        s.append("\n}\n");
        return s.toString();
    }
}

