/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Coordinate;

public class GridRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "GRID";
    public static final String ENABLED_KEY = GridRenderer.class + " - ENABLED";
    public static final String DOTS_ENABLED_KEY = GridRenderer.class + " - DOTS ENABLED";
    public static final String LINES_ENABLED_KEY = GridRenderer.class + " - LINES ENABLED";
    private Blackboard blackboard;
    private Stroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f);

    public GridRenderer(Blackboard blackboard, LayerViewPanel panel) {
        super(CONTENT_ID, panel);
        this.blackboard = blackboard;
    }

    @Override
    protected void paint(Graphics2D g) throws NoninvertibleTransformException {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return;
        }
        double gridSize = this.blackboard.get(SnapToGridPolicy.GRID_SIZE_KEY, 20.0);
        double viewGridSize = gridSize * this.panel.getViewport().getScale();
        if (viewGridSize < 5.0) {
            return;
        }
        g.setColor(Color.lightGray);
        double minModelX = Math.floor(this.panel.getViewport().getEnvelopeInModelCoordinates().getMinX() / gridSize) * gridSize;
        double maxModelX = Math.ceil(this.panel.getViewport().getEnvelopeInModelCoordinates().getMaxX() / gridSize) * gridSize;
        double minModelY = Math.floor(this.panel.getViewport().getEnvelopeInModelCoordinates().getMinY() / gridSize) * gridSize;
        double maxModelY = Math.ceil(this.panel.getViewport().getEnvelopeInModelCoordinates().getMaxY() / gridSize) * gridSize;
        if (this.blackboard.get(DOTS_ENABLED_KEY, false)) {
            this.paintDots(g, gridSize, minModelX, maxModelX, minModelY, maxModelY);
        }
        if (this.blackboard.get(LINES_ENABLED_KEY, false)) {
            this.paintLines(g, gridSize, minModelX, maxModelX, minModelY, maxModelY);
        }
    }

    private void paintDots(Graphics2D g, double gridSize, double minModelX, double maxModelX, double minModelY, double maxModelY) throws NoninvertibleTransformException {
        for (double x = minModelX; x < maxModelX; x += gridSize) {
            for (double y = minModelY; y < maxModelY; y += gridSize) {
                Point2D p = this.panel.getViewport().toViewPoint(new Coordinate(x, y));
                g.drawLine((int)p.getX(), (int)p.getY(), (int)p.getX(), (int)p.getY());
            }
        }
    }

    private void paintLines(Graphics2D g, double gridSize, double minModelX, double maxModelX, double minModelY, double maxModelY) throws NoninvertibleTransformException {
        g.setStroke(this.stroke);
        Point2D minXY = this.panel.getViewport().toViewPoint(new Coordinate(minModelX, minModelY));
        Point2D maxXY = this.panel.getViewport().toViewPoint(new Coordinate(maxModelX, maxModelY));
        int minViewX = Math.max(-1, (int)minXY.getX());
        int maxViewX = Math.min(this.panel.getWidth() + 1, (int)maxXY.getX());
        int minViewY = Math.max(-1, (int)Math.min(minXY.getY(), maxXY.getY()));
        int maxViewY = Math.min(this.panel.getHeight() + 1, (int)Math.max(minXY.getY(), maxXY.getY()));
        for (double x = minModelX; x < maxModelX; x += gridSize) {
            int viewX = (int)this.panel.getViewport().toViewPoint(new Coordinate(x, minModelY)).getX();
            if (viewX < 0 || viewX > this.panel.getWidth()) continue;
            g.drawLine(viewX, minViewY, viewX, maxViewY);
        }
        for (double y = minModelY; y < maxModelY; y += gridSize) {
            int viewY = (int)this.panel.getViewport().toViewPoint(new Coordinate(minModelX, y)).getY();
            if (viewY < 0 || viewY > this.panel.getHeight()) continue;
            g.drawLine(minViewX, viewY, maxViewX, viewY);
        }
    }
}

