/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.util.ScreenScale;

public class LabelStyle
implements Style {
    public static final int FONT_BASE_SIZE = 12;
    public static final String FID_COLUMN = "$FID";
    public static final String ABOVE_LINE = "ABOVE_LINE";
    public static final String ON_LINE = "ON_LINE";
    public static final String BELOW_LINE = "BELOW_LINE";
    public static final String DEFAULT = "DEFAULT";
    public static final String[] verticalAlignmentLookup = new String[]{"ABOVE_LINE", "ON_LINE", "BELOW_LINE", "DEFAULT"};
    public static final String LEFT_SIDE = "LEFT_SIDE";
    public static final String CENTER = "CENTER";
    public static final String RIGHT_SIDE = "RIGHT_SIDE";
    public static final String[] horizontalPositionLookup = new String[]{"LEFT_SIDE", "CENTER", "RIGHT_SIDE"};
    public static String DEFAULT_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.default");
    public static String ABOVE_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.above");
    public static String MIDDLE_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.middle");
    public static String BELOW_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.below");
    public static final String LEFT_SIDE_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.left-side");
    public static final String CENTER_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.center");
    public static final String RIGHT_SIDE_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.right-side");
    public static final String JUSTIFY_CENTER_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.centered");
    public static final String JUSTIFY_LEFT_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.left-alignment");
    public static final String JUSTIFY_RIGHT_TEXT = I18N.getInstance().get("ui.renderer.style.LabelStyle.right-alignment");
    public static final int JUSTIFY_CENTER = 0;
    public static final int JUSTIFY_LEFT = 1;
    public static final int JUSTIFY_RIGHT = 2;
    private final GeometryFactory factory = new GeometryFactory();
    private Color originalColor;
    private AffineTransform originalTransform;
    private Layer layer;
    private Geometry viewportRectangle = null;
    private final InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private Quadtree labelsDrawn = null;
    private String attribute = "$FID";
    private String angleAttribute = "";
    private String heightAttribute = "";
    private boolean enabled = false;
    private Color color = Color.black;
    private Font font = new Font("Dialog", 0, 12);
    private boolean scaling = false;
    private double height = 12.0;
    private boolean hidingOverlappingLabels = true;
    public String verticalAlignment = "DEFAULT";
    public String horizontalPosition = "CENTER";
    private int horizontalAlignment = 0;
    private boolean outlineShowing = false;
    private Color outlineColor = new Color(230, 230, 230, 192);
    private double outlineWidth = 4.0;
    private Stroke outlineStroke = new BasicStroke(4.0f, 0, 2);
    private boolean hideAtScale = false;
    private double scaleToHideAt = 20000.0;

    @Override
    public void initialize(Layer layer) {
        this.labelsDrawn = new Quadtree();
        this.viewportRectangle = null;
        this.layer = layer;
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        Geometry viewportIntersection;
        String attributeStringValue;
        Object attributeValue;
        if (this.isHidingAtScale()) {
            double realScale;
            double scale = this.height / (double)this.getFont().getSize2D();
            if (this.isScaling()) {
                scale *= viewport.getScale();
            }
            if ((realScale = ScreenScale.getHorizontalMapScale(viewport)) > this.scaleToHideAt) {
                return;
            }
        }
        if ((attributeValue = this.getAttributeValue(f)) == null) {
            return;
        }
        if (attributeValue instanceof String) {
            attributeStringValue = ((String)attributeValue).trim();
            if (attributeStringValue.length() == 0) {
                return;
            }
        } else if (attributeValue instanceof Date) {
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            attributeStringValue = dateFormat.format((Date)attributeValue);
        } else if (attributeValue instanceof Double) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            attributeStringValue = numberFormat.format((Double)attributeValue);
        } else if (attributeValue instanceof Integer) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            attributeStringValue = numberFormat.format(((Integer)attributeValue).intValue());
        } else {
            attributeStringValue = attributeValue.toString();
        }
        Geometry geom = f.getGeometry();
        double pixelSize = viewport.getEnvelopeInModelCoordinates().getWidth() / viewport.getPanel().getSize().getWidth();
        if (geom.getNumPoints() > 64 && ((geom = DouglasPeuckerSimplifier.simplify((Geometry)f.getGeometry(), (double)pixelSize)).isEmpty() || !geom.isValid())) {
            geom = f.getGeometry();
        }
        if ((viewportIntersection = this.intersection(geom, viewport)) == null || viewportIntersection.isEmpty()) {
            return;
        }
        ModelSpaceLabelSpec spec = this.modelSpaceLabelSpec(viewportIntersection);
        Point2D labelCentreInViewSpace = viewport.toViewPoint(new Point2D.Double(spec.location.x, spec.location.y));
        this.paint(g, attributeStringValue, viewport, labelCentreInViewSpace, LabelStyle.angle(f, this.getAngleAttribute(), spec.angle), LabelStyle.height(f, this.getHeightAttribute(), this.getHeight()), spec.dim);
    }

    private Object getAttributeValue(Feature f) {
        if (this.getAttribute().equals(FID_COLUMN)) {
            return f.getID() + "";
        }
        if (!f.getSchema().hasAttribute(this.getAttribute())) {
            return null;
        }
        return f.getAttribute(this.getAttribute());
    }

    public static double angle(Feature feature, String angleAttributeName, double defaultAngle) {
        if (angleAttributeName.equals("")) {
            return defaultAngle;
        }
        Object angleAttribute = feature.getAttribute(angleAttributeName);
        if (angleAttribute == null) {
            return defaultAngle;
        }
        try {
            return Angle.toRadians(Double.parseDouble(angleAttribute.toString().trim()));
        }
        catch (NumberFormatException e) {
            return defaultAngle;
        }
    }

    private ModelSpaceLabelSpec modelSpaceLabelSpec(Geometry geometry) throws NoninvertibleTransformException {
        if (geometry.getDimension() == 1) {
            return this.modelSpaceLabelSpec1D(geometry);
        }
        if (geometry.getDimension() == 0) {
            if (this.layer.getVertexStyle().isEnabled()) {
                int size = this.layer.getVertexStyle().size;
                return new ModelSpaceLabelSpec(this.findPointForVertexSymbology(geometry, size), 0.0, 0);
            }
            return new ModelSpaceLabelSpec(geometry.getCoordinate(), 0.0, 0);
        }
        if (this.verticalAlignment.equals(ON_LINE) || this.verticalAlignment.equals(DEFAULT)) {
            return new ModelSpaceLabelSpec(this.interiorPointFinder.findPoint(geometry), 0.0, 2);
        }
        return new ModelSpaceLabelSpec(this.findPoint(geometry), 0.0, 2);
    }

    public Coordinate findPoint(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new Coordinate(0.0, 0.0);
        }
        Envelope envelope = geometry.getEnvelopeInternal();
        double x = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        double y = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        if (this.verticalAlignment.equals(DEFAULT) && geometry.getDimension() != 2) {
            y = envelope.getMaxY();
        } else if (this.verticalAlignment.equals(ABOVE_LINE)) {
            y = envelope.getMaxY();
        } else if (this.verticalAlignment.equals(BELOW_LINE)) {
            y = envelope.getMinY();
        }
        if (this.horizontalPosition.equals(LEFT_SIDE)) {
            x = envelope.getMinX();
        } else if (this.horizontalPosition.equals(RIGHT_SIDE)) {
            x = envelope.getMaxX();
        }
        return new Coordinate(x, y);
    }

    public Coordinate findPointForVertexSymbology(Geometry geometry, int value) {
        if (geometry.isEmpty()) {
            return new Coordinate(0.0, 0.0);
        }
        Viewport viewport = JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport();
        double viewBaseScale = 1.0;
        double viewScale = viewport.getScale();
        double scaleFactor = viewScale * 1.0;
        value = (int)((double)value / scaleFactor) / 2;
        Envelope envelope = new Envelope(geometry.getCoordinate().x - (double)value, geometry.getCoordinate().x + (double)value, geometry.getCoordinate().y - (double)value, geometry.getCoordinate().y + (double)value);
        double x = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        double y = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        if (this.verticalAlignment.equals(DEFAULT) && geometry.getDimension() != 2) {
            y = envelope.getMaxY();
        } else if (this.verticalAlignment.equals(ABOVE_LINE)) {
            y = envelope.getMaxY();
        } else if (this.verticalAlignment.equals(BELOW_LINE)) {
            y = envelope.getMinY();
        }
        if (this.horizontalPosition.equals(LEFT_SIDE)) {
            x = envelope.getMinX();
        } else if (this.horizontalPosition.equals(RIGHT_SIDE)) {
            x = envelope.getMaxX();
        }
        return new Coordinate(x, y);
    }

    private ModelSpaceLabelSpec modelSpaceLabelSpec1D(Geometry geometry) {
        if (this.horizontalPosition.equals(LEFT_SIDE)) {
            LineSegment segment = this.endSegment(geometry);
            return new ModelSpaceLabelSpec(this.factory.createPoint(segment.p0).getCoordinate(), this.angle(segment), 1);
        }
        if (this.horizontalPosition.equals(RIGHT_SIDE)) {
            LineSegment segment = this.endSegment(geometry);
            return new ModelSpaceLabelSpec(this.factory.createPoint(segment.p1).getCoordinate(), this.angle(segment), 1);
        }
        LineSegment segment = this.longestSegment(geometry);
        return new ModelSpaceLabelSpec(this.horizontalAlignment == 0 ? CoordUtil.average(segment.p0, segment.p1) : (this.horizontalAlignment == 1 ? segment.p0 : segment.p1), this.angle(segment), 1);
    }

    private double angle(LineSegment segment) {
        double angle = Angle.angle(segment.p0, segment.p1);
        if (angle < -1.5707963267948966) {
            angle += Math.PI;
        }
        if (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        return angle;
    }

    private LineSegment longestSegment(Geometry geometry) {
        double maxSegmentLength = -1.0;
        Coordinate c0 = null;
        Coordinate c1 = null;
        List<Coordinate[]> arrays = CoordinateArrays.toCoordinateArrays(geometry, false);
        for (Coordinate[] coordinates : arrays) {
            for (int j = 1; j < coordinates.length; ++j) {
                double length = coordinates[j - 1].distance(coordinates[j]);
                if (!(length > maxSegmentLength)) continue;
                maxSegmentLength = length;
                c0 = coordinates[j - 1];
                c1 = coordinates[j];
            }
        }
        return new LineSegment(c0, c1);
    }

    private LineSegment endSegment(Geometry geometry) {
        Coordinate c0 = geometry.getCoordinates()[0];
        Coordinate c1 = geometry.getCoordinates()[geometry.getNumPoints() - 1];
        if (c0.x <= c1.x && this.horizontalPosition.equals(LEFT_SIDE)) {
            if (this.horizontalAlignment == 2) {
                return new LineSegment(c0, new Coordinate(c1.x, c0.y));
            }
            return new LineSegment(c0, geometry.getCoordinates()[1]);
        }
        if (c0.x <= c1.x && this.horizontalPosition.equals(RIGHT_SIDE)) {
            if (this.horizontalAlignment == 1) {
                return new LineSegment(c1, new Coordinate(c1.x + 1.0, c1.y));
            }
            return new LineSegment(geometry.getCoordinates()[geometry.getNumPoints() - 2], c1);
        }
        if (c0.x > c1.x && this.horizontalPosition.equals(LEFT_SIDE)) {
            if (this.horizontalAlignment == 2) {
                return new LineSegment(new Coordinate(c1.x - 1.0, c1.y), c1);
            }
            return new LineSegment(c1, geometry.getCoordinates()[geometry.getNumPoints() - 2]);
        }
        if (c0.x > c1.x && this.horizontalPosition.equals(RIGHT_SIDE)) {
            if (this.horizontalAlignment == 1) {
                return new LineSegment(new Coordinate(c0.x - 1.0, c0.y), c0);
            }
            return new LineSegment(geometry.getCoordinates()[1], c0);
        }
        return this.longestSegment(geometry);
    }

    public static double height(Feature feature, String heightAttributeName, double defaultHeight) {
        if (heightAttributeName.equals("")) {
            return defaultHeight;
        }
        Object heightAttribute = feature.getAttribute(heightAttributeName);
        if (heightAttribute == null) {
            return defaultHeight;
        }
        try {
            return Double.parseDouble(heightAttribute.toString().trim());
        }
        catch (NumberFormatException e) {
            return defaultHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, String text, Viewport viewport, Point2D viewCentre, double angle, double height, int dim) {
        this.setup(g);
        try {
            double viewportScale = viewport.getScale();
            double scale = height / (double)this.getFont().getSize2D();
            if (this.isScaling()) {
                scale *= viewportScale;
            }
            TextLayout layout = new TextLayout(text, this.getFont(), g.getFontRenderContext());
            AffineTransform transform = g.getTransform();
            this.configureTransform(transform, viewCentre, scale, layout, angle, dim);
            g.setTransform(transform);
            if (this.isHidingOverlappingLabels()) {
                Envelope transformedLabelBoundsEnvelope;
                Area transformedLabelBounds = new Area(layout.getBounds()).createTransformedArea(transform);
                if (this.collidesWithExistingLabel(transformedLabelBounds, transformedLabelBoundsEnvelope = this.envelope(transformedLabelBounds))) {
                    return;
                }
                this.labelsDrawn.insert(transformedLabelBoundsEnvelope, (Object)transformedLabelBounds);
            }
            if (this.outlineShowing) {
                g.setColor(this.outlineColor);
                g.setStroke(this.outlineStroke);
                g.draw(layout.getOutline(null));
            }
            g.setColor(this.getColor());
            layout.draw(g, 0.0f, 0.0f);
        }
        finally {
            this.cleanup(g);
        }
    }

    private Envelope envelope(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        return new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    private boolean collidesWithExistingLabel(Area transformedLabelBounds, Envelope transformedLabelBoundsEnvelope) {
        List potentialCollisions = this.labelsDrawn.query(transformedLabelBoundsEnvelope);
        for (Area potentialCollision : potentialCollisions) {
            Area intersection = new Area(potentialCollision);
            intersection.intersect(transformedLabelBounds);
            if (intersection.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void setup(Graphics2D g) {
        this.originalTransform = g.getTransform();
        this.originalColor = g.getColor();
    }

    private void cleanup(Graphics2D g) {
        g.setTransform(this.originalTransform);
        g.setColor(this.originalColor);
    }

    private Geometry intersection(Geometry geometry, Viewport viewport) {
        Geometry geo;
        try {
            geo = geometry.intersection(this.viewportRectangle(viewport));
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        if (geo.getNumGeometries() == 0) {
            return null;
        }
        return geo;
    }

    private Geometry viewportRectangle(Viewport viewport) throws NoninvertibleTransformException {
        if (this.viewportRectangle == null) {
            Envelope e = viewport.toModelEnvelope(0.0, viewport.getPanel().getWidth(), 0.0, viewport.getPanel().getHeight());
            this.viewportRectangle = this.factory.createPolygon(this.factory.createLinearRing(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMinY())}), null);
        }
        return this.viewportRectangle;
    }

    private void configureTransform(AffineTransform transform, Point2D viewCentre, double scale, TextLayout layout, double angle, int dim) {
        double xTranslation = viewCentre.getX();
        double yTranslation = viewCentre.getY() + scale * GUIUtil.trueAscent(layout) / 2.0;
        if (dim == 1) {
            xTranslation -= this.horizontalAlignmentOffset(scale * layout.getBounds().getWidth());
            yTranslation -= this.verticalAlignmentOffset(scale * layout.getBounds().getHeight(), dim);
        } else if (dim == 0) {
            xTranslation -= this.horizontalPositionOffset(scale * layout.getBounds().getWidth());
            yTranslation -= this.verticalAlignmentOffset(scale * layout.getBounds().getHeight(), dim);
        } else {
            xTranslation -= this.horizontalAlignmentOffset(scale * layout.getBounds().getWidth());
            yTranslation -= this.verticalAlignmentOffset(scale * layout.getBounds().getHeight(), dim);
        }
        transform.rotate(-angle, viewCentre.getX(), viewCentre.getY());
        transform.translate(xTranslation, yTranslation);
        transform.scale(scale, scale);
    }

    private double verticalAlignmentOffset(double scaledLabelHeight, int dim) {
        if (this.getVerticalAlignment().equals(ON_LINE) || this.getVerticalAlignment().equals(DEFAULT) && dim == 2) {
            return 0.0;
        }
        double buffer = 3.0;
        double offset = 3.0 + (double)this.layer.getBasicStyle().getLineWidth() / 2.0 + scaledLabelHeight / 2.0;
        if (this.getVerticalAlignment().equals(ABOVE_LINE) || this.getVerticalAlignment().equals(DEFAULT) && dim != 2) {
            return offset;
        }
        if (this.getVerticalAlignment().equals(BELOW_LINE)) {
            return -offset;
        }
        Assert.shouldNeverReachHere();
        return 0.0;
    }

    private double horizontalPositionOffset(double width) {
        if (this.getHorizontalPosition().equals(LEFT_SIDE)) {
            return width;
        }
        if (this.getHorizontalPosition().equals(CENTER)) {
            return width / 2.0;
        }
        if (this.getHorizontalPosition().equals(RIGHT_SIDE)) {
            return 0.0;
        }
        Assert.shouldNeverReachHere();
        return 0.0;
    }

    private double horizontalAlignmentOffset(double width) {
        if (this.getHorizontalAlignment() == 0) {
            return width / 2.0;
        }
        if (this.getHorizontalAlignment() == 1) {
            return 0.0;
        }
        if (this.getHorizontalAlignment() == 2) {
            return width;
        }
        Assert.shouldNeverReachHere();
        return 0.0;
    }

    public double getVerticalAlignmentOffset(int dim) {
        return this.verticalAlignmentOffset(this.getHeight(), dim) - this.getHeight() / 2.0;
    }

    public double getHorizontalAlignmentOffset(String text) {
        return this.horizontalAlignmentOffset((double)text.length() * this.getHeight() * 0.6);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAngleAttribute() {
        return this.angleAttribute;
    }

    public String getHeightAttribute() {
        return this.heightAttribute;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isHidingOverlappingLabels() {
        return this.hidingOverlappingLabels;
    }

    public boolean isHidingAtScale() {
        return this.hideAtScale;
    }

    public boolean getHideAtScale() {
        return this.hideAtScale;
    }

    public String getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public String getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public boolean getHidingOverlappingLabels() {
        return this.hidingOverlappingLabels;
    }

    public boolean getOutlineShowing() {
        return this.outlineShowing;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public double getScaleToHideAt() {
        return this.scaleToHideAt;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setHorizontalPosition(String horizontalPosition) {
        this.horizontalPosition = horizontalPosition;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setAngleAttribute(String angleAttribute) {
        this.angleAttribute = angleAttribute;
    }

    public void setHeightAttribute(String heightAttribute) {
        this.heightAttribute = heightAttribute;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setHidingOverlappingLabels(boolean hidingOverlappingLabels) {
        this.hidingOverlappingLabels = hidingOverlappingLabels;
    }

    public void setOutlineShowing(boolean outlineShowing) {
        this.outlineShowing = outlineShowing;
    }

    public void setOutlineWidth(double outlineWidth) {
        this.outlineWidth = outlineWidth;
        this.outlineStroke = new BasicStroke((float)outlineWidth, 0, 2);
    }

    public void setScaleToHideAt(double scaleToHideAt) {
        this.scaleToHideAt = scaleToHideAt;
    }

    public void setOutlineColor(Color outlineColor, int alpha) {
        this.outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), alpha);
    }

    public void setOutlineColor(Color outlineColor) {
        if (outlineColor != null) {
            int alpha = this.outlineColor.getAlpha();
            this.setOutlineColor(outlineColor, alpha);
        }
    }

    public void setHideAtScale(boolean hideAtScale) {
        this.hideAtScale = hideAtScale;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    private class ModelSpaceLabelSpec {
        public double angle;
        public Coordinate location;
        public int dim;

        public ModelSpaceLabelSpec(Coordinate location, double angle, int dim) {
            this.location = location;
            this.angle = angle;
            this.dim = dim;
        }
    }
}

