/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.EditWMSQueryPanel;
import com.vividsolutions.wms.MapLayer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class EditWMSQueryPlugIn
extends AbstractPlugIn {
    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("edit.gif");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WMSLayer layer = context.getLayerNamePanel().selectedNodes(WMSLayer.class).iterator().next();
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPlugIn.edit-wms-query"), true);
        dialog.setSideBarImage(IconLoader.icon("EditWMSLayer.jpg"));
        dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPlugIn.this-dialog-enables-you-to-change-the-layers-being-retrieved-from-a-web-map-server"));
        EditWMSQueryPanel panel = new EditWMSQueryPanel(layer);
        dialog.addRow(I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPlugIn.chosen-layers"), new JLabel(""), panel, panel.getEnableChecks(), "", 0, 1);
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            layer.removeAllLayerNames();
            for (MapLayer mapLayer : panel.getChosenMapLayers()) {
                layer.addLayerName(mapLayer.getName());
            }
            layer.setService(panel.getService());
            layer.setSRS(panel.getSRS());
            layer.setFormat(panel.getFormat());
            layer.setStyle(panel.getStyle());
            layer.setAlpha(panel.getAlpha());
            layer.setWmsVersion(panel.getService().getVersion());
            layer.setName(panel.getChosenMapLayers().get(0).getTitle());
            layer.fireAppearanceChanged();
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            list.add(panel.getService().getServerUrl());
            list.addAll(Arrays.asList(panel.getUrlList()));
            PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).put("AddWMSQueryPlugin.CACHED_URL", StringUtils.join(list, (String)","));
            return true;
        }
        return false;
    }
}

