/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.RecordPanel;
import com.vividsolutions.jump.workbench.ui.RecordPanelModel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RunDatastoreQueryPanel
extends ConnectionPanel
implements ActionListener,
RecordPanelModel {
    private JTextField layerNameTextField;
    private Hashtable queryMap = new Hashtable();
    private ArrayList currentConnectionQueries = new ArrayList();
    private int currentIndex = -1;
    private RecordPanel recordPanel = new RecordPanel(this);
    private LayerManager layerManager;
    private JTextArea queryTextArea;

    public RunDatastoreQueryPanel(WorkbenchContext context) {
        super(context);
        this.layerManager = context.getLayerManager();
        this.initialize();
    }

    @Override
    public int getRecordCount() {
        int num = 0;
        if (this.currentConnectionQueries != null) {
            num = this.currentConnectionQueries.size();
        }
        return num;
    }

    @Override
    public void setCurrentIndex(int index) {
        this.currentIndex = index;
        String query = null;
        if (index > -1) {
            query = (String)this.currentConnectionQueries.get(index);
        }
        this.getQueryTextArea().setText(query);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    private void initialize() {
        JButton jbView = new JButton(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.View"));
        jbView.setToolTipText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.View-Help"));
        final LayerManager layerM = this.layerManager;
        jbView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentSRID = layerM.getBlackboard().get("SRID", 0);
                RunDatastoreQueryPanel.this.queryTextArea.replaceSelection("${view:" + currentSRID + "}");
                RunDatastoreQueryPanel.this.queryTextArea.requestFocusInWindow();
            }
        });
        JButton jbFence = new JButton(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Fence"));
        jbFence.setToolTipText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Fence-Help"));
        jbFence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentSRID = layerM.getBlackboard().get("SRID", 0);
                RunDatastoreQueryPanel.this.queryTextArea.replaceSelection("${fence:" + currentSRID + "}");
                RunDatastoreQueryPanel.this.queryTextArea.requestFocusInWindow();
            }
        });
        JButton jbSelection = new JButton(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Selection"));
        jbSelection.setToolTipText(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Selection-Help"));
        jbSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentSRID = layerM.getBlackboard().get("SRID", 0);
                RunDatastoreQueryPanel.this.queryTextArea.replaceSelection("${selection:" + currentSRID + "}");
                RunDatastoreQueryPanel.this.queryTextArea.requestFocusInWindow();
            }
        });
        JPanel jpButtons = new JPanel(new GridLayout(3, 1));
        jpButtons.add(jbView);
        jpButtons.add(jbFence);
        jpButtons.add(jbSelection);
        this.addRow("Layer-Name", this.getLayerNameTextField(), null, false);
        this.addRow("Query", new JScrollPane(this.getQueryTextArea()){
            {
                this.setPreferredSize(new Dimension(550, 100));
            }
        }, jpButtons, true);
        this.add((Component)this.recordPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0));
        this.getConnectionComboBox().addActionListener(this);
    }

    private JTextField getLayerNameTextField() {
        if (this.layerNameTextField == null) {
            this.layerNameTextField = new JTextField(this.layerManager.uniqueLayerName(I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.New-Query-Layer")));
        }
        return this.layerNameTextField;
    }

    private JTextArea getQueryTextArea() {
        if (this.queryTextArea == null) {
            this.queryTextArea = new JTextArea();
        }
        return this.queryTextArea;
    }

    @Override
    public String validateInput() {
        String errMsg = super.validateInput();
        if (errMsg == null && this.getQuery().length() == 0) {
            errMsg = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Required-field-missing-Query");
        }
        return errMsg;
    }

    public String getLayerName() {
        return this.layerManager.uniqueLayerName(this.layerNameTextField.getText().trim());
    }

    public void setLayerName(String layerName) {
        this.layerNameTextField.setText(layerName);
    }

    public String getQuery() {
        return this.queryTextArea.getText().trim();
    }

    public void setQuery(String query) {
        this.getQueryTextArea().setText(query);
    }

    public void saveQuery() {
        String query = this.getQuery();
        this.currentConnectionQueries.add(query);
        this.currentIndex = this.currentConnectionQueries.size() - 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ConnectionDescriptor cd = this.getConnectionDescriptor();
        if (cd != null) {
            if (this.queryMap.containsKey(cd)) {
                ArrayList prevQueries;
                this.currentConnectionQueries = prevQueries = (ArrayList)this.queryMap.get(cd);
            } else {
                this.currentConnectionQueries = new ArrayList();
                this.queryMap.put(cd, this.currentConnectionQueries);
            }
            this.setCurrentIndex(this.currentConnectionQueries.size() - 1);
            this.recordPanel.updateAppearance();
        }
    }

    @Override
    protected Collection connectionDescriptors() {
        return CollectionUtil.select(super.connectionDescriptors(), new Block(){

            @Override
            public Object yield(Object connectionDescriptor) {
                try {
                    return RunDatastoreQueryPanel.this.connectionManager().getDriver(((ConnectionDescriptor)connectionDescriptor).getDataStoreDriverClassName()).isAdHocQuerySupported();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

