/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.jdbc.JDBCUtil;
import com.vividsolutions.jump.datastore.jdbc.ResultSetBlock;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreLayerRenderData;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreLayerRowModel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreLayerTreeModel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreLayerWhereEditor;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreTableCellListener;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openjump.core.ui.plugin.datastore.AddDataStoreLayerWizardPanel;

public class AddDatastoreLayerPanel
extends ConnectionPanel {
    private Map connectionDescriptorToDatasetNamesMap = new HashMap();
    private Outline datasetOutline = null;
    private TreeModel datasetTreeModel = null;
    private OutlineModel datasetOutlineModel = null;
    private ArrayList<DataStoreLayer> selectedLayers = null;

    public AddDatastoreLayerPanel() {
        super((WorkbenchContext)null);
    }

    public AddDatastoreLayerPanel(WorkbenchContext context) {
        super(context);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddDatastoreLayerPanel.this.initialize();
            }
        });
        this.getConnectionComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDatastoreLayerPanel.this.getDatasetOutline();
            }
        });
    }

    public static Object runInKillableThread(final String description, WorkbenchContext context, final Block block) {
        final Object[] result = new Object[]{null};
        AbstractPlugIn.toActionListener(new ThreadedBasePlugIn(){

            @Override
            public String getName() {
                return description;
            }

            @Override
            public boolean execute(PlugInContext context) throws Exception {
                return true;
            }

            @Override
            public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
                monitor.report(description);
                result[0] = block.yield();
            }
        }, context, new TaskMonitorManager()).actionPerformed(null);
        return result[0];
    }

    public List<DataStoreLayer> getDatasetLayers() {
        return this.selectedLayers;
    }

    @Override
    public String validateInput() {
        if (super.validateInput() != null) {
            return super.validateInput();
        }
        if (this.selectedLayers == null || this.selectedLayers.size() == 0) {
            return I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Required-field-missing-Dataset");
        }
        return null;
    }

    private Outline getDatasetOutline() {
        if (this.datasetOutline == null) {
            LinkedHashMap<String, ArrayList<DataStoreLayer>> root = new LinkedHashMap<String, ArrayList<DataStoreLayer>>();
            this.datasetTreeModel = new DataStoreLayerTreeModel(root);
            this.datasetOutlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)this.datasetTreeModel, (RowModel)new DataStoreLayerRowModel(), (boolean)true, (String)I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Schemas"));
            this.datasetOutline = new Outline();
            final AddDatastoreLayerPanel panel = this;
            this.datasetOutline.setRootVisible(false);
            this.datasetOutline.setModel((TableModel)this.datasetOutlineModel);
            this.datasetOutline.setRenderDataProvider((RenderDataProvider)new DataStoreLayerRenderData());
            this.setTableColWidth();
            this.datasetOutline.setDefaultEditor(String.class, (TableCellEditor)new DataStoreLayerWhereEditor());
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s;
                    DataStoreTableCellListener tcl = (DataStoreTableCellListener)e.getSource();
                    Object o = AddDatastoreLayerPanel.this.datasetOutline.getValueAt(tcl.getRow(), 0);
                    if (o instanceof DataStoreLayer && !(s = AddDatastoreLayerPanel.this.checkSelectedLayer((DataStoreLayer)o)).isEmpty()) {
                        ErrorDialog.show(panel, I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.SQL-error"), I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Invalid-layer-where-clause") + " " + ((DataStoreLayer)o).getFullName(), s);
                    }
                }
            };
            DataStoreTableCellListener tcl = new DataStoreTableCellListener((JTable)this.datasetOutline, action);
            this.datasetOutline.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (!e.getValueIsAdjusting() && !lsm.isSelectionEmpty()) {
                        AddDatastoreLayerPanel.this.selectedLayers = new ArrayList();
                        int minIndex = lsm.getMinSelectionIndex();
                        int maxIndex = lsm.getMaxSelectionIndex();
                        for (int i = minIndex; i <= maxIndex; ++i) {
                            Object o;
                            if (!lsm.isSelectedIndex(i) || !((o = AddDatastoreLayerPanel.this.datasetOutline.getValueAt(i, 0)) instanceof DataStoreLayer)) continue;
                            AddDatastoreLayerPanel.this.selectedLayers.add((DataStoreLayer)o);
                        }
                    }
                    Component c = panel;
                    while (c != null && (c = c.getParent()) != null) {
                        if (!(c instanceof WizardPanel)) continue;
                        ((AddDataStoreLayerWizardPanel)c).selectionChanged();
                        break;
                    }
                }
            });
        }
        this.populateDatasetTree();
        return this.datasetOutline;
    }

    private void setTableColWidth() {
        if (this.datasetOutline != null) {
            this.datasetOutline.getColumnModel().getColumn(0).setPreferredWidth(195);
            this.datasetOutline.getColumnModel().getColumn(1).setPreferredWidth(227);
            this.datasetOutline.getColumnModel().getColumn(2).setPreferredWidth(72);
            this.datasetOutline.getColumnModel().getColumn(3).setPreferredWidth(40);
            this.datasetOutline.getColumnModel().getColumn(4).setPreferredWidth(40);
        }
    }

    public Object[] sortGeometryColumns(List<GeometryColumn> list) {
        Collections.sort(list, new Comparator<GeometryColumn>(){

            @Override
            public int compare(GeometryColumn o1, GeometryColumn o2) {
                return o1.getName().compareTo(o2.getName());
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        return list.toArray(new GeometryColumn[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatasetTree() {
        if (this.getConnectionDescriptor() == null) {
            return;
        }
        LinkedHashMap<String, ArrayList<DataStoreLayer>> root = new LinkedHashMap<String, ArrayList<DataStoreLayer>>();
        this.datasetTreeModel = new DataStoreLayerTreeModel(root);
        Throwable t = null;
        try {
            this.loadDatasetList(this.getConnectionDescriptor());
        }
        catch (ThreadDeath td) {
            t = td;
        }
        catch (Exception e) {
            t = e;
        }
        finally {
            if (t != null) {
                this.getContext().getErrorHandler().handleThrowable(t);
            }
            this.datasetOutlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)this.datasetTreeModel, (RowModel)new DataStoreLayerRowModel(), (boolean)true, (String)I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Dataset"));
            this.datasetOutline.setModel((TableModel)this.datasetOutlineModel);
            this.setTableColWidth();
            this.datasetOutline.setDefaultEditor(String.class, (TableCellEditor)new DataStoreLayerWhereEditor());
        }
    }

    private LinkedHashMap<String, ArrayList<DataStoreLayer>> getTreeModelData(String[] datasetNames, String message) throws Exception {
        ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptor();
        LinkedHashMap<String, ArrayList<DataStoreLayer>> ret = new LinkedHashMap<String, ArrayList<DataStoreLayer>>();
        if (datasetNames == null || datasetNames.length == 0) {
            ret.put(message, new ArrayList());
            return ret;
        }
        DataStoreMetadata md = new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this).getMetadata();
        if (md instanceof SpatialDatabasesDSMetadata && ((SpatialDatabasesDSMetadata)md).getDataStoreLayers() != null) {
            for (DataStoreLayer layer : ((SpatialDatabasesDSMetadata)md).getDataStoreLayers()) {
                ArrayList<DataStoreLayer> newEntry = new ArrayList<DataStoreLayer>();
                newEntry.add(layer);
                ArrayList<DataStoreLayer> list = ret.get(layer.getSchema());
                if (list == null) {
                    ret.put(layer.getSchema(), newEntry);
                    continue;
                }
                list.addAll(newEntry);
            }
        } else {
            for (String dsName : datasetNames) {
                for (GeometryColumn geo : md.getGeometryAttributes(dsName)) {
                    DataStoreLayer layer = new DataStoreLayer(dsName, geo);
                    ArrayList<DataStoreLayer> newEntry = new ArrayList<DataStoreLayer>();
                    newEntry.add(layer);
                    ArrayList<DataStoreLayer> list = ret.get(layer.getSchema());
                    if (list == null) {
                        ret.put(layer.getSchema(), newEntry);
                        continue;
                    }
                    list.addAll(newEntry);
                }
            }
        }
        return ret;
    }

    private void loadDatasetList(final ConnectionDescriptor connectionDescriptor) throws Exception {
        new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
        String msgDs = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Retrieving-list-of-datasets");
        final String msgGeoT = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.No-geo-table-found");
        String[] datasetNames = (String[])AddDatastoreLayerPanel.runInKillableThread(msgDs, this.getContext(), new Block(){

            @Override
            public Object yield() throws Exception {
                String[] dsNames = new PasswordPrompter().getOpenConnection(AddDatastoreLayerPanel.this.connectionManager(), connectionDescriptor, AddDatastoreLayerPanel.this).getMetadata().getDatasetNames();
                AddDatastoreLayerPanel.this.datasetTreeModel = new DataStoreLayerTreeModel(AddDatastoreLayerPanel.this.getTreeModelData(dsNames, msgGeoT));
                return dsNames;
            }
        });
        if (datasetNames != null && datasetNames.length != 0) {
            this.connectionDescriptorToDatasetNamesMap.put(connectionDescriptor, datasetNames);
        }
    }

    private void initialize() {
        JScrollPane sp = new JScrollPane((Component)this.getDatasetOutline());
        sp.setPreferredSize(new Dimension(550, 400));
        this.addRow("Dataset", sp, null, false);
    }

    private String checkSelectedLayer(DataStoreLayer layer) {
        StringBuilder ret = new StringBuilder();
        ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptor();
        DataStoreConnection conn = null;
        try {
            conn = new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
            DataStoreMetadata md = conn.getMetadata();
            SpatialReferenceSystemID srid = conn.getMetadata().getSRID(layer.getFullName(), layer.getGeoCol().getName());
            String[] colNames = conn.getMetadata().getColumnNames(layer.getFullName());
            SpatialDatabasesSQLBuilder builder = conn.getSqlBuilder(srid, colNames);
            String sql = builder.getCheckSQL(layer);
            try {
                JDBCUtil.execute(conn.getJdbcConnection(), sql, new ResultSetBlock(){

                    @Override
                    public void yield(ResultSet resultSet) throws SQLException {
                    }
                });
            }
            catch (Exception e) {
                ret.append(layer.getFullName()).append(": ").append(e.getMessage()).append("\nCause: ").append(e.getCause().getMessage());
            }
        }
        catch (Exception e) {
            ret.append(e.getMessage());
        }
        return ret.toString();
    }

    public static interface Block {
        public Object yield() throws Exception;
    }
}

