/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryPredicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class SpatialJoinExecuter {
    private FeatureCollection tgtAFC;
    private FeatureCollection srcBFC;
    private FeatureCollection queryFC;
    private boolean isExceptionThrown = false;
    private Exception exception;
    private Geometry[] geoms = new Geometry[2];
    private Set resultSet = new HashSet();

    public SpatialJoinExecuter(FeatureCollection srcBFC, FeatureCollection tgtAFC) {
        this.tgtAFC = tgtAFC;
        this.srcBFC = srcBFC;
    }

    private void createQueryFeatureCollection(GeometryPredicate pred) {
        boolean buildIndex = false;
        if (this.tgtAFC.size() > 10) {
            buildIndex = true;
        }
        if (this.srcBFC.size() > 100) {
            buildIndex = true;
        }
        if (pred instanceof GeometryPredicate.DisjointPredicate) {
            buildIndex = false;
        }
        this.queryFC = buildIndex ? new IndexedFeatureCollection(this.srcBFC) : this.srcBFC;
    }

    private Iterator query(GeometryPredicate pred, double[] params, Geometry gMask) {
        Envelope queryEnv = gMask.getEnvelopeInternal();
        if (pred instanceof GeometryPredicate.WithinDistancePredicate) {
            queryEnv.expandBy(params[0]);
        }
        boolean useQuery = true;
        if (pred instanceof GeometryPredicate.DisjointPredicate) {
            useQuery = false;
        }
        Iterator<Feature> queryIt = null;
        if (useQuery) {
            List<Feature> queryResult = this.queryFC.query(queryEnv);
            queryIt = queryResult.iterator();
        } else {
            queryIt = this.queryFC.iterator();
        }
        return queryIt;
    }

    public boolean isExceptionThrown() {
        return this.isExceptionThrown;
    }

    public Exception getException() {
        return this.exception;
    }

    private FeatureSchema createResultSchema() {
        FeatureSchema resultFS = new FeatureSchema();
        resultFS.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        this.copyAttributesToSchema(this.tgtAFC.getFeatureSchema(), "A_", resultFS);
        this.copyAttributesToSchema(this.srcBFC.getFeatureSchema(), "B_", resultFS);
        return resultFS;
    }

    private void copyAttributesToSchema(FeatureSchema srcFS, String prefix, FeatureSchema resultFS) {
        for (int i = 0; i < srcFS.getAttributeCount(); ++i) {
            if (srcFS.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            resultFS.addAttribute(prefix + srcFS.getAttributeName(i), srcFS.getAttributeType(i));
        }
    }

    public FeatureCollection getResultFC() {
        return new FeatureDataset(this.createResultSchema());
    }

    private boolean isInResult(Feature f) {
        return this.resultSet.contains(f);
    }

    public void execute(TaskMonitor monitor, GeometryPredicate func, double[] params, FeatureCollection resultFC) {
        this.createQueryFeatureCollection(func);
        int total = this.tgtAFC.size();
        int count = 0;
        Iterator<Feature> iMask = this.tgtAFC.iterator();
        while (iMask.hasNext()) {
            monitor.report(count++, total, "features");
            if (monitor.isCancelRequested()) {
                return;
            }
            Feature tgtFeat = iMask.next();
            Geometry tgtGeom = tgtFeat.getGeometry();
            Iterator queryIt = this.query(func, params, tgtGeom);
            while (queryIt.hasNext()) {
                Geometry srcGeom;
                boolean isInResult;
                Feature srcFeat = (Feature)queryIt.next();
                if (this.isInResult(srcFeat) || !(isInResult = this.isTrue(func, tgtGeom, srcGeom = srcFeat.getGeometry(), params))) continue;
                this.addToResult(tgtFeat, srcFeat, resultFC);
            }
        }
    }

    private void addToResult(Feature fA, Feature fB, FeatureCollection resultFC) {
        BasicFeature fResult = new BasicFeature(resultFC.getFeatureSchema());
        fResult.setGeometry(fA.getGeometry());
        this.copyAttributesToFeature(fA, "A_", fResult);
        this.copyAttributesToFeature(fB, "B_", fResult);
        resultFC.add(fResult);
    }

    private void copyAttributesToFeature(Feature fSrc, String prefix, Feature fResult) {
        FeatureSchema srcFS = fSrc.getSchema();
        for (int i = 0; i < srcFS.getAttributeCount(); ++i) {
            if (srcFS.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            fResult.setAttribute(prefix + srcFS.getAttributeName(i), fSrc.getAttribute(i));
        }
    }

    private boolean isTrue(GeometryPredicate func, Geometry tgtGeom, Geometry srcGeom, double[] params) {
        try {
            return func.isTrue(tgtGeom, srcGeom, params);
        }
        catch (RuntimeException ex) {
            this.isExceptionThrown = true;
            this.exception = ex;
            return false;
        }
    }
}

