/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class OpenProjectPlugIn
extends ThreadedBasePlugIn {
    private static final String RECENT_MENU_LIST_KEY = OpenProjectPlugIn.class.getName() + " - RECENT_MENU_LIST";
    public static final int RECENT_MENU_LIST_MAX = 8;
    private JFileChooser fileChooser;
    private Task newTask;
    private Task sourceTask;

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.open-project");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    private void initFileChooser() {
        if (this.fileChooser != null) {
            return;
        }
        this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        this.fileChooser.setDialogTitle(I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.open-project"));
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.initFileChooser();
        this.reportNothingToUndoYet(context);
        if (0 != this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            return false;
        }
        this.open(this.fileChooser.getSelectedFile(), context.getWorkbenchFrame());
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.loadLayers(context, this.sourceTask.getLayerManager(), this.newTask.getLayerManager(), CoordinateSystemRegistry.instance(context.getWorkbenchContext().getBlackboard()), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file, WorkbenchFrame workbenchFrame) throws Exception {
        FileReader reader = new FileReader(file);
        try {
            this.sourceTask = (Task)new XML2Java(workbenchFrame.getContext().getWorkbench().getPlugInManager().getClassLoader()).read(reader, Task.class);
            this.initializeDataSources(this.sourceTask, workbenchFrame.getContext());
            this.newTask = new Task();
            this.newTask.setName(GUIUtil.nameWithoutExtension(file));
            this.newTask.setProjectFile(file);
            this.newTask.setProperties(this.sourceTask.getProperties());
            workbenchFrame.addTaskFrame(this.newTask);
        }
        finally {
            reader.close();
            OpenProjectPlugIn.putRecentList(workbenchFrame.getContext(), file.getAbsolutePath());
        }
    }

    public static ArrayList getRecentList(WorkbenchContext context) {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(context);
        if (blackboard.get(RECENT_MENU_LIST_KEY) == null) {
            blackboard.put(RECENT_MENU_LIST_KEY, new ArrayList(8));
        }
        ArrayList list = (ArrayList)blackboard.get(RECENT_MENU_LIST_KEY);
        return list;
    }

    public static void putRecentList(WorkbenchContext context, String path) {
        ArrayList list;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(context);
        if (blackboard.get(RECENT_MENU_LIST_KEY) == null) {
            blackboard.put(RECENT_MENU_LIST_KEY, new ArrayList(8));
        }
        if ((list = (ArrayList)blackboard.get(RECENT_MENU_LIST_KEY)).contains(path)) {
            return;
        }
        if (list.size() >= 8) {
            list.remove(list.size() - 1);
        }
        list.add(0, path);
    }

    private void initializeDataSources(Task task, WorkbenchContext context) {
        for (Layer layer : task.getLayerManager().getLayers()) {
            if (!(layer.getDataSourceQuery().getDataSource() instanceof WorkbenchContextReference)) continue;
            ((WorkbenchContextReference)((Object)layer.getDataSourceQuery().getDataSource())).setWorkbenchContext(context);
        }
    }

    private void loadLayers(PlugInContext context, LayerManager sourceLayerManager, LayerManager newLayerManager, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        FindFile findFile = new FindFile(context);
        boolean displayDialog = true;
        block2: for (Category sourceLayerCategory : sourceLayerManager.getCategories()) {
            newLayerManager.addCategory(sourceLayerCategory.getName());
            ArrayList<Layerable> layerables = new ArrayList<Layerable>(sourceLayerCategory.getLayerables());
            Collections.reverse(layerables);
            for (Layerable layerable : layerables) {
                if (monitor != null) {
                    monitor.report(I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.loading") + " " + layerable.getName());
                }
                layerable.setLayerManager(newLayerManager);
                if (layerable instanceof Layer) {
                    Layer layer = (Layer)layerable;
                    try {
                        OpenProjectPlugIn.load(layer, registry, monitor);
                    }
                    catch (FileNotFoundException ex) {
                        String fname;
                        String filename;
                        if (displayDialog) {
                            displayDialog = false;
                            int response = JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.At-least-one-file-in-the-task-could-not-be-found") + "\n" + I18N.getInstance().get("ui.plugin.OpenProjectPlugIn.Do-you-want-to-locate-it-and-continue-loading-the-task"), "JUMP", 0);
                            if (response != 0) continue block2;
                        }
                        if ((filename = findFile.getFileName(fname = layer.getDataSourceQuery().getDataSource().getProperties().get("File").toString())).length() <= 0) continue block2;
                        Map<String, Object> properties = layer.getDataSourceQuery().getDataSource().getProperties();
                        properties.put("File", filename);
                        layer.getDataSourceQuery().getDataSource().setProperties(properties);
                        OpenProjectPlugIn.load(layer, registry, monitor);
                    }
                }
                newLayerManager.addLayerable(sourceLayerCategory.getName(), layerable);
            }
        }
    }

    public static void load(Layer layer, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        layer.setFeatureCollection(OpenProjectPlugIn.executeQuery(layer.getDataSourceQuery().getQuery(), layer.getDataSourceQuery().getDataSource(), registry, monitor));
        layer.setFeatureCollectionModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(connection.executeQuery(query, monitor), registry);
            return featureCollection;
        }
    }

    public class PathPrefixes {
        private String oldPrefix = "";
        private String newPrefix = "";

        public PathPrefixes(String oldPrefix, String newPrefix) {
            this.oldPrefix = oldPrefix;
            this.newPrefix = newPrefix;
        }

        public String getOldPrefix() {
            return this.oldPrefix;
        }

        public String getNewPrefix() {
            return this.newPrefix;
        }
    }

    public class FindFile {
        private Vector prefixList = new Vector(5, 5);
        private JFileChooser fileChooser;
        private PlugInContext context;

        public FindFile(PlugInContext context) {
            this.context = context;
            this.fileChooser = new JFileChooser();
            this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            this.fileChooser.setDialogTitle("Choose current location of: ");
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
        }

        public FindFile(PlugInContext context, JFileChooser fileChooser) {
            this(context);
            this.fileChooser = fileChooser;
        }

        public String getFileName(String filenamepath) throws Exception {
            File oldFile = new File(filenamepath);
            String oldPath = oldFile.getPath();
            for (PathPrefixes prefix : this.prefixList) {
                if (oldPath.toLowerCase().indexOf(prefix.getOldPrefix().toLowerCase()) <= -1) continue;
                String newFileNamePath = filenamepath.substring(prefix.getOldPrefix().length());
                newFileNamePath = prefix.getNewPrefix() + newFileNamePath;
                File newFile = new File(newFileNamePath);
                if (!newFile.exists()) continue;
                return newFileNamePath;
            }
            this.fileChooser.setDialogTitle("Choose current location of: " + filenamepath);
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
            String ext = "";
            int k = filenamepath.lastIndexOf(46);
            if (k > 0 && k < filenamepath.length() - 1) {
                ext = filenamepath.substring(k + 1);
                FileFilter fileFilter = GUIUtil.createFileFilter(ext.toUpperCase() + " Files", new String[]{ext.toLowerCase()});
                this.fileChooser.addChoosableFileFilter(fileFilter);
                this.fileChooser.setFileFilter(fileFilter);
            }
            if (0 == this.fileChooser.showOpenDialog(this.context.getWorkbenchFrame())) {
                String newParent = this.fileChooser.getSelectedFile().getParent() + File.separator;
                String oldParent = new File(filenamepath).getParent() + File.separator;
                int i = newParent.length();
                int j = oldParent.length();
                while (newParent.substring(i).equalsIgnoreCase(oldParent.substring(j))) {
                    --i;
                    --j;
                }
                while (newParent.charAt(i) != File.separatorChar) {
                    ++i;
                }
                while (oldParent.charAt(j) != File.separatorChar) {
                    ++j;
                }
                String newPrefix = newParent.substring(0, ++i);
                String oldPrefix = oldParent.substring(0, ++j);
                PathPrefixes pathPrefix = new PathPrefixes(oldPrefix, newPrefix);
                this.prefixList.add(pathPrefix);
                return this.fileChooser.getSelectedFile().getPath();
            }
            return "";
        }
    }
}

