/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.Iterator;
import org.openjump.core.ui.plugin.AbstractWizardPlugin;
import org.openjump.core.ui.plugin.file.OpenFilePlugIn;
import org.openjump.core.ui.plugin.file.OpenProjectPlugIn;

public class FirstTaskFramePlugIn
extends AbstractPlugIn {
    private ComponentListener componentListener;

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        super.initialize(context);
        final WorkbenchContext workbenchContext = context.getWorkbenchContext();
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                context.getWorkbenchContext().getWorkbench();
                Iterator<String> files = JUMPWorkbench.getCommandLine().getArguments();
                while (files.hasNext()) {
                    String filename = files.next();
                    File f = new File(filename);
                    try {
                        AbstractWizardPlugin open;
                        if (SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER.accept(f)) {
                            open = new OpenProjectPlugIn(workbenchContext, f);
                            AbstractPlugIn.toActionListener(open, workbenchContext, new TaskMonitorManager()).actionPerformed(new ActionEvent(this, 0, ""));
                            continue;
                        }
                        open = new OpenFilePlugIn(workbenchContext, f);
                        AbstractPlugIn.toActionListener(open, workbenchContext, new TaskMonitorManager()).actionPerformed(new ActionEvent(this, 0, ""));
                    }
                    catch (Exception e2) {
                        String mesg = I18N.getInstance().get(this.getClass().getName() + ".could-not-load-file-{0}", f);
                        Logger.error(mesg);
                    }
                }
                if (!(context.getWorkbenchFrame().getActiveTaskFrame() instanceof TaskFrame)) {
                    context.getWorkbenchFrame().addTaskFrame();
                }
                context.getWorkbenchFrame().removeComponentListener(FirstTaskFramePlugIn.this.componentListener);
            }
        };
        context.getWorkbenchFrame().addComponentListener(this.componentListener);
    }
}

