/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDSLayer;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.CheckBoxed;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditOptionsPanel;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanel;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EditablePlugIn
extends AbstractPlugIn
implements CheckBoxed {
    private EditingPlugIn editingPlugIn;
    private static final String CONFIRMATION_TITLE = EditablePlugIn.class.getName() + ".make-read-only-layer-editable";
    private static final String CONFIRMATION_1 = EditablePlugIn.class.getName() + ".detach-layer-from-source-1";
    private static final String CONFIRMATION_2 = EditablePlugIn.class.getName() + ".detach-layer-from-source-2";
    public static final ImageIcon ICON = IconLoader.icon("edit.gif");

    public EditablePlugIn(EditingPlugIn editingPlugIn) {
        this.editingPlugIn = editingPlugIn;
    }

    public EditablePlugIn() {
        this(EditingPlugIn.getInstance());
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        boolean single = PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(EditOptionsPanel.SINGLE_EDITABLE_LAYER_KEY, true);
        Layerable[] layers = EditablePlugIn.getSelectedLayerables(context.getWorkbenchContext());
        boolean makeEditable = !layers[0].isEditable();
        for (Layerable layerable : layers) {
            if (this.isWritable(layerable)) {
                if (single) {
                    this.setAllLayersToUneditable(context);
                }
                layerable.setEditable(makeEditable);
                continue;
            }
            String message = "<html><br>" + I18N.getInstance().get(CONFIRMATION_1, "<i>'" + layerable.getName() + "'</i>");
            message = message + "<br><br>" + I18N.getInstance().get(CONFIRMATION_2) + "<br></html>";
            JLabel label = new JLabel(message);
            JPanel panel = new JPanel();
            panel.add(label);
            OKCancelDialog okCancelPanel = new OKCancelDialog(context.getWorkbenchFrame(), I18N.getInstance().get(CONFIRMATION_TITLE), true, (Component)panel, new OKCancelDialog.Validator(){

                @Override
                public String validateInput(Component component) {
                    return null;
                }
            });
            okCancelPanel.setVisible(true);
            if (!okCancelPanel.wasOKPressed()) continue;
            if (single) {
                this.setAllLayersToUneditable(context);
            }
            layerable.setEditable(makeEditable);
            if (!(layerable instanceof Layer)) continue;
            if (layerable instanceof SpatialDSLayer) {
                ConnectionManager.instance(this.getWorkbenchContext()).closeConnection((SpatialDSLayer)layerable);
            }
            ((Layer)layerable).setDataSourceQuery(null);
        }
        if (makeEditable && !this.editingPlugIn.getToolbox(context.getWorkbenchContext()).isVisible()) {
            this.editingPlugIn.execute(context);
        }
        return true;
    }

    private boolean isWritable(Layerable layerable) {
        if (layerable instanceof Layer) {
            Layer layer = (Layer)layerable;
            if (layer.getDataSourceQuery() == null || layer.getDataSourceQuery().getDataSource() == null) {
                return true;
            }
            DataSource source = layer.getDataSourceQuery().getDataSource();
            return source.isWritable() && source.getProperties().get("CompressedFile") == null;
        }
        return false;
    }

    public EnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck();
        mec.add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
        mec.add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
        mec.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ((JCheckBoxMenuItem)component).setSelected(EditablePlugIn.getSelectedLayerables(workbenchContext)[0].isEditable());
                return null;
            }
        });
        mec.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String errMsg = null;
                Layerable[] layers = EditablePlugIn.getSelectedLayerables(workbenchContext);
                for (int i = 0; i < layers.length; ++i) {
                    if (!layers[i].isReadonly()) continue;
                    errMsg = I18N.getInstance().get("ui.plugin.EditablePlugIn.The-selected-layer-cannot-be-made-editable");
                    break;
                }
                return errMsg;
            }
        });
        return mec;
    }

    private void setAllLayersToUneditable(PlugInContext context) {
        for (Layerable object : context.getLayerNamePanel().getLayerManager().getLayerables(Layerable.class)) {
            object.setEditable(false);
        }
    }

    private static Layerable[] getSelectedLayerables(WorkbenchContext wbc) {
        Layerable[] layers = new Layerable[]{};
        JInternalFrame frame = wbc.getWorkbench().getFrame().getActiveInternalFrame();
        if (frame instanceof LayerNamePanelProxy) {
            LayerNamePanel layerNamePanel = ((LayerNamePanelProxy)((Object)frame)).getLayerNamePanel();
            if (frame instanceof InfoFrame) {
                Layer[] lyrs = ((InfoFrame)frame).getModel().getLayers().toArray(new Layer[0]);
                layers = new Layerable[lyrs.length];
                System.arraycopy(lyrs, 0, layers, 0, lyrs.length);
            } else {
                layers = layerNamePanel instanceof LayerableNamePanel ? ((LayerableNamePanel)layerNamePanel).getSelectedLayerables().toArray(new Layerable[0]) : layerNamePanel.getSelectedLayers();
            }
        } else if (frame instanceof ViewAttributesPlugIn.ViewAttributesFrame) {
            layers = new Layerable[]{((ViewAttributesPlugIn.ViewAttributesFrame)frame).getOneLayerAttributeTab().getLayer()};
        }
        return layers;
    }
}

