/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.images.IconLoader;

public class CombineSelectedFeaturesPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("features_combine.png");

    public CombineSelectedFeaturesPlugIn() {
        this.setShortcutKeys(71);
        this.setShortcutModifiers(2);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager smgr = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        final ArrayList<Feature> originalFeatures = new ArrayList<Feature>(smgr.getFeaturesWithSelectedItems());
        final Feature combinedFeature = this.combine(originalFeatures, context);
        final Layer layer = smgr.getLayersWithSelectedItems().iterator().next();
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                layer.getFeatureCollectionWrapper().removeAll(originalFeatures);
                layer.getFeatureCollectionWrapper().add(combinedFeature);
            }

            @Override
            public void unexecute() {
                layer.getFeatureCollectionWrapper().remove(combinedFeature);
                layer.getFeatureCollectionWrapper().addAll(originalFeatures);
            }
        }, context);
        context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(layer, combinedFeature);
        return true;
    }

    private Feature combine(Collection originalFeatures, PlugInContext context) {
        GeometryFactory factory = new GeometryFactory();
        Feature feature = ((Feature)originalFeatures.iterator().next()).clone();
        Class narrowestCollectionClass = this.narrowestCollectionClass(originalFeatures);
        if (narrowestCollectionClass == MultiPoint.class) {
            feature.setGeometry((Geometry)factory.createMultiPoint(FeatureUtil.toGeometries(originalFeatures).toArray(new Point[originalFeatures.size()])));
        } else if (narrowestCollectionClass == MultiLineString.class) {
            feature.setGeometry((Geometry)factory.createMultiLineString(FeatureUtil.toGeometries(originalFeatures).toArray(new LineString[originalFeatures.size()])));
        } else if (narrowestCollectionClass == MultiPolygon.class) {
            MultiPolygon mp = factory.createMultiPolygon(FeatureUtil.toGeometries(originalFeatures).toArray(new Polygon[originalFeatures.size()]));
            if (mp.isValid()) {
                feature.setGeometry((Geometry)mp);
            } else {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.CombineSelectedFeaturesPlugIn.invalid-multipolygon"));
                feature.setGeometry((Geometry)factory.createGeometryCollection(FeatureUtil.toGeometries(originalFeatures).toArray(new Geometry[originalFeatures.size()])));
            }
        } else {
            feature.setGeometry((Geometry)factory.createGeometryCollection(FeatureUtil.toGeometries(originalFeatures).toArray(new Geometry[originalFeatures.size()])));
        }
        return feature;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustHaveSelectedItemsCheck(1)).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(2)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    private Class narrowestCollectionClass(Collection features) {
        boolean hasPoints = false;
        boolean hasLineStrings = false;
        boolean hasPolygons = false;
        for (Feature feature : features) {
            if (feature.getGeometry() instanceof Point) {
                hasPoints = true;
                continue;
            }
            if (feature.getGeometry() instanceof LineString) {
                hasLineStrings = true;
                continue;
            }
            if (feature.getGeometry() instanceof Polygon) {
                hasPolygons = true;
                continue;
            }
            return GeometryCollection.class;
        }
        if (hasPoints && !hasLineStrings && !hasPolygons) {
            return MultiPoint.class;
        }
        if (!hasPoints && hasLineStrings && !hasPolygons) {
            return MultiLineString.class;
        }
        if (!hasPoints && !hasLineStrings && hasPolygons) {
            return MultiPolygon.class;
        }
        return GeometryCollection.class;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

