/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MultiInputDialogConsole
extends JPanel {
    private final JTextArea textArea = new JTextArea(2, 32);
    private final Color BACKGROUND;
    private Color flashColor = Color.YELLOW;

    public MultiInputDialogConsole() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setForeground(Color.BLACK);
        this.BACKGROUND = this.textArea.getBackground();
        this.add((Component)new JScrollPane(this.textArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getMessage() {
        return this.textArea.getText();
    }

    public void addMessage(String message) {
        this.textArea.append("\n" + message);
    }

    public void setMessage(String message) {
        this.textArea.setText(message);
    }

    public void setFlashColor(Color flashColor) {
        this.flashColor = flashColor;
    }

    public void flashMessage(String message) {
        this.textArea.append("\n" + message);
        this.textArea.setDoubleBuffered(true);
        Runnable flash = new Runnable(){

            @Override
            public void run() {
                Color gradient = MultiInputDialogConsole.this.flashColor;
                try {
                    MultiInputDialogConsole.this.flash(gradient, 500);
                    MultiInputDialogConsole.this.flash(MultiInputDialogConsole.this.BACKGROUND, 300);
                    MultiInputDialogConsole.this.flash(gradient, 500);
                    MultiInputDialogConsole.this.flash(MultiInputDialogConsole.this.BACKGROUND, 300);
                    MultiInputDialogConsole.this.flash(gradient, 600);
                    while (gradient.getRGB() != MultiInputDialogConsole.this.BACKGROUND.getRGB()) {
                        gradient = MultiInputDialogConsole.this.soften(gradient, MultiInputDialogConsole.this.BACKGROUND, 0.05f);
                        MultiInputDialogConsole.this.flash(gradient, 50);
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        };
        new Thread(flash).start();
    }

    private void flash(Color background, int sleepMillis) throws InterruptedException {
        this.textArea.setBackground(background);
        Thread.sleep(sleepMillis);
    }

    private Color soften(Color src, Color tgt, float c) {
        int red = tgt.getRed() + (int)((1.0f - c) * (float)(src.getRed() - tgt.getRed()));
        int green = tgt.getGreen() + (int)((1.0f - c) * (float)(src.getGreen() - tgt.getGreen()));
        int blue = tgt.getBlue() + (int)((1.0f - c) * (float)(src.getBlue() - tgt.getBlue()));
        return new Color(red, green, blue);
    }
}

