/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.AbstractMultiInputDialog;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialogConsole;
import com.vividsolutions.jump.workbench.ui.MultiInputDialogInfoPanel;
import com.vividsolutions.jump.workbench.ui.OKCancelApplyPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;

public class MultiInputDialog
extends AbstractMultiInputDialog {
    private final JPanel dialogPanel = new JPanel(new BorderLayout());
    private final MultiInputDialogInfoPanel infoPanel = new MultiInputDialogInfoPanel();
    protected Container mainComponent;
    protected JPanel currentPanel;
    private final MultiInputDialogConsole console = new MultiInputDialogConsole();
    protected final OKCancelApplyPanel okCancelApplyPanel = new OKCancelApplyPanel();
    private int inset = 0;
    private int rowCount = 0;

    protected void setMainComponent() {
        this.mainComponent = new JPanel(new GridBagLayout());
        this.currentPanel = (JPanel)this.mainComponent;
        CompoundBorder mainComponentBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5 + this.inset, 5 + this.inset, 5 + this.inset, 5 + this.inset));
        this.currentPanel.setBorder(mainComponentBorder);
    }

    public void setMainComponent(Container container) {
        this.mainComponent = container;
    }

    public JPanel getCurrentPanel() {
        return this.currentPanel;
    }

    public void setCurrentPanel(JPanel panel) {
        this.currentPanel = panel;
    }

    public MultiInputDialogConsole getConsole() {
        return this.console;
    }

    public MultiInputDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.okCancelApplyPanel.addActionListener(e -> this.okCancelApplyPanel_actionPerformed(e));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MultiInputDialog() {
        this((Frame)null, "", false);
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        super.setVisible(visible);
    }

    public MultiInputDialogInfoPanel getDescriptionPanel() {
        return this.infoPanel;
    }

    public void setSideBarImage(Icon icon) {
        this.infoPanel.setIcon(icon);
        this.pack();
    }

    public void setSideBarDescription(String description) {
        this.infoPanel.setDescription(description);
        this.pack();
    }

    public void showConsole() {
        this.console.setVisible(true);
        this.pack();
    }

    public void setApplyVisible(boolean applyVisible) {
        this.okCancelApplyPanel.setApplyVisible(applyVisible);
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.okCancelApplyPanel.setCancelVisible(cancelVisible);
    }

    public void setOKVisible(boolean okVisible) {
        this.okCancelApplyPanel.setOKVisible(okVisible);
    }

    public void setApplyEnabled(boolean applyEnabled) {
        this.okCancelApplyPanel.setApplyEnabled(applyEnabled);
    }

    public void setCancelEnabled(boolean cancelEnabled) {
        this.okCancelApplyPanel.setCancelEnabled(cancelEnabled);
    }

    public void setOKEnabled(boolean okEnabled) {
        this.okCancelApplyPanel.setOKEnabled(okEnabled);
    }

    public boolean wasApplyPressed() {
        return this.okCancelApplyPanel.wasApplyPressed();
    }

    public boolean wasOKPressed() {
        return this.okCancelApplyPanel.wasOKPressed();
    }

    void jbInit() throws Exception {
        this.getRootPane().setDefaultButton(this.okCancelApplyPanel.getButton(I18N.getInstance().get("ui.OKCancelPanel.ok")));
        this.setMainComponent();
        this.dialogPanel.add((Component)this.infoPanel, "West");
        this.dialogPanel.add((Component)this.mainComponent, "Center");
        this.dialogPanel.add((Component)this.console, "South");
        this.console.setVisible(false);
        this.setResizable(true);
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.getContentPane().add((Component)this.okCancelApplyPanel, "South");
    }

    public void addOKCancelApplyPanelActionListener(ActionListener actionListener) {
        this.okCancelApplyPanel.addActionListener(actionListener);
    }

    @Override
    public void addRow(String fieldName, JComponent label, JComponent component, EnableCheck[] enableChecks, String toolTipText, int labelPos, int fillMode) {
        this.addComponent(fieldName, label, component);
        double weighty = 0.1;
        if (component instanceof JTextArea) {
            weighty = 1.0;
        }
        if (component instanceof JTextPane) {
            weighty = 1.0;
        }
        if (component instanceof JScrollPane) {
            weighty = 1.0;
        }
        if (label != null && toolTipText != null) {
            label.setToolTipText(toolTipText);
            component.setToolTipText(toolTipText);
        }
        if (enableChecks != null) {
            this.addEnableChecks(fieldName, Arrays.asList(enableChecks));
        }
        if (labelPos == 0) {
            this.currentPanel.add((Component)component, new GridBagConstraints(1, this.rowCount, 3, 1, 1.0, weighty, 17, fillMode, new Insets(5 + this.inset, 2 + this.inset, 2 + this.inset, 2 + this.inset), 0, 0));
        } else if (labelPos == 1) {
            if (label != null) {
                this.currentPanel.add((Component)label, new GridBagConstraints(1, this.rowCount, 1, 1, 0.0, weighty, 17, 0, new Insets(2 + this.inset, 2 + this.inset, 2 + this.inset, 2 + this.inset), 0, 0));
            }
            this.currentPanel.add((Component)component, new GridBagConstraints(2, this.rowCount, 2, 1, 1.0, weighty, 17, fillMode, new Insets(2 + this.inset, 2 + this.inset, 2 + this.inset, 2 + this.inset), 0, 0));
        } else if (labelPos == 2) {
            this.currentPanel.add((Component)component, new GridBagConstraints(1, this.rowCount, 2, 1, 1.0, weighty, 17, fillMode, new Insets(2 + this.inset, 2 + this.inset, 2 + this.inset, 2 + this.inset), 0, 0));
            if (label != null) {
                this.currentPanel.add((Component)label, new GridBagConstraints(3, this.rowCount, 1, 1, 0.0, weighty, 17, 0, new Insets(2 + this.inset, 2 + this.inset, 2 + this.inset, 2 + this.inset), 0, 0));
            }
        }
        ++this.rowCount;
    }

    public void addRow(String fieldName, JComponent component, EnableCheck[] enableChecks, String toolTipText) {
        this.addRow(fieldName, null, component, enableChecks, toolTipText, 0, 2);
    }

    public void addRow(String fieldName, JLabel label, JTextField component, EnableCheck[] enableChecks, String toolTipText) {
        this.addRow(fieldName, label, component, enableChecks, toolTipText, 1, 0);
    }

    public void addRow(String fieldName, JLabel label, JComponent component, EnableCheck[] enableChecks, String toolTipText) {
        this.addRow(fieldName, label, component, enableChecks, toolTipText, 1, 0);
    }

    @Override
    public void addRow(JComponent component) {
        if (component instanceof JLabel) {
            this.addRow(((JLabel)component).getText(), new JLabel(""), component, null, "", 0, 2);
        } else {
            this.addRow("DUMMY", new JLabel(""), component, null, "", 0, 2);
        }
    }

    @Override
    public void addRow() {
        this.currentPanel.add((Component)new JPanel(), new GridBagConstraints(1, this.rowCount, 2, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void setInset(int inset) {
        this.inset = inset;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void okCancelApplyPanel_actionPerformed(ActionEvent e) {
        if (this.okCancelApplyPanel.wasApplyPressed()) {
            return;
        }
        if (!this.okCancelApplyPanel.wasOKPressed() || this.isInputValid()) {
            this.setVisible(false);
            return;
        }
        this.reportValidationError(this.firstValidationErrorMessage());
    }

    public void indentLabel(String fieldName) {
        this.getLabel(fieldName).setBorder(BorderFactory.createMatteBorder(0, (int)new JCheckBox().getPreferredSize().getWidth(), 0, 0, this.getLabel(fieldName).getBackground()));
    }

    public void startNewColumn() {
        JOptionPane.showMessageDialog(this, "MultiInputDialog.startNewColumn() is deprecated,\nif you want to layout widgets on two panels,\n please, use the new DualPaneInputDialog class instead", "OpenJUMP", 0);
    }

    public static void main(String[] args) {
        LayerManager lm = new LayerManager();
        FeatureSchema fs1 = new FeatureSchema();
        fs1.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset ds1 = new FeatureDataset(fs1);
        lm.addLayer("", "LayerWithJustGeometry", ds1);
        FeatureSchema fs2 = new FeatureSchema();
        fs2.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs2.addAttribute("Name", AttributeType.STRING);
        FeatureDataset ds2 = new FeatureDataset(fs2);
        lm.addLayer("", "LayerWithStringAttribute", ds2);
        FeatureSchema fs3 = new FeatureSchema();
        fs3.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs3.addAttribute("Name", AttributeType.STRING);
        fs3.addAttribute("Age", AttributeType.INTEGER);
        FeatureDataset ds3 = new FeatureDataset(fs3);
        lm.addLayer("", "LayerWithNumericAttribute", ds3);
        final MultiInputDialog d = new MultiInputDialog(null, "Title!", true);
        d.setInset(2);
        d.addSubTitle("Subtitle 1");
        d.addLabel("This is just a label");
        d.addTextField("Name", "", 24, null, "");
        d.addPositiveIntegerField("Age", 0, 6, "");
        d.addNonNegativeDoubleField("Salary", 0.0, 12, "");
        d.addComboBox("Occupation", "Cadre", Arrays.asList("Manager", "Developper", "Technician", "Secretary"), "");
        d.indentLabel("Occupation");
        d.addSubTitle("Layer and attribute selection");
        AttributeTypeFilter STRING_FILTER = new AttributeTypeFilter(2);
        AttributeTypeFilter NUMERIC_FILTER = AttributeTypeFilter.NUMERIC_FILTER;
        AttributeTypeFilter NOGEOM_FILTER = AttributeTypeFilter.NO_GEOMETRY_FILTER;
        AttributeTypeFilter ALL_FILTER = AttributeTypeFilter.ALL_FILTER;
        JComboBox<AttributeTypeFilter> typeChooser = d.addComboBox("Choose Attribute Type", ALL_FILTER, Arrays.asList(STRING_FILTER, NUMERIC_FILTER, ALL_FILTER, NOGEOM_FILTER), "");
        JComboBox<Layer> layerChooser = d.addLayerComboBox("LayerField", null, "ToolTip", lm);
        JComboBox<String> attributeChooser = d.addAttributeComboBox("Attribute field", "LayerField", NUMERIC_FILTER, "");
        typeChooser.addActionListener(e -> {
            AttributeTypeFilter atf = (AttributeTypeFilter)typeChooser.getSelectedItem();
            layerChooser.setModel(new DefaultComboBoxModel<Layer>(atf.filter(lm).toArray(new Layer[0])));
        });
        d.addSeparator();
        final JCheckBox jcb = d.addCheckBox("Display icon", false, "");
        JButton button = d.addButton("Switch image panel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (d.infoPanel.getDescription().equals("")) {
                    d.infoPanel.setDescription("Description of the dialog box.\nThis description must be helpful for the user. I must give meaningful information about which parameters are mandatory, optional, what they represent and which value they can take.");
                    d.getConsole().flashMessage("Add description");
                } else {
                    d.infoPanel.setDescription("");
                    d.getConsole().flashMessage("Remove description");
                }
                d.pack();
            }
        });
        jcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jcb.isSelected()) {
                    d.infoPanel.setIcon(new ImageIcon(IconLoader.class.getResource("Butt.gif")));
                    d.getConsole().flashMessage("Add image");
                } else {
                    d.infoPanel.setIcon(null);
                    d.getConsole().flashMessage("Remove image");
                }
                d.pack();
            }
        });
        d.addButton("Second button", "OK", "");
        GUIUtil.centreOnScreen(d);
        d.setVisible(true);
        System.exit(0);
    }
}

