/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.ToolTipWriter;
import com.vividsolutions.jump.workbench.ui.TrackedPopupMenu;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DummyTool;
import com.vividsolutions.jump.workbench.ui.cursortool.LeftClickFilter;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.util.Assert;

public class LayerViewPanel
extends JPanel
implements LayerListener,
LayerManagerProxy,
SelectionManagerProxy {
    private static final JPopupMenu popupMenu = new TrackedPopupMenu();
    private final ToolTipWriter toolTipWriter = new ToolTipWriter(this);
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final CursorTool dummyCursorTool = new DummyTool();
    private final Viewport viewport = new Viewport(this);
    private final Set<LayerViewPanelListener> listeners = new HashSet<LayerViewPanelListener>();
    private final RenderingManager renderingManager = new RenderingManager(this);
    private final Blackboard blackboard = new Blackboard();
    private LayerManager layerManager;
    private CursorTool currentCursorTool = this.dummyCursorTool;
    private boolean viewportInitialized = false;
    private Point lastClickedPoint;
    private Point lastMouseLoc;
    private LayerViewPanelContext context;
    private FenceLayerFinder fenceLayerFinder;
    private SelectionManager selectionManager;
    private boolean deferLayerEvents = false;

    public LayerViewPanel(LayerManager layerManager, LayerViewPanelContext context) {
        this.setMinimumSize(new Dimension(100, 100));
        this.setToolTipText("");
        GUIUtil.fixClicks(this);
        try {
            this.context = context;
            this.layerManager = layerManager;
            this.selectionManager = new SelectionManager(this, this);
            this.fenceLayerFinder = new FenceLayerFinder(this);
            layerManager.addLayerListener(this);
            this.setBackground(Color.white);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        LayerViewPanel.this.this_mouseReleased(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    LayerViewPanel.this.this_mouseReleased(e);
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    LayerViewPanel.this.this_componentResized(e);
                }
            });
            this.setLayout(this.borderLayout1);
            final LayerViewPanel lvp = this;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    lvp.requestFocusInWindow();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseLocationChanged(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.mouseLocationChanged(e);
                }

                private void mouseLocationChanged(MouseEvent e) {
                    try {
                        Point2D p = LayerViewPanel.this.getViewport().toModelPoint(LayerViewPanel.this.lastMouseLoc = e.getPoint());
                        LayerViewPanel.this.fireCursorPositionChanged(LayerViewPanel.this.format(p.getX()), LayerViewPanel.this.format(p.getY()));
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.context.handleThrowable(t);
                    }
                }
            });
            this.addMouseWheelListener(new MouseWheelZoomListener());
        }
        catch (Throwable t) {
            context.handleThrowable(t);
        }
    }

    public ToolTipWriter getToolTipWriter() {
        return this.toolTipWriter;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.toolTipWriter.write(this.getToolTipText(), event.getPoint());
    }

    public Map<Layer, Set<Feature>> visibleLayerToFeaturesInFenceMap() {
        Map<Layer, Set<Feature>> visibleLayerToFeaturesInFenceMap = this.visibleLayerToFeaturesInFenceMap(this.getFence());
        visibleLayerToFeaturesInFenceMap.remove(new FenceLayerFinder(this).getLayer());
        return visibleLayerToFeaturesInFenceMap;
    }

    public Map<Layer, Set<Feature>> visibleLayerToFeaturesInFenceMap(Geometry fence) {
        HashMap<Layer, Set<Feature>> map = new HashMap<Layer, Set<Feature>>();
        for (Layer layer : this.getLayerManager().getLayerables(Layer.class)) {
            if (!layer.isVisible()) continue;
            HashSet<Feature> features = new HashSet<Feature>();
            for (Feature candidate : layer.getFeatureCollectionWrapper().query(fence.getEnvelopeInternal())) {
                if (!candidate.getGeometry().intersects(fence)) continue;
                features.add(candidate);
            }
            if (features.isEmpty()) continue;
            map.put(layer, features);
        }
        return map;
    }

    public static JPopupMenu popupMenu() {
        return popupMenu;
    }

    public CursorTool getCurrentCursorTool() {
        return this.currentCursorTool;
    }

    public void reSetCurrentCursorTool() {
        this.setCurrentCursorTool(this.getCurrentCursorTool(), true);
    }

    public void setCurrentCursorTool(CursorTool newct) {
        this.setCurrentCursorTool(newct, false);
    }

    private void setCurrentCursorTool(CursorTool newct, boolean force) {
        if (!force && newct.equals(this.currentCursorTool)) {
            this.setCursor(newct.getCursor());
            return;
        }
        if (!newct.equals(this.currentCursorTool)) {
            this.currentCursorTool.cancelGesture();
        }
        this.removeCurrentCursorTool();
        this.currentCursorTool = newct;
        newct.activate(this);
        this.setCursor(newct.getCursor());
        this.addMouseListener(newct);
        this.addMouseMotionListener(newct);
    }

    public void removeCurrentCursorTool() {
        CursorTool oldct = this.currentCursorTool;
        this.setCursor(null);
        this.removeMouseListener(oldct);
        this.removeMouseMotionListener(oldct);
        oldct.deactivate();
        this.currentCursorTool = this.dummyCursorTool;
    }

    public WorkbenchFrame getWorkBenchFrame() {
        Window window = SwingUtilities.windowForComponent(this);
        Assert.isTrue((window != null ? 1 : 0) != 0, (String)"LayerViewPanel should have a parent WorkbenchFrame");
        return window instanceof WorkbenchFrame ? (WorkbenchFrame)window : null;
    }

    public void setViewportInitialized(boolean viewportInitialized) {
        this.viewportInitialized = viewportInitialized;
    }

    public Point getLastClickedPoint() {
        return this.lastClickedPoint;
    }

    public Point getLastMouseLocation() {
        return this.lastMouseLoc;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public Java2DConverter getJava2DConverter() {
        return this.viewport.getJava2DConverter();
    }

    public Geometry getFence() {
        return this.fenceLayerFinder.getFence();
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void featuresChanged(FeatureEvent e) {
    }

    @Override
    public void categoryChanged(CategoryEvent e) {
    }

    @Override
    public void layerChanged(LayerEvent e) {
        try {
            if (e.getType() == LayerEventType.METADATA_CHANGED) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        LayerViewPanel.this.initializeViewportIfNecessary();
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.context.handleThrowable(t);
                    }
                }
            });
            if (!this.deferLayerEvents) {
                if (e.getType() == LayerEventType.ADDED || e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.APPEARANCE_CHANGED) {
                    this.renderingManager.render(e.getLayerable());
                } else if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                    this.renderingManager.render(e.getLayerable(), false);
                } else {
                    Assert.shouldNeverReachHere();
                }
            }
            if (e.getType() == LayerEventType.REMOVED) {
                this.getRenderingManager().removeLayerRenderer(e.getLayerable());
            }
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public Image createBlankPanelImage() {
        return new BufferedImage(this.getWidth(), this.getHeight(), 2);
    }

    @Override
    public void repaint() {
        if (this.renderingManager == null) {
            this.superRepaint();
            return;
        }
        this.renderingManager.renderAll();
    }

    public void superRepaint() {
        super.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
            this.erase((Graphics2D)g);
            this.renderingManager.copyTo((Graphics2D)g);
            this.firePainted(g);
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public void erase(Graphics2D g) {
        this.fill(g, this.getBackground());
    }

    public void fill(Graphics2D g, Color color) {
        g.setColor(color);
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g.fill(r);
    }

    void this_componentResized(ComponentEvent e) {
        try {
            this.viewport.update();
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public LayerViewPanelContext getContext() {
        return this.context;
    }

    void this_mouseReleased(MouseEvent e) {
        this.lastClickedPoint = e.getPoint();
        if (this.currentCursorTool.isRightMouseButtonUsed()) {
            return;
        }
        if (e.isPopupTrigger()) {
            if (popupMenu.getSubElements().length == 0) {
                return;
            }
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initializeViewportIfNecessary() throws NoninvertibleTransformException {
        if (!this.viewportInitialized && this.layerManager.size() > 0 && this.layerManager.getEnvelopeOfAllLayers(true).getWidth() > 0.0) {
            this.setViewportInitialized(true);
            this.viewport.zoomToFullExtent();
            return;
        }
    }

    public void addListener(LayerViewPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LayerViewPanelListener listener) {
        this.listeners.remove(listener);
    }

    public String format(double d) {
        double pixelWidthInModelUnits = this.viewport.getEnvelopeInModelCoordinates().getWidth() / (double)this.getWidth();
        return this.format(d, pixelWidthInModelUnits);
    }

    protected String format(double d, double pixelWidthInModelUnits) {
        int precisionInDecimalPlaces = (int)Math.max(0L, Math.round(-Math.log(pixelWidthInModelUnits) / Math.log(10.0)));
        ++precisionInDecimalPlaces;
        String formatString = "#.";
        for (int i = 0; i < precisionInDecimalPlaces; ++i) {
            formatString = formatString + "#";
        }
        return new DecimalFormat(formatString).format(d);
    }

    private void firePainted(Graphics graphics) {
        for (LayerViewPanelListener listener : this.listeners) {
            listener.painted(graphics);
        }
    }

    public void fireSelectionChanged() {
        for (LayerViewPanelListener listener : this.listeners) {
            listener.selectionChanged();
        }
    }

    private void fireCursorPositionChanged(String x, String y) {
        for (LayerViewPanelListener listener : this.listeners) {
            listener.cursorPositionChanged(x, y);
        }
    }

    public RenderingManager getRenderingManager() {
        return this.renderingManager;
    }

    public Collection<Feature> featuresWithVertex(Point2D viewPoint, double viewTolerance, Collection<Feature> features) throws NoninvertibleTransformException {
        Point2D modelPoint = this.viewport.toModelPoint(viewPoint);
        double modelTolerance = viewTolerance / this.viewport.getScale();
        Envelope searchEnvelope = new Envelope(modelPoint.getX() - modelTolerance, modelPoint.getX() + modelTolerance, modelPoint.getY() - modelTolerance, modelPoint.getY() + modelTolerance);
        ArrayList<Feature> featuresWithVertex = new ArrayList<Feature>();
        for (Feature feature : features) {
            if (!this.geometryHasVertex(feature.getGeometry(), searchEnvelope)) continue;
            featuresWithVertex.add(feature);
        }
        return featuresWithVertex;
    }

    private boolean geometryHasVertex(Geometry geometry, Envelope searchEnvelope) {
        Coordinate[] coordinates;
        for (Coordinate coordinate : coordinates = geometry.getCoordinates()) {
            if (!searchEnvelope.contains(coordinate)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.removeCurrentCursorTool();
        this.renderingManager.dispose();
        this.selectionManager.dispose();
        this.layerManager.removeLayerListener(this);
    }

    public void flash(final Shape shape, Color color, Stroke stroke, final int millisecondDelay) {
        final Graphics2D graphics = (Graphics2D)this.getGraphics();
        graphics.setColor(color);
        graphics.setXORMode(Color.white);
        graphics.setStroke(stroke);
        try {
            GUIUtil.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        graphics.draw(shape);
                        Thread.sleep(millisecondDelay);
                        graphics.draw(shape);
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.getContext().handleThrowable(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.getContext().handleThrowable(t);
        }
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public void flash(GeometryCollection geometryCollection) throws NoninvertibleTransformException {
        Shape s = this.getViewport().getJava2DConverter().toShape((Geometry)geometryCollection);
        if (s != null) {
            this.flash(s, Color.red, new BasicStroke(5.0f, 1, 1), 100);
        }
    }

    public void setDeferLayerEvents(boolean defer) {
        this.deferLayerEvents = defer;
    }

    class MouseWheelZoomListener
    implements MouseWheelListener {
        MouseWheelZoomListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (LayerViewPanel.this.currentCursorTool instanceof QuasimodeTool) {
                CursorTool wrappee;
                CursorTool tool = ((QuasimodeTool)LayerViewPanel.this.currentCursorTool).getDelegate();
                if (tool instanceof ZoomTool) {
                    ((ZoomTool)tool).mouseWheelMoved(e);
                } else if (tool instanceof LeftClickFilter && (wrappee = ((LeftClickFilter)tool).getWrappee()) instanceof PanTool) {
                    ((PanTool)wrappee).mouseWheelMoved(e);
                }
            }
        }
    }
}

