/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerView;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.EditOptionsPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerColorPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerPanel;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.RasterImageLayer;

public class LayerNameRenderer
extends JPanel
implements ListCellRenderer<Object>,
TreeCellRenderer {
    public static final String USE_CLOCK_ANIMATION_KEY = LayerNameRenderer.class.getName() + " - USE CLOCK ANIMATION";
    private static final Color UNSELECTED_EDITABLE_FONT_COLOR = Color.red;
    private static final Color SELECTED_EDITABLE_FONT_COLOR = Color.yellow;
    private static final Color LAYER_VIEW_COLOR = Color.gray;
    protected JCheckBox checkBox = new JCheckBox();
    private final LayerColorPanel colorPanel = new LayerColorPanel(13);
    GridBagLayout gridBagLayout = new GridBagLayout();
    protected JLabel label = new JLabel();
    private boolean indicatingEditability = false;
    private boolean indicatingProgress = false;
    private final int progressIconSize = 13;
    private Icon[] progressIcons = null;
    private final Icon clearProgressIcon = GUIUtil.resize(IconLoader.icon("Clear.gif"), 13);
    public static String PROGRESS_ICON_KEY = "PROGRESS_ICON";
    public static String FEATURE_COUNT = I18N.getInstance().get("ui.LayerNameRenderer.feature-count");
    private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private RenderingManager renderingManager;
    private final JLabel progressIconLabel = new JLabel();
    private final Font font = new JLabel().getFont();
    private final Font editableFont = this.font.deriveFont(1);
    private final Font unselectableFont = this.font.deriveFont(2);
    private final Font editableUnselectableFont = this.font.deriveFont(3);
    private final JLabel imageLabel = new JLabel();
    private final ImageIcon wmsIcon = MapLayerPanel.ICON;
    private final ImageIcon multiRasterIcon = IconLoader.icon("maps_13.png");
    private final ImageIcon rasterIcon = IconLoader.icon("map_13.png");
    private final ImageIcon sextante_rasterIcon = IconLoader.icon("mapSv2_13.png");
    private final ImageIcon sextante_rasterIcon2 = IconLoader.icon("mapSv2_13bw.png");
    private ImageIcon table_Icon = IconLoader.icon("Table.gif");
    private static final String LAYER_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Layer-Name");
    private static final String FILE_NAME = I18N.getInstance().get("ui.MenuNames.FILE");
    private static final String MODIFIED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Modified");
    private static final String SRS = I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.coordinate-reference-system");
    private static final String URL = "Url";
    private static final String NODATASOURCELAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.nodatasourcelayer.message");
    private static final String SOURCE_PATH = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Source-Path");
    private static final String SEXTANTE = I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Sextante-Raster-Image");
    private static final String DATASOURCE_CLASS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.DataSource-Class");
    private static final String EXTENT = I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Envelope");
    private static final String MULTIPLESOURCE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-Sources");
    private boolean showProgressIconLabel = true;
    private boolean showImageLabel = true;
    private boolean showColorPanel = true;
    private boolean showCheckBox = true;
    private boolean showLabel = true;
    private static final String[] Q = new String[]{"", "KB", "MB", "GB", "TB", "PB", "EB"};

    public LayerNameRenderer() {
        this.setOpaque(true);
        this.setName("List.layerNameRenderer");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIndicatingEditability(boolean indicatingEditability) {
        this.indicatingEditability = indicatingEditability;
    }

    public void setIndicatingProgress(boolean indicatingProgress, RenderingManager renderingManager) {
        this.indicatingProgress = indicatingProgress;
        this.renderingManager = renderingManager;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public Rectangle getCheckBoxBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.checkBox).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), this.getRowHeight());
    }

    protected int getColumnWidth(int i) {
        this.validate();
        return this.gridBagLayout.getLayoutDimensions()[0][i];
    }

    protected int getRowHeight() {
        this.validate();
        return this.gridBagLayout.getLayoutDimensions()[1][0];
    }

    public void setProgressIconLabelVisible(boolean visible) {
        this.showProgressIconLabel = visible;
    }

    public void setImageLabelVisible(boolean visible) {
        this.showImageLabel = visible;
    }

    public void setColorPanelVisible(boolean visible) {
        this.showColorPanel = visible;
    }

    public void setCheckBoxVisible(boolean visible) {
        this.showCheckBox = visible;
    }

    public void setLabelVisible(boolean visible) {
        this.showLabel = visible;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Object> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
        this.label.setText(value);
        this.imageLabel.setVisible(false);
        this.colorPanel.setVisible(false);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        return this;
    }

    private Component formatLayerEntry(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof Layerable) && !(value instanceof String)) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        if (value instanceof String) {
            return this.getListCellRendererComponent(list, (String)value, index, isSelected, cellHasFocus);
        }
        Layerable layerable = (Layerable)value;
        if (LayerNameRenderer.isDisabledLayer(layerable)) {
            this.label.setText("<html><strike>" + layerable.getName() + "");
        } else if (layerable instanceof LayerView) {
            LayerView view = (LayerView)layerable;
            this.label.setText(view.getFullName());
        } else {
            this.label.setText(layerable.getName());
        }
        this.label.setVisible(this.showLabel);
        boolean layerTooltipsOn = PersistentBlackboardPlugIn.get(JUMPWorkbench.getInstance().getContext()).get(EditOptionsPanel.LAYER_TOOLTIPS_KEY, false);
        if (layerTooltipsOn) {
            this.setToolTipText(this.generateMinimalToolTipText(layerable));
        } else {
            this.setToolTipText(this.generateToolTipText(layerable));
        }
        if (isSelected) {
            Color sbg = list.getSelectionBackground();
            Color sfg = list.getSelectionForeground();
            this.setBackground(sbg);
            this.setForeground(sfg);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.checkBox.setSelected(layerable.isVisible());
        this.checkBox.setVisible(this.showCheckBox);
        if (LayerNameRenderer.isDisabledLayer(layerable)) {
            this.checkBox.setVisible(false);
        }
        if (this.indicatingEditability && layerable instanceof Layer) {
            if (layerable.isEditable()) {
                if (!layerable.isSelectable()) {
                    this.label.setFont(this.editableUnselectableFont);
                } else {
                    this.label.setFont(this.editableFont);
                }
            } else if (!layerable.isSelectable()) {
                this.label.setFont(this.unselectableFont);
            } else {
                this.label.setFont(this.font);
            }
            this.label.setForeground(isSelected ? SELECTED_EDITABLE_FONT_COLOR : UNSELECTED_EDITABLE_FONT_COLOR);
            if (layerable instanceof LayerView) {
                this.label.setForeground(LAYER_VIEW_COLOR);
            }
        } else {
            this.label.setFont(this.font);
        }
        this.imageLabel.setVisible(false);
        this.colorPanel.setVisible(false);
        if (this.showImageLabel && layerable instanceof ReferencedImagesLayer) {
            this.imageLabel.setIcon(((ReferencedImagesLayer)layerable).getFeatureCollectionWrapper().size() > 1 ? this.multiRasterIcon : this.rasterIcon);
            this.imageLabel.setVisible(true);
        } else if (this.showColorPanel && layerable instanceof Layer && !LayerNameRenderer.isDisabledLayer(layerable)) {
            this.colorPanel.init((Layer)layerable, isSelected, list.getBackground(), list.getSelectionBackground());
            this.colorPanel.setVisible(true);
        } else if (this.showImageLabel && layerable instanceof WMSLayer) {
            this.imageLabel.setIcon(this.wmsIcon);
            this.imageLabel.setVisible(true);
        } else if (this.showImageLabel && layerable instanceof RasterImageLayer) {
            if (((RasterImageLayer)layerable).getNumBands() == 1) {
                this.imageLabel.setIcon(this.sextante_rasterIcon2);
            } else {
                this.imageLabel.setIcon(this.sextante_rasterIcon);
            }
            this.imageLabel.setVisible(true);
        }
        this.progressIconLabel.setVisible(false);
        if (this.showProgressIconLabel) {
            if (layerable.getBlackboard().get(USE_CLOCK_ANIMATION_KEY, false) && this.indicatingProgress && this.renderingManager.getRenderer(layerable) != null && this.renderingManager.getRenderer(layerable).isRendering()) {
                layerable.getBlackboard().put(PROGRESS_ICON_KEY, layerable.getBlackboard().get(PROGRESS_ICON_KEY, 0) + 1);
                if (layerable.getBlackboard().getInt(PROGRESS_ICON_KEY) > this.getProgressIcons().length - 1) {
                    layerable.getBlackboard().put(PROGRESS_ICON_KEY, 0);
                }
                this.progressIconLabel.setIcon(this.getProgressIcons()[layerable.getBlackboard().getInt(PROGRESS_ICON_KEY)]);
                this.progressIconLabel.setVisible(true);
            } else {
                this.progressIconLabel.setIcon(this.clearProgressIcon);
                layerable.getBlackboard().put(PROGRESS_ICON_KEY, null);
                this.progressIconLabel.setVisible(false);
            }
        }
        return this;
    }

    private static boolean isDisabledLayer(Layerable layerable) {
        if (!(layerable instanceof Layer)) {
            return false;
        }
        Layer layer = (Layer)layerable;
        if (layer.getDataSourceQuery() == null || layer.getDataSourceQuery().getDataSource() == null) {
            return false;
        }
        return layer.getDataSourceQuery().getDataSource().isDisabled();
    }

    private JList<?> list(JTree tree) {
        JList list = new JList();
        list.setForeground(tree.getForeground());
        list.setBackground(tree.getBackground());
        list.setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
        list.setSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
        return list;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.formatLayerEntry(list, value, index, isSelected, cellHasFocus);
        return this;
    }

    private Dimension getPreferredListCellSize() {
        int width = 0;
        int height = 0;
        for (Component comp : this.getComponents()) {
            if (!comp.isVisible()) continue;
            int cheight = comp.getPreferredSize().height;
            height = Math.max(cheight, height);
            width += comp.getPreferredSize().width;
        }
        return new Dimension(width + 10, height);
    }

    private void _setComponentsFBGColor(Color c, boolean fg) {
        for (Component comp : this.getComponents()) {
            if (fg) {
                comp.setForeground(c);
                continue;
            }
            comp.setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this._setComponentsFBGColor(c, true);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this._setComponentsFBGColor(c, false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Layerable layerable = (Layerable)value;
        this.formatLayerEntry(this.list(tree), layerable, row, selected, hasFocus);
        if (selected) {
            this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.label.setForeground(tree.getForeground());
            this.label.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
            this.setBackground(tree.getBackground());
        }
        if (this.indicatingEditability && layerable instanceof Layer) {
            if (layerable.isEditable()) {
                this.label.setForeground(selected ? SELECTED_EDITABLE_FONT_COLOR : UNSELECTED_EDITABLE_FONT_COLOR);
            }
            if (!selected && layerable instanceof LayerView) {
                this.label.setForeground(LAYER_VIEW_COLOR);
            }
        }
        return this;
    }

    void jbInit() throws Exception {
        Insets zero_insets = new Insets(0, 0, 0, 0);
        this.setLayout(this.gridBagLayout);
        this.checkBox.setVisible(false);
        this.checkBox.setMargin(zero_insets);
        this.checkBox.setBorder(new EmptyBorder(zero_insets));
        this.label.setText("None");
        this.label.setBorder(new EmptyBorder(new Insets(0, 2, 0, 0)));
        Insets space_insets = new Insets(1, 2, 1, 0);
        this.add((Component)this.imageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, space_insets, 0, 0));
        this.add((Component)this.colorPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, space_insets, 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, space_insets, 0, 0));
        this.add((Component)this.progressIconLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, space_insets, 0, 0));
        this.add((Component)this.label, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, space_insets, 0, 0));
    }

    private Icon[] getProgressIcons() {
        if (this.progressIcons == null) {
            this.progressIcons = new Icon[]{GUIUtil.resize(IconLoader.icon("ClockN.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockNE.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockE.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockSE.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockS.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockSW.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockW.gif"), 13), GUIUtil.resize(IconLoader.icon("ClockNW.gif"), 13)};
        }
        return this.progressIcons;
    }

    public String filetype(File file) {
        String ext = CompressedFile.getExtension(file.getName());
        String filetype = "";
        switch (ext.toUpperCase()) {
            case "ASC": {
                filetype = "ASC - ESRI ASCII grid";
                break;
            }
            case "CSV": {
                filetype = "CSV - Comma-separated values";
                break;
            }
            case "DXF": {
                filetype = "Autocad DXF - Drawing Exchange Format";
                break;
            }
            case "FLT": {
                filetype = "FLT - ESRI Binary grid";
                break;
            }
            case "TIF": 
            case "TIFF": {
                filetype = "GEOTIF/TIFF Tagged Image File Format";
                break;
            }
            case "JPG": 
            case "JPEG": {
                filetype = "JPEG/JPG - Joint Photographic Experts Group";
                break;
            }
            case "PNG": {
                filetype = "PNG - Portable Network Graphics";
                break;
            }
            case "GIF": {
                filetype = "GIF - Graphics Interchange Format";
                break;
            }
            case "GRD": {
                filetype = "GRD - Surfer ASCII Grid";
                break;
            }
            case "JP2": {
                filetype = "JPEG 2000 - Joint Photographic Experts Group";
                break;
            }
            case "BMP": {
                filetype = "BMP - Windows Bitmap";
                break;
            }
            case "ECW": {
                filetype = "ECW - Enhanced Compression Wavelet";
                break;
            }
            case "MrSID": {
                filetype = "MrSID - Multiresolution seamless image database";
            }
        }
        return filetype;
    }

    private String generateMinimalToolTipText(Layerable layerable) {
        String tooltip = layerable instanceof Layer ? (((Layer)layerable).getDescription() == null || ((Layer)layerable).getDescription().trim().length() == 0 || ((Layer)layerable).getDescription().equals(layerable.getName()) ? FEATURE_COUNT + " = " + ((Layer)layerable).getFeatureCollectionWrapper().size() : layerable.getName() + ": " + ((Layer)layerable).getDescription()) : layerable.getName();
        return tooltip;
    }

    private String generateToolTipText(Layerable layerable) {
        String tooltip = "";
        String sourcePath = NODATASOURCELAYER.toUpperCase();
        if (layerable instanceof WMSLayer) {
            WMSLayer layer = (WMSLayer)layerable;
            String url = layer.getServerURL();
            String srs = layer.getSRS();
            Envelope env = layer.getEnvelope();
            tooltip = "<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">";
            tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layer.getName() + "<br>";
            tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b>WMS<br>";
            tooltip = tooltip + "<b>Url: </b>" + StringUtil.split(url, 350) + "<br>";
            tooltip = tooltip + "<b>" + SRS + ": </b>" + srs + "<br>";
            tooltip = tooltip + "<b>" + EXTENT + ": </b>" + env.toString() + "<br>";
            tooltip = tooltip + "</DIV></BODY></HTML>";
        } else if (layerable instanceof RasterImageLayer) {
            RasterImageLayer layer = (RasterImageLayer)layerable;
            if (layer.getImageFileName() != null && !layer.getImageFileName().contains(System.getProperty("java.io.tmpdir"))) {
                File image = new File(layer.getImageFileName());
                String type = this.filetype(image);
                String path = StringUtil.split(image.toString(), 350);
                tooltip = "<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">";
                tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layer.getName() + "<br>";
                tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b>:  " + type + " (" + SEXTANTE + ")<br>";
                tooltip = tooltip + "<b>" + SOURCE_PATH + ": </b>" + path + "<br>";
                tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>1<br>";
                tooltip = tooltip + "</DIV></BODY></HTML>";
            } else {
                tooltip = "<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">";
                tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layer.getName() + "<br>";
                tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b>" + SEXTANTE + "<br>";
                tooltip = tooltip + "<b>" + SOURCE_PATH + ": </b>";
                tooltip = tooltip + "<b><font color='red'>" + NODATASOURCELAYER + "</font></b><br>";
                tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>1<br>";
                tooltip = tooltip + "</DIV></BODY></HTML>";
            }
        } else if (layerable instanceof Layer) {
            Layer layer = (Layer)layerable;
            String layerName = layerable.getName();
            int size = layer.getFeatureCollectionWrapper().size();
            if (layer.getStyle(ReferencedImageStyle.class) == null && ((Layer)layerable).getDescription() != null) {
                DataSourceQuery dsq = layer.getDataSourceQuery();
                if (dsq != null) {
                    int dotPos;
                    String sourceClass = dsq.getDataSource().getClass().getName();
                    Object fnameObj = dsq.getDataSource().getProperties().get("File");
                    if (fnameObj == null) {
                        fnameObj = dsq.getDataSource().getProperties().get("Connection Descriptor");
                    }
                    if (fnameObj != null) {
                        sourcePath = fnameObj.toString();
                    }
                    if ((dotPos = sourceClass.lastIndexOf(".")) > 0) {
                        sourceClass = sourceClass.substring(dotPos + 1);
                    }
                    if ((dotPos = sourceClass.lastIndexOf("$")) > 0) {
                        sourceClass = sourceClass.substring(dotPos + 1);
                    }
                    String path = StringUtil.split(sourcePath, 350);
                    if (layer.isFeatureCollectionModified()) {
                        tooltip = "<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">";
                        tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layerName + " - <b><font color='blue'>" + MODIFIED + "</font></b><br>";
                        tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b>" + sourceClass + "<br>";
                        tooltip = tooltip + "<b>" + SOURCE_PATH + ": </b>" + path + "<br>";
                        tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>" + size + "<br>";
                        tooltip = tooltip + "</DIV></BODY></HTML>";
                    } else {
                        tooltip = "<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">";
                    }
                    tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layerName + "<br>";
                    tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b>" + sourceClass + "<br>";
                    tooltip = tooltip + "<b>" + SOURCE_PATH + ": </b>" + StringUtil.split(sourcePath, 350) + "<br>";
                    tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>" + size + "<br>";
                    tooltip = tooltip + "</DIV></BODY></HTML>";
                } else {
                    sourcePath = NODATASOURCELAYER;
                    tooltip = "<HTML><BODY>";
                    tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layerName + "<br>";
                    tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b><br>";
                    tooltip = tooltip + "<b>" + FILE_NAME + ": </b><b><font color='red'>" + sourcePath + "</font></b><br>";
                    tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>" + size + "<br>";
                    tooltip = tooltip + "</BODY></HTML>";
                }
            } else if (layer.getStyle(ReferencedImageStyle.class) != null && ((Layer)layerable).getDescription() != null) {
                FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
                for (Feature feature : featureCollection.getFeatures()) {
                    String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
                    sourcePathImage = sourcePathImage == null || sourcePathImage.length() < 5 ? "" : sourcePathImage.substring(5);
                    if (size == 1) {
                        File f = new File(sourcePathImage);
                        String filePath = f.getAbsolutePath();
                        String filePath1 = filePath.replace("%20", " ");
                        String type = this.filetype(f);
                        tooltip = "<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">";
                        tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layerName + "<br>";
                        tooltip = tooltip + "<b>" + DATASOURCE_CLASS + ": </b>" + type + "<br>";
                        tooltip = tooltip + "<b>" + SOURCE_PATH + ": </b>" + StringUtil.split(filePath1, 350) + "<br>";
                        tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>" + size + "<br>";
                        tooltip = tooltip + "</DIV></BODY></HTML>";
                        continue;
                    }
                    tooltip = "<HTML><BODY>";
                    tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layerName + "<br>";
                    tooltip = tooltip + "<b>" + SOURCE_PATH + ": </b>" + MULTIPLESOURCE + "<br>";
                    tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>" + size + "<br>";
                    tooltip = tooltip + "</BODY></HTML>";
                }
            } else {
                tooltip = "<HTML><BODY>";
                tooltip = tooltip + "<b>" + LAYER_NAME + ": </b>" + layerName + "<br>";
                tooltip = tooltip + "<b>" + FILE_NAME + ": </b>" + NODATASOURCELAYER + "<br>";
                tooltip = tooltip + "<b>" + FEATURE_COUNT + ": </b>" + size + "<br>";
                tooltip = tooltip + "</BODY></HTML>";
            }
        }
        return tooltip;
    }

    @Override
    public boolean isOpaque() {
        Color bgc = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatchOrOpaque = bgc != null && p != null && bgc.equals(p.getBackground()) && p.isOpaque();
        return !colorMatchOrOpaque && super.isOpaque();
    }

    public static boolean isTable(Layer layer) {
        for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
            if (feature.getGeometry().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

