/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.registry;

import com.vividsolutions.jump.util.CollectionMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Registry {
    private final CollectionMap<String, Object> classificationToEntriesMap = new CollectionMap();
    private final Map<String, Class<?>> typeMap = new HashMap();

    public Registry createEntry(String classification, Object entry) throws ClassCastException {
        Class<?> c = this.typeMap.get(classification);
        if (c != null && !c.isInstance(entry)) {
            throw new ClassCastException("Cannot Cast '" + entry + "' into " + c.getName() + " for classification '" + classification + "'");
        }
        this.classificationToEntriesMap.addItem(classification, entry);
        return this;
    }

    public Registry createEntries(String classification, Collection<?> entries) throws ClassCastException {
        for (Object entry : entries) {
            this.createEntry(classification, entry);
        }
        return this;
    }

    public List getEntries(String classification) {
        return new ArrayList<Object>(this.classificationToEntriesMap.getItems(classification));
    }

    public Registry createClassification(String classification, Class<?> type) throws ClassCastException {
        Collection<Object> collection;
        if (this.classificationToEntriesMap.containsKey(classification) && (collection = this.classificationToEntriesMap.getItems(classification)) != null) {
            for (Object entry : collection) {
                if (type.isInstance(entry)) continue;
                throw new ClassCastException("Cannot Cast '" + entry + "' into " + type.getName() + " for classification '" + classification + "'");
            }
        }
        this.typeMap.put(classification, type);
        return this;
    }
}

