/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.Operation;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.GeoReferencedLayerable;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.ObservableFeatureCollection;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.feature.AttributeOperationFactory;

public class Layer
extends GeoReferencedLayerable
implements Disposable {
    private static final String FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE = Layer.class.getName() + " - FIRING APPEARANCE CHANGED ON ATTRIBUTE CHANGE";
    private String description = "";
    private boolean drawingLast = false;
    private FeatureCollectionWrapper featureCollectionWrapper;
    private final List<Style> styles = new ArrayList<Style>();
    private boolean synchronizingLineColor = true;
    private LayerListener layerListener = null;
    private boolean featureCollectionModified = false;
    private DataSourceQuery dataSourceQuery;
    private Collection<String> expressions;

    public Layer() {
        this.getBlackboard().put(FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer(String name, Color fillColor, FeatureCollection featureCollection, LayerManager layerManager) {
        super(name, layerManager);
        this.getBlackboard().put(FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE, true);
        Assert.isTrue((featureCollection != null ? 1 : 0) != 0);
        this.setLayerManager(layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.addStyle(new BasicStyle());
            this.addStyle(new SquareVertexStyle());
            this.addStyle(new LabelStyle());
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
        this.getBasicStyle().setFillColor(fillColor);
        this.getBasicStyle().setLineColor(Layer.defaultLineColor(fillColor));
        this.getBasicStyle().setAlpha(150);
        this.getVertexStyle().setFillColor(fillColor);
        this.getVertexStyle().setLineColor(Layer.defaultLineColor(fillColor));
        this.getVertexStyle().setAlpha(150);
        this.getVertexStyle().setEnabled(false);
        this.setFeatureCollection(featureCollection);
    }

    public static Color defaultLineColor(Color fillColor) {
        return fillColor.darker();
    }

    public void setDescription(String description) {
        Assert.isTrue((description != null ? 1 : 0) != 0, (String)"Java2XML requires that the description be non-null. Use an empty string if necessary.");
        this.description = description;
    }

    public void setDrawingLast(boolean drawingLast) {
        this.drawingLast = drawingLast;
        this.fireAppearanceChanged();
    }

    public void setFeatureCollection(final FeatureCollection featureCollection) {
        final FeatureCollection oldFeatureCollection = this.featureCollectionWrapper != null ? this.featureCollectionWrapper.getUltimateWrappee() : AddNewLayerPlugIn.createBlankFeatureCollection();
        ObservableFeatureCollection observableFeatureCollection = new ObservableFeatureCollection(featureCollection);
        observableFeatureCollection.checkNotWrappingSameClass();
        observableFeatureCollection.add(new ObservableFeatureCollection.Listener(){

            @Override
            public void featuresAdded(Collection<Feature> features) {
                Layer.this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.ADDED, Layer.this);
            }

            @Override
            public void featuresRemoved(Collection<Feature> features) {
                Layer.this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.DELETED, Layer.this);
            }
        });
        if (this.getLayerManager() != null && this.getLayerManager().getLayers().contains(this) && this.getLayerManager().isFiringEvents()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Layer.this.getLayerManager().fireFeaturesChanged(oldFeatureCollection.getFeatures(), FeatureEventType.DELETED, Layer.this);
                    Layer.this.getLayerManager().fireFeaturesChanged(featureCollection.getFeatures(), FeatureEventType.ADDED, Layer.this);
                }
            });
        }
        this.setFeatureCollectionWrapper(observableFeatureCollection);
    }

    public void setSynchronizingLineColor(boolean synchronizingLineColor) {
        this.synchronizingLineColor = synchronizingLineColor;
        this.fireAppearanceChanged();
    }

    public BasicStyle getBasicStyle() {
        return (BasicStyle)this.getStyle(BasicStyle.class);
    }

    public VertexStyle getVertexStyle() {
        return (VertexStyle)this.getStyle(VertexStyle.class);
    }

    public LabelStyle getLabelStyle() {
        return (LabelStyle)this.getStyle(LabelStyle.class);
    }

    public String getDescription() {
        return this.description;
    }

    public FeatureCollectionWrapper getFeatureCollectionWrapper() {
        return this.featureCollectionWrapper;
    }

    protected void setFeatureCollectionWrapper(FeatureCollectionWrapper featureCollectionWrapper) {
        this.featureCollectionWrapper = featureCollectionWrapper;
        this.setFeatureSchemaOperations();
    }

    public Style getStyle(Class<?> c) {
        for (Style style : this.getStyles()) {
            if (!c.isInstance(style)) continue;
            return style;
        }
        return null;
    }

    public List<Style> getStylesIfEnabled(Class<?> filter) {
        ArrayList<Style> enabledStyles = new ArrayList<Style>();
        List<Style> someStyles = this.getStyles(filter);
        for (Style style : someStyles) {
            if (!style.isEnabled()) continue;
            enabledStyles.add(style);
        }
        return Collections.unmodifiableList(enabledStyles);
    }

    public List<Style> getStyles() {
        return Collections.unmodifiableList(this.styles);
    }

    public List<Style> getStyles(Class<?> filter) {
        ArrayList<Style> someStyles = new ArrayList<Style>();
        List<Style> allStyles = this.getStyles();
        for (Style style : allStyles) {
            if (!filter.isInstance(style)) continue;
            someStyles.add(style);
        }
        return Collections.unmodifiableList(someStyles);
    }

    public boolean hasReadableDataSource() {
        return this.dataSourceQuery != null && this.dataSourceQuery.getDataSource().isReadable();
    }

    public boolean isDrawingLast() {
        return this.drawingLast;
    }

    public boolean isSynchronizingLineColor() {
        return this.synchronizingLineColor;
    }

    public void addStyle(Style style) {
        this.styles.add(style);
        this.fireAppearanceChanged();
    }

    @Override
    public void dispose() {
        List<Feature> features = this.getFeatureCollectionWrapper().getFeatures();
        for (Feature feature : features) {
            if (!(feature instanceof Disposable)) continue;
            ((Disposable)((Object)feature)).dispose();
        }
        this.setFeatureCollection(AddNewLayerPlugIn.createBlankFeatureCollection());
    }

    public void removeStyle(Style p) {
        Assert.isTrue((boolean)this.styles.remove(p));
        this.fireAppearanceChanged();
    }

    public Collection<Style> cloneStyles() {
        ArrayList<Style> styleClones = new ArrayList<Style>();
        for (Style style : this.getStyles()) {
            styleClones.add((Style)style.clone());
        }
        return styleClones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyles(Collection<Style> newStyles) {
        boolean firingEvents = this.getLayerManager().isFiringEvents();
        this.getLayerManager().setFiringEvents(false);
        try {
            for (Style style : new ArrayList<Style>(this.getStyles())) {
                this.removeStyle(style);
            }
            for (Style style : newStyles) {
                this.addStyle(style);
            }
        }
        finally {
            this.getLayerManager().setFiringEvents(firingEvents);
        }
        this.fireAppearanceChanged();
    }

    @Override
    public void setLayerManager(LayerManager layerManager) {
        if (layerManager != null) {
            layerManager.removeLayerListener(this.getLayerListener());
        }
        super.setLayerManager(layerManager);
        if (layerManager != null) {
            layerManager.addLayerListener(this.getLayerListener());
        }
    }

    LayerListener getLayerListener() {
        if (this.layerListener == null) {
            this.layerListener = new LayerListener(){

                @Override
                public void featuresChanged(FeatureEvent e) {
                    if (e.getLayer() == Layer.this) {
                        Layer.this.setFeatureCollectionModified(true);
                        if (e.getType() != FeatureEventType.ATTRIBUTES_MODIFIED || Layer.this.getBlackboard().get(FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE, true)) {
                            Layer.this.fireAppearanceChanged();
                        }
                        SRIDStyle ss = (SRIDStyle)Layer.this.getStyle(SRIDStyle.class);
                        if (e.getType() != FeatureEventType.DELETED && ss != null) {
                            for (Feature feature : e.getFeatures()) {
                                feature.getGeometry().setSRID(ss.getSRID());
                            }
                        }
                    }
                }

                @Override
                public void layerChanged(LayerEvent e) {
                }

                @Override
                public void categoryChanged(CategoryEvent e) {
                }
            };
        }
        return this.layerListener;
    }

    public static UndoableCommand addUndo(final String layerName, final LayerManagerProxy proxy, final UndoableCommand wrappeeCommand) {
        return new UndoableCommand(wrappeeCommand.getName()){
            private Layer layer;
            private String categoryName;
            private Collection<Feature> features;
            private boolean visible;

            private Layer currentLayer() {
                return proxy.getLayerManager().getLayer(layerName);
            }

            @Override
            public void execute() {
                this.layer = this.currentLayer();
                if (this.layer != null) {
                    this.features = new ArrayList<Feature>(this.layer.getFeatureCollectionWrapper().getFeatures());
                    this.categoryName = this.layer.getName();
                    this.visible = this.layer.isVisible();
                }
                wrappeeCommand.execute();
            }

            @Override
            public void unexecute() {
                wrappeeCommand.unexecute();
                if (this.layer == null && this.currentLayer() != null) {
                    proxy.getLayerManager().remove(this.currentLayer());
                }
                if (this.layer != null && this.currentLayer() == null) {
                    proxy.getLayerManager().addLayer(this.categoryName, this.layer);
                }
                if (this.layer != null) {
                    this.layer.getFeatureCollectionWrapper().clear();
                    this.layer.getFeatureCollectionWrapper().addAll(this.features);
                    this.layer.setVisible(this.visible);
                }
            }
        };
    }

    public static void tryToInvalidateEnvelope(Layer layer) {
        if (layer.getFeatureCollectionWrapper().getUltimateWrappee() instanceof FeatureDataset) {
            ((FeatureDataset)layer.getFeatureCollectionWrapper().getUltimateWrappee()).invalidateEnvelope();
        }
    }

    public DataSourceQuery getDataSourceQuery() {
        return this.dataSourceQuery;
    }

    public Layer setDataSourceQuery(DataSourceQuery dataSourceQuery) {
        this.dataSourceQuery = dataSourceQuery;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        return this;
    }

    public boolean isFeatureCollectionModified() {
        return this.featureCollectionModified;
    }

    public Layer setFeatureCollectionModified(boolean featureCollectionModified) {
        if (this.featureCollectionModified == featureCollectionModified) {
            return this;
        }
        this.featureCollectionModified = featureCollectionModified;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        return this;
    }

    public Collection<String> getFeatureSchemaOperations() {
        FeatureSchema fs = this.getFeatureCollectionWrapper().getFeatureSchema();
        ArrayList<String> operations = new ArrayList<String>();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            Operation operation = fs.getOperation(i);
            if (operation != null) {
                operations.add(fs.getOperation(i).toString());
                continue;
            }
            operations.add("NULL");
        }
        return Collections.unmodifiableCollection(operations);
    }

    public void addFeatureSchemaOperation(String expression) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<String>();
        }
        this.expressions.add(expression);
    }

    private void setFeatureSchemaOperations() {
        FeatureCollectionWrapper fc = this.getFeatureCollectionWrapper();
        if (this.expressions != null && fc != null && this.expressions.size() == fc.getFeatureSchema().getAttributeCount()) {
            FeatureSchema schema = fc.getFeatureSchema();
            Iterator<String> it = this.expressions.iterator();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                try {
                    String expression = it.next();
                    if (expression == null || expression.equals("NULL") || expression.indexOf(10) <= -1) continue;
                    String[] class_expression = expression.split("\n", 2);
                    Operation op = AttributeOperationFactory.getFactory(class_expression[0]).createOperation(schema.getAttributeType(i), class_expression[1]);
                    schema.setOperation(i, op);
                    schema.setAttributeReadOnly(i, true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.expressions = null;
    }
}

