/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.ecw;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JNCSRendererProxy {
    public static final String RENDERER_CLASS = System.getProperty("ecw.java.wrapper", "com.ermapper.ecw.JNCSRenderer");
    protected Object renderer;

    public JNCSRendererProxy(String location, boolean flag) throws Exception {
        Class<?> clazz = Class.forName(RENDERER_CLASS);
        Constructor<?> constructor = clazz.getConstructor(String.class, Boolean.TYPE);
        try {
            this.renderer = constructor.newInstance(location, flag ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (InvocationTargetException ite) {
            JNCSRendererProxy.throwAsException(ite);
        }
    }

    public static void throwAsException(InvocationTargetException ite) throws Exception {
        Throwable t = ite.getTargetException();
        throw t instanceof Exception ? (Exception)t : (t != null ? new Exception(t.getMessage()) : ite);
    }

    public static int getInt(Object object, String fieldname) {
        try {
            Field field = object.getClass().getField(fieldname);
            return field.getInt(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getInt(String fieldname) {
        return JNCSRendererProxy.getInt(this.renderer, fieldname);
    }

    public static double getDouble(Object object, String fieldname) {
        try {
            Field field = object.getClass().getField(fieldname);
            return field.getDouble(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public double getDouble(String fieldname) {
        return JNCSRendererProxy.getDouble(this.renderer, fieldname);
    }

    public double getOriginX() {
        return this.getDouble("originX");
    }

    public double getOriginY() {
        return this.getDouble("originY");
    }

    public int getWidth() {
        return this.getInt("width");
    }

    public int getHeight() {
        return this.getInt("height");
    }

    public double getCellIncrementX() {
        return this.getDouble("cellIncrementX");
    }

    public double getCellIncrementY() {
        return this.getDouble("cellIncrementY");
    }

    public int getNumBands() {
        return this.getInt("numBands");
    }

    public Point convertWorldToDataset(double x, double y) throws Exception {
        try {
            Method method = this.renderer.getClass().getMethod("convertWorldToDataset", Double.TYPE, Double.TYPE);
            Object datasetPoint = method.invoke(this.renderer, x, y);
            return new Point(JNCSRendererProxy.getInt(datasetPoint, "x"), JNCSRendererProxy.getInt(datasetPoint, "y"));
        }
        catch (InvocationTargetException ite) {
            JNCSRendererProxy.throwAsException(ite);
            throw new RuntimeException("Never reached!");
        }
    }

    public Point2D.Double convertDatasetToWorld(int x, int y) throws Exception {
        try {
            Method method = this.renderer.getClass().getMethod("convertDatasetToWorld", Integer.TYPE, Integer.TYPE);
            Object worldPoint = method.invoke(this.renderer, x, y);
            return new Point2D.Double(JNCSRendererProxy.getDouble(worldPoint, "x"), JNCSRendererProxy.getDouble(worldPoint, "y"));
        }
        catch (InvocationTargetException ite) {
            JNCSRendererProxy.throwAsException(ite);
            throw new RuntimeException("Never reached!");
        }
    }

    public void setView(int numBands, int[] bands, int firstColumn, int firstLine, int lastColumn, int lastLine, int width, int height) throws Exception {
        try {
            Method method = this.renderer.getClass().getMethod("setView", Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.invoke(this.renderer, numBands, bands, firstColumn, firstLine, lastColumn, lastLine, width, height);
        }
        catch (InvocationTargetException ite) {
            JNCSRendererProxy.throwAsException(ite);
        }
    }

    public void readLineRGBA(int[] rgba) throws Exception {
        try {
            Method method = this.renderer.getClass().getMethod("readLineRGBA", int[].class);
            method.invoke(this.renderer, new Object[]{rgba});
        }
        catch (InvocationTargetException ite) {
            JNCSRendererProxy.throwAsException(ite);
        }
    }

    public void close(boolean flag) {
        try {
            Method method = this.renderer.getClass().getMethod("close", Boolean.TYPE);
            method.invoke(this.renderer, flag ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

