/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFeature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Prioritized;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ui.io.file.AbstractFileLayerLoader;
import org.openjump.core.ui.util.TaskUtil;
import org.openjump.util.UriUtil;

public class ReferencedImageFactoryFileLayerLoader
extends AbstractFileLayerLoader
implements Prioritized {
    protected WorkbenchContext workbenchContext;
    protected ReferencedImageFactory imageFactory;

    public ReferencedImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public ReferencedImageFactoryFileLayerLoader(WorkbenchContext workbenchContext, ReferencedImageFactory imageFactory, String[] additionalSupportedFileExtensions) {
        super(imageFactory.getDescription(), new ArrayList<String>());
        this.imageFactory = imageFactory;
        this.workbenchContext = workbenchContext;
        HashSet<String> exts = new HashSet<String>(Arrays.asList(imageFactory.getExtensions()));
        if (additionalSupportedFileExtensions instanceof String[]) {
            exts.addAll(Arrays.asList(additionalSupportedFileExtensions));
        }
        this.addFileExtensions(new ArrayList<String>(exts));
    }

    @Override
    public boolean open(TaskMonitor monitor, URI uri, Map<String, Object> options) throws Exception {
        Feature feature;
        Layer layer;
        LayerManager layerManager = this.workbenchContext.getLayerManager();
        Layer targetLayer = (Layer)options.get("LAYER");
        if (targetLayer != null) {
            layer = targetLayer;
        } else {
            layerManager.setFiringEvents(false);
            layer = ReferencedImageFactoryFileLayerLoader.createLayer(layerManager, uri);
            layerManager.setFiringEvents(true);
        }
        try {
            feature = ReferencedImageFactoryFileLayerLoader.createImageFeature(this.imageFactory, uri, this.getImageryLayerDataset(layer));
        }
        catch (Exception e) {
            throw new ReferencedImageException(I18N.getInstance().get("com.vividsolutions.jump.workbench.imagery.ReferencedImageException", UriUtil.getFileName(uri), this.imageFactory.getDescription()), e);
        }
        if (targetLayer == null) {
            Category category = TaskUtil.getSelectedCategoryName(this.workbenchContext);
            category.add(0, layer);
        }
        layer.getFeatureCollectionWrapper().add(feature);
        layer.setFeatureCollectionModified(false);
        SRIDStyle sridStyle = (SRIDStyle)layer.getStyle(SRIDStyle.class);
        int prjSRID = 0;
        try {
            String prjSRIDString = ProjUtils.getSRSInfoFromLayerStyleOrSource(layer).getCode();
            prjSRID = prjSRIDString.matches("\\d+") ? Integer.parseInt(prjSRIDString) : 0;
        }
        catch (Exception e) {
            prjSRID = 0;
        }
        sridStyle.setSRID(prjSRID);
        sridStyle.updateSRIDs(layer);
        String imageFilePath = (String)feature.getAttribute(ImageryLayerDataset.ATTR_URI);
        if (this.imageFactory.isEditableImage(uri.toString())) {
            layer.setSelectable(true);
            layer.setEditable(true);
            layer.setReadonly(false);
        } else {
            layer.setSelectable(false);
            layer.setEditable(false);
            layer.setReadonly(true);
        }
        return true;
    }

    private ImageryLayerDataset getImageryLayerDataset(Layer layer) {
        ReferencedImageStyle irs = (ReferencedImageStyle)layer.getStyle(ReferencedImageStyle.class);
        return irs.getImageryLayerDataset();
    }

    private static Feature createBaseFeature(ReferencedImageFactory referencedImageFactory, URI uri) {
        ReferencedImageFeature feature = new ReferencedImageFeature(ImageryLayerDataset.getSchema());
        feature.setAttribute(ImageryLayerDataset.ATTR_URI, (Object)uri.toString());
        ImageryLayerDataset.saveFeatureImgAttribs((Feature)feature, referencedImageFactory);
        feature.setGeometry((Geometry)new GeometryFactory().createPoint((Coordinate)null));
        return feature;
    }

    public static Feature createImageFeature(Feature f_orig, ImageryLayerDataset imageryLayerDataset) {
        ReferencedImageFeature f_new = new ReferencedImageFeature(ImageryLayerDataset.getSchema());
        ImageryLayerDataset.saveFeatureImgAttribs((Feature)f_new, f_orig);
        if (f_orig.getGeometry() instanceof Geometry) {
            f_new.setGeometry(f_orig.getGeometry());
        }
        try {
            imageryLayerDataset.attachImage(f_new);
        }
        catch (Exception e) {
            e.printStackTrace();
            ImageryLayerDataset.saveFeatureError(f_new, e);
            f_new.setGeometry((Geometry)new GeometryFactory().createPoint(new Coordinate()));
        }
        return f_new;
    }

    public static Feature createImageFeature(ReferencedImageFactory referencedImageFactory, URI uri, ImageryLayerDataset imageryLayerDataset) throws Exception {
        Feature feature = ReferencedImageFactoryFileLayerLoader.createBaseFeature(referencedImageFactory, uri);
        imageryLayerDataset.attachImage(feature);
        return feature;
    }

    public static Collection createImageFeatures(final ReferencedImageFactory referencedImageFactory, URI[] uris, final ImageryLayerDataset imageryLayerDataset) {
        return CollectionUtil.collect(Arrays.asList(uris), new Block(){

            @Override
            public Object yield(Object uri) {
                Feature feature = ReferencedImageFactoryFileLayerLoader.createBaseFeature(referencedImageFactory, (URI)uri);
                try {
                    imageryLayerDataset.attachImage(feature);
                }
                catch (Exception e) {
                    ImageryLayerDataset.saveFeatureError(feature, e);
                }
                return feature;
            }
        });
    }

    public static Layer createLayer(LayerManager layerManager, URI uri) {
        String layerName = CompressedFile.createLayerName(uri);
        ReferencedImagesLayer layer = new ReferencedImagesLayer(layerName, Color.black, new FeatureDataset(ImageryLayerDataset.getSchema()), layerManager);
        layer.setEditable(true);
        layer.getBasicStyle().setEnabled(false);
        layer.getBasicStyle().setRenderingFill(false);
        layer.addStyle(new ReferencedImageStyle());
        return layer;
    }

    @Override
    public int getPriority() {
        return this.imageFactory instanceof Prioritized ? ((Prioritized)((Object)this.imageFactory)).getPriority() : Integer.MAX_VALUE;
    }
}

