/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;

public abstract class SimpleTreeModel
implements TreeModel {
    private final Object root;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private boolean firingEvents = true;

    public SimpleTreeModel(Object root) {
        this.root = root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (this.getChild(parent, i).toString().equals(child.toString())) {
                return i;
            }
            if (this.getChild(parent, i) != child) continue;
            return i;
        }
        Assert.shouldNeverReachHere((String)(parent + ", " + child));
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    public abstract List<?> getChildren(Object var1);

    @Override
    public Object getChild(Object parent, int index) {
        return this.children(parent).get(index);
    }

    private List<?> children(Object parent) {
        return this.getChildren(parent);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.children(parent).size();
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }

    public void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }
}

