/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import org.openjump.core.rasterimage.styler.ColorUtils;

public class ColorUtil {
    public static final Color GOLD = new Color(255, 192, 0, 150);
    public static final Color PALE_BLUE = new Color(153, 204, 255, 150);
    public static final Color PALE_RED = new Color(255, 204, 204, 150);
    static String[] color2s = new String[]{"#08306b", "#00441b", "#7f2704", "#3f007d", "#67000d", "#000000"};
    static String[] color1s = new String[]{"#f7fbff", "#f7fcf5", "#fff5eb", "#fcfbfd", "#fff5f0", "#ffffff"};

    public static ColorScheme createRandomColorSchema(int intervals) throws Exception {
        ColorUtils colorUtils = new ColorUtils();
        ArrayList<Color> arrayColor = new ArrayList<Color>();
        Color startColor = Color.decode(color1s[new Random().nextInt(color1s.length)]);
        arrayColor.add(startColor);
        Color endColor = Color.decode(color2s[new Random().nextInt(color2s.length)]);
        for (int c = 1; c < intervals; ++c) {
            double cellRelDistance = (double)c / (double)intervals;
            Color color = colorUtils.interpolateColor(startColor, endColor, cellRelDistance);
            arrayColor.add(color);
        }
        arrayColor.add(endColor);
        ColorScheme colorScheme = new ColorScheme("test", arrayColor);
        return colorScheme;
    }

    public static ColorScheme createColorSchema(int intervals, Color startColor, Color endColor) throws Exception {
        ColorUtils colorUtils = new ColorUtils();
        ArrayList<Color> arrayColor = new ArrayList<Color>();
        arrayColor.add(startColor);
        for (int c = 1; c < intervals; ++c) {
            double cellRelDistance = (double)c / (double)intervals;
            Color color = colorUtils.interpolateColor(startColor, endColor, cellRelDistance);
            arrayColor.add(color);
        }
        arrayColor.add(endColor);
        ColorScheme colorScheme = new ColorScheme("test", arrayColor);
        return colorScheme;
    }
}

