/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.qa.diff.MatchFeature;
import com.vividsolutions.jump.qa.diff.MatchGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Geometry;

public class MatchCollection {
    private FeatureCollection inputFC;
    private Collection<MatchFeature> matchFeatures = new ArrayList<MatchFeature>();
    private Collection<MatchGeometry> matchGeometries = new ArrayList<MatchGeometry>();

    public MatchCollection(FeatureCollection fc, boolean splitIntoComponents) {
        this.inputFC = fc;
        this.init(fc, splitIntoComponents);
    }

    private void init(FeatureCollection fc, boolean splitIntoComponents) {
        for (Feature feature : fc.getFeatures()) {
            MatchFeature matchFeat = new MatchFeature(feature);
            this.matchFeatures.add(matchFeat);
            Geometry geom = feature.getGeometry();
            Collection<Geometry> list = MatchGeometry.splitGeometry(geom, splitIntoComponents);
            for (Geometry geometry : list) {
                MatchGeometry matchGeom = new MatchGeometry(matchFeat, geometry);
                this.matchGeometries.add(matchGeom);
            }
        }
    }

    public Iterator geometryIterator() {
        return this.matchGeometries.iterator();
    }

    public Iterator iterator() {
        return this.matchFeatures.iterator();
    }

    public int size() {
        return this.matchFeatures.size();
    }

    public int geometrySize() {
        return this.matchGeometries.size();
    }

    public void computeFeatureMatches() {
        for (MatchFeature matchFeature : this.matchFeatures) {
            matchFeature.setMatched(true);
        }
        for (MatchGeometry matchGeometry : this.matchGeometries) {
            if (matchGeometry.isMatched()) continue;
            matchGeometry.getFeature().setMatched(false);
        }
    }

    public void propagateUnmatchedFeatures() {
        for (MatchGeometry matchGeometry : this.matchGeometries) {
            MatchGeometry mgOpposite;
            if (matchGeometry.getFeature().isMatched() || (mgOpposite = matchGeometry.getMatch()) == null) continue;
            mgOpposite.getFeature().setMatched(false);
        }
    }

    public FeatureCollection getUnmatchedFeatures() {
        FeatureDataset noMatch = new FeatureDataset(this.inputFC.getFeatureSchema());
        for (MatchFeature matchFeature : this.matchFeatures) {
            if (matchFeature.isMatched()) continue;
            noMatch.add(matchFeature.getFeature());
        }
        return noMatch;
    }
}

