/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.qa;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.qa.diff.BufferGeometryMatcher;
import com.vividsolutions.jump.qa.diff.DiffGeometryComponents;
import com.vividsolutions.jump.qa.diff.DiffSegments;
import com.vividsolutions.jump.qa.diff.DiffSegmentsWithTolerance;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.ColorUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DiffGeometryPlugIn
extends ThreadedBasePlugIn {
    private String sLayer = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Layer");
    private String LAYER1 = this.sLayer + " 1";
    private String LAYER2 = this.sLayer + " 2";
    private String MATCH_SEGMENTS = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-Segments");
    private String MATCH_GEOMETRY = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-entire-Geometry");
    private String EXACT_COORD_ORDER = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Test-for-identical-Start-point-and-Orientation");
    private String USE_TOLERANCE = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-using-Distance-Tolerance");
    private String DISTANCE_TOL = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Distance-Tolerance");
    private String SPLIT_COMPONENTS = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-components-of-MultiGeometries");
    private String sSegmentDiffs = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Segment-Diffs");
    private String sUnmGeoms = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Unmatched-Geometries-in-Layer");
    private String sUnmSegms = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Unmatched-Segments-in-Geometry-Diffs-in-Layer");
    private MultiInputDialog dialog;
    private Layer layer1;
    private Layer layer2;
    private boolean matchGeometry = false;
    private boolean useTolerance = false;
    private double distanceTolerance = 1.0;
    private boolean testExactCoordinateOrder = false;
    private boolean splitIntoComponents = false;
    private JRadioButton matchSegmentsRB;
    private JRadioButton matchGeometryRB;
    private JCheckBox splitComponentsCheckbox;
    private JCheckBox exactOrderCheckbox;
    private JCheckBox useToleranceCheckbox;
    private JTextField distanceTextField;

    @Override
    public String getName() {
        return I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Calculate-Geometry-Differences");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QA}, this.getName() + "...", false, null, DiffGeometryPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.sLayer = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Layer");
        this.LAYER1 = this.sLayer + " 1";
        this.LAYER2 = this.sLayer + " 2";
        this.MATCH_SEGMENTS = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-Segments");
        this.MATCH_GEOMETRY = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-entire-Geometry");
        this.EXACT_COORD_ORDER = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Test-for-identical-Start-point-and-Orientation");
        this.USE_TOLERANCE = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-using-Distance-Tolerance");
        this.DISTANCE_TOL = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Distance-Tolerance");
        this.SPLIT_COMPONENTS = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-components-of-MultiGeometries");
        this.sSegmentDiffs = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Segment-Diffs");
        this.sUnmGeoms = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Unmatched-Geometries-in-Layer");
        this.sUnmSegms = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Unmatched-Segments-in-Geometry-Diffs-in-Layer");
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection[] diffFC = new FeatureCollection[]{this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper()};
        if (this.matchGeometry) {
            DiffGeometryComponents diff = new DiffGeometryComponents(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), monitor);
            diff.setNormalize(!this.testExactCoordinateOrder);
            diff.setSplitIntoComponents(this.splitIntoComponents);
            if (this.useTolerance) {
                diff.setMatcher(new BufferGeometryMatcher(this.distanceTolerance));
            }
            diffFC = diff.diff();
        }
        monitor.report(I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Computing-Segment-Diffs"));
        FeatureCollection[] diffSegFC = this.diffSegments(diffFC, monitor);
        this.createLayers(context, diffFC, diffSegFC);
        this.createOutput(context, diffFC, diffSegFC);
    }

    public FeatureCollection[] diffSegments(FeatureCollection[] diffFC, TaskMonitor monitor) throws Exception {
        FeatureCollection[] diffSegFC;
        if (!this.useTolerance) {
            DiffSegments diff = new DiffSegments(monitor);
            diff.setSegments(0, diffFC[0]);
            diff.setSegments(1, diffFC[1]);
            diffSegFC = new FeatureCollection[]{diff.computeDiffEdges(0), diff.computeDiffEdges(1)};
        } else {
            DiffSegmentsWithTolerance diff = new DiffSegmentsWithTolerance(diffFC[0], diffFC[1], this.distanceTolerance);
            diffSegFC = diff.diff();
        }
        return diffSegFC;
    }

    public static void setDiffGeometryStyle(Layer lyr, Color fillColor, Color lineColor) {
        lyr.getBasicStyle().setRenderingFill(true);
        lyr.getBasicStyle().setFillColor(fillColor);
        lyr.setSynchronizingLineColor(false);
        lyr.getBasicStyle().setAlpha(200);
        lyr.getBasicStyle().setLineWidth(1);
        lyr.getBasicStyle().setLineColor(lineColor);
        lyr.getVertexStyle().setEnabled(false);
    }

    private void createLayers(PlugInContext context, FeatureCollection[] diffFC, FeatureCollection[] diffSegFC) {
        Layer segLyr = context.addLayer(StandardCategoryNames.QA, this.sSegmentDiffs + " - " + this.layer1.getName(), diffSegFC[0]);
        LayerStyleUtil.setLinearStyle(segLyr, Color.red, 2, 4);
        segLyr.fireAppearanceChanged();
        Layer segLyr2 = context.addLayer(StandardCategoryNames.QA, this.sSegmentDiffs + " - " + this.layer2.getName(), diffSegFC[1]);
        LayerStyleUtil.setLinearStyle(segLyr2, Color.blue, 2, 4);
        segLyr2.fireAppearanceChanged();
        if (this.matchGeometry) {
            Layer lyr = context.addLayer(StandardCategoryNames.QA, this.sSegmentDiffs + " - " + this.layer1.getName(), diffFC[0]);
            DiffGeometryPlugIn.setDiffGeometryStyle(lyr, ColorUtil.PALE_RED, Color.red);
            lyr.fireAppearanceChanged();
            Layer lyr2 = context.addLayer(StandardCategoryNames.QA, this.sSegmentDiffs + " - " + this.layer2.getName(), diffFC[1]);
            DiffGeometryPlugIn.setDiffGeometryStyle(lyr2, ColorUtil.PALE_BLUE, Color.blue);
            lyr2.fireAppearanceChanged();
        }
    }

    private void createOutput(PlugInContext context, FeatureCollection[] diffFC, FeatureCollection[] diffSegFC) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, this.getName());
        context.getOutputFrame().addField(this.sLayer + " 1: ", this.layer1.getName());
        context.getOutputFrame().addField(this.sLayer + " 2: ", this.layer2.getName());
        if (this.useTolerance) {
            context.getOutputFrame().addField(this.DISTANCE_TOL + ":", "" + this.distanceTolerance);
        }
        if (this.testExactCoordinateOrder) {
            context.getOutputFrame().addField(this.EXACT_COORD_ORDER + ":", Boolean.toString(this.testExactCoordinateOrder));
        }
        if (this.matchGeometry) {
            context.getOutputFrame().addText(" ");
            context.getOutputFrame().addField("# " + this.sUnmGeoms + " 1: ", "" + diffFC[0].size());
            context.getOutputFrame().addField("# " + this.sUnmGeoms + " 2: ", "" + diffFC[1].size());
        }
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField("# " + this.sUnmSegms + " 1: ", "" + diffSegFC[0].size());
        context.getOutputFrame().addField("# " + this.sUnmSegms + " 2: ", "" + diffSegFC[1].size());
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("DiffGeometry.png")));
        dialog.setSideBarDescription(I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Finds-differences-between-the-Segments-or-Geometries-in-two-layers") + "  " + I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Matching-can-be-either-exact-or-within-a-Distance-Tolerance"));
        dialog.addLayerComboBox(this.LAYER1, context.getLayerManager().getLayer(0), context.getLayerManager());
        dialog.addLayerComboBox(this.LAYER2, context.getLayerManager().getLayer(1), context.getLayerManager());
        String MATCH_TYPE_GROUP = I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Match-Type");
        this.matchSegmentsRB = dialog.addRadioButton(this.MATCH_SEGMENTS, MATCH_TYPE_GROUP, !this.matchGeometry, I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Matches-using-segments-only"));
        this.matchGeometryRB = dialog.addRadioButton(this.MATCH_GEOMETRY, MATCH_TYPE_GROUP, this.matchGeometry, I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Matches-using-full-geometry-topology,-not-just-segments"));
        this.matchSegmentsRB.addItemListener(new StateItemListener());
        this.matchGeometryRB.addItemListener(new StateItemListener());
        this.splitComponentsCheckbox = dialog.addCheckBox(this.SPLIT_COMPONENTS, this.splitIntoComponents, I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Matches-individual-components-of-MultiGeometries"));
        this.exactOrderCheckbox = dialog.addCheckBox(this.EXACT_COORD_ORDER, false, I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Requires-coordinate-lists-in-matching-geometries-to-have-identical-start-points-and-ring-orientation"));
        dialog.addLabel("");
        this.useToleranceCheckbox = dialog.addCheckBox(this.USE_TOLERANCE, this.useTolerance, I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Matches-geometries-if-all-points-are-within-the-Distance-Tolerance-of-the-other-Geometry"));
        this.distanceTextField = dialog.addDoubleField(this.DISTANCE_TOL, this.distanceTolerance, 8, I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Specifies-how-close-geometries-must-be-to-match"));
        this.useToleranceCheckbox.addItemListener(new StateItemListener());
        this.updateUI();
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(this.LAYER1);
        this.layer2 = dialog.getLayer(this.LAYER2);
        this.matchGeometry = dialog.getBoolean(this.MATCH_GEOMETRY);
        this.useTolerance = dialog.getBoolean(this.USE_TOLERANCE);
        this.distanceTolerance = dialog.getDouble(this.DISTANCE_TOL);
        this.splitIntoComponents = dialog.getBoolean(this.SPLIT_COMPONENTS);
        this.testExactCoordinateOrder = dialog.getBoolean(this.EXACT_COORD_ORDER);
    }

    private void updateUI() {
        boolean matchGeometry = this.dialog.getBoolean(this.MATCH_GEOMETRY);
        this.splitComponentsCheckbox.setEnabled(matchGeometry);
        this.exactOrderCheckbox.setEnabled(matchGeometry);
        boolean useDistance = this.dialog.getBoolean(this.USE_TOLERANCE);
        this.distanceTextField.setEnabled(useDistance);
        this.distanceTextField.setOpaque(useDistance);
    }

    private class StateItemListener
    implements ItemListener {
        private StateItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DiffGeometryPlugIn.this.updateUI();
        }
    }
}

