/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.plugin.edit.SegmentsExtracter;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class ExtractSegmentsPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String LAYER = I18N.getInstance().get("ui.MenuNames.LAYER");
    private String layerName;
    private boolean removeDoubledSegments = false;
    private boolean makeDoubledSegmentsUnique = false;
    private boolean mergeResultingSegments = false;
    private boolean keepAllSegments = true;
    private boolean keepAttributes = false;
    private int uniqueSegmentCount = 0;

    private static FeatureCollection toLineStrings(Collection<LineSegment> segments) {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        GeometryFactory fact = new GeometryFactory();
        FeatureDataset dataset = new FeatureDataset(schema);
        for (LineSegment segment : segments) {
            LineString ls = segment.toGeometry(fact);
            BasicFeature f = new BasicFeature(schema);
            f.setGeometry((Geometry)ls);
            dataset.add(f);
        }
        return dataset;
    }

    private static FeatureCollection toLineStrings(Collection<LineSegment> segments, Map<LineSegment, List<Feature>> map) {
        assert (map != null);
        assert (map.size() > 0) : "no segment/feature map";
        assert (map.get(map.keySet().iterator().next()) != null) : "first segment does not map any feature";
        assert (map.get(map.keySet().iterator().next()).size() > 0) : "first segment does not map any feature";
        FeatureSchema schema = map.get(map.keySet().iterator().next()).get(0).getSchema();
        GeometryFactory fact = new GeometryFactory();
        FeatureDataset dataset = new FeatureDataset(schema);
        for (LineSegment segment : segments) {
            List<Feature> features = map.get(segment);
            LineString ls = segment.toGeometry(fact);
            for (Feature f : features) {
                Feature bf = f.clone(false);
                bf.setGeometry((Geometry)ls);
                dataset.add(bf);
            }
        }
        return dataset;
    }

    private static FeatureCollection toMergedLineStrings(Collection<LineSegment> segments) {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        GeometryFactory fact = new GeometryFactory();
        LineMerger lineMerger = new LineMerger();
        for (LineSegment segment : segments) {
            lineMerger.add((Geometry)segment.toGeometry(fact));
        }
        FeatureDataset dataset = new FeatureDataset(schema);
        for (Object o : lineMerger.getMergedLineStrings()) {
            BasicFeature bf = new BasicFeature(schema);
            bf.setGeometry((Geometry)o);
            dataset.add(bf);
        }
        return dataset;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Extract-Segments");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection result;
        Collection<LineSegment> segmentList;
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Extracting-Segments"));
        Layer layer = context.getLayerManager().getLayer(this.layerName);
        FeatureCollectionWrapper lineFC = layer.getFeatureCollectionWrapper();
        int inputEdgeCount = lineFC.size();
        if (inputEdgeCount == 0) {
            context.getWorkbenchFrame().warnUser("jump.plugin.edit.ExtractSegmentsPlugIn.No-edge-to-process");
            return;
        }
        SegmentsExtracter extracter = new SegmentsExtracter(monitor);
        if (this.removeDoubledSegments || this.makeDoubledSegmentsUnique) {
            extracter.normalizeSegments();
            extracter.add(lineFC);
            Collection<LineSegment> collection = segmentList = this.removeDoubledSegments ? extracter.getSegments(1, 1) : extracter.getSegments();
            result = this.mergeResultingSegments ? ExtractSegmentsPlugIn.toMergedLineStrings(segmentList) : ExtractSegmentsPlugIn.toLineStrings(segmentList);
        } else {
            if (this.keepAttributes) {
                extracter.keepSource();
            }
            extracter.add(lineFC);
            if (this.keepAttributes) {
                segmentList = extracter.getSegments();
                result = ExtractSegmentsPlugIn.toLineStrings(segmentList, extracter.getSegmentSource());
            } else {
                segmentList = extracter.getAllSegments();
                result = ExtractSegmentsPlugIn.toLineStrings(segmentList);
            }
        }
        this.uniqueSegmentCount = segmentList.size();
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayers(context, result);
    }

    private void createLayers(PlugInContext context, FeatureCollection result) throws Exception {
        context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Extracted-Segs"), result);
        this.createOutput(context);
    }

    private void createOutput(PlugInContext context) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Extract-Segments"));
        context.getOutputFrame().addField(I18N.getInstance().get("ui.MenuNames.LAYER") + ":", this.layerName);
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Number-of-unique-segments-extracted"), "" + this.uniqueSegmentCount);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("ExtractSegments.png")));
        dialog.setSideBarDescription(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Extracts-all-unique-line-segments-from-a-dataset"));
        dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        final JRadioButton removeDoubleSegmentsCheckBox = dialog.addRadioButton(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Remove-doubled-segments"), "group1", this.removeDoubledSegments, null);
        final JRadioButton makeDoubleSegmentsUniqueCheckBox = dialog.addRadioButton(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Make-doubled-segments-unique"), "group1", this.makeDoubledSegmentsUnique, null);
        final JRadioButton keepAllSegmentsCheckBox = dialog.addRadioButton(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Keep-all-segments"), "group1", this.keepAllSegments, null);
        final JCheckBox mergeCheckBox = dialog.addCheckBox(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Merge-resulting-segments"), this.mergeResultingSegments);
        mergeCheckBox.setEnabled(this.removeDoubledSegments || this.makeDoubledSegmentsUnique);
        final JCheckBox keepAttributesCheckBox = dialog.addCheckBox(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Keep-attributes"), this.keepAttributes);
        keepAttributesCheckBox.setEnabled(this.keepAllSegments);
        removeDoubleSegmentsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean a = removeDoubleSegmentsCheckBox.isSelected();
                boolean b = makeDoubleSegmentsUniqueCheckBox.isSelected();
                boolean c = keepAllSegmentsCheckBox.isSelected();
                mergeCheckBox.setEnabled(a || b);
                keepAttributesCheckBox.setEnabled(c);
            }
        });
        makeDoubleSegmentsUniqueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean a = removeDoubleSegmentsCheckBox.isSelected();
                boolean b = makeDoubleSegmentsUniqueCheckBox.isSelected();
                boolean c = keepAllSegmentsCheckBox.isSelected();
                mergeCheckBox.setEnabled(a || b);
                keepAttributesCheckBox.setEnabled(c);
            }
        });
        keepAllSegmentsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean a = removeDoubleSegmentsCheckBox.isSelected();
                boolean b = makeDoubleSegmentsUniqueCheckBox.isSelected();
                boolean c = keepAllSegmentsCheckBox.isSelected();
                mergeCheckBox.setEnabled(a || b);
                keepAttributesCheckBox.setEnabled(c);
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(LAYER);
        this.layerName = layer.getName();
        this.removeDoubledSegments = dialog.getBoolean(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Remove-doubled-segments"));
        this.makeDoubledSegmentsUnique = dialog.getBoolean(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Make-doubled-segments-unique"));
        this.keepAllSegments = dialog.getBoolean(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Keep-all-segments"));
        this.mergeResultingSegments = dialog.getBoolean(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Merge-resulting-segments"));
        this.keepAttributes = dialog.getBoolean(I18N.getInstance().get("jump.plugin.edit.ExtractSegmentsPlugIn.Keep-attributes"));
    }
}

