/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FlexibleFeatureSchema;
import com.vividsolutions.jump.io.ColumnDescription;
import com.vividsolutions.jump.io.EndOfParseException;
import com.vividsolutions.jump.io.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GMLInputTemplate
extends DefaultHandler {
    boolean loaded = false;
    String collectionTag;
    String featureTag;
    String crsTag;
    ArrayList<ColumnDescription> columnDefinitions = new ArrayList();
    private XMLReader xr;
    private String tagBody = "";
    private ArrayList<String> geometryElements = new ArrayList(20);
    private String streamName;
    private boolean havecollectionTag = false;
    private boolean havefeatureTag = false;
    private boolean havegeometryElement = false;
    private boolean havecrsTag = false;
    private int columnDef_valueType = 0;
    private String columnDef_valueAttribute = "";
    private String columnDef_tagName = "";
    private int columnDef_tagType = 0;
    private String columnDef_tagAttribute = "";
    private String columnDef_tagValue = "";
    private String columnDef_columnName = "";
    private AttributeType columnDef_type = null;
    private String lastStartTag_uri;
    private String lastStartTag_name;
    private String lastStartTag_qName;
    private Attributes lastStartTag_atts;
    private static ArrayList<AttributeType> dateAttributeTypes = new ArrayList();
    private HashMap<AttributeType, Constructor> constructorCache = new HashMap();

    public GMLInputTemplate() {
        this.xr = new SAXParser();
        this.xr.setContentHandler(this);
        this.xr.setErrorHandler(this);
    }

    public String columnName(int index) throws ParseException {
        if (this.loaded) {
            return this.columnDefinitions.get((int)index).columnName;
        }
        throw new ParseException("requested columnName w/o loading the template");
    }

    public FeatureSchema toFeatureSchema() throws ParseException {
        if (!this.loaded) {
            throw new ParseException("requested toFeatureSchema w/o loading the template");
        }
        FlexibleFeatureSchema fcmd = new FlexibleFeatureSchema();
        fcmd.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        for (ColumnDescription columnDescription : this.columnDefinitions) {
            fcmd.addAttribute(columnDescription.columnName, columnDescription.getType());
        }
        return fcmd;
    }

    public boolean isGeometryElement(String tag) {
        for (int t = 0; t < this.geometryElements.size(); ++t) {
            String s = this.geometryElements.get(t);
            if (!s.equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }

    public void load(Reader r) throws ParseException, IOException {
        this.load(r, "Unknown Stream");
    }

    public void load(InputStream is) throws ParseException, IOException {
        this.load(is, "Unknown Stream");
    }

    public void load(Object o, String readerName) throws ParseException, IOException {
        block10: {
            this.streamName = readerName;
            try {
                if (o instanceof Reader) {
                    this.xr.parse(new InputSource((Reader)o));
                    break block10;
                }
                if (o instanceof InputStream) {
                    this.xr.parse(new InputSource((InputStream)o));
                    break block10;
                }
                throw new IOException("neither InputStream or Reader given");
            }
            catch (EndOfParseException endOfParseException) {
            }
            catch (SAXParseException e) {
                throw new ParseException(e.getMessage() + " (Is this really a GML file?)  Last Opened Tag: " + this.lastStartTag_qName, this.streamName + " - " + e.getPublicId() + " (" + e.getSystemId() + ") ", e.getLineNumber(), e.getColumnNumber());
            }
            catch (SAXException e) {
                throw new ParseException(e.getMessage() + "  Last Opened Tag: " + this.lastStartTag_qName, this.streamName, -1, 0);
            }
        }
        boolean bl = this.loaded = this.havecollectionTag && this.havefeatureTag && this.havegeometryElement;
        if (!this.loaded) {
            String miss = "";
            if (!this.havecollectionTag) {
                miss = miss + "Missing CollectionElement.  ";
            }
            if (!this.havefeatureTag) {
                miss = miss + "Missing FeatureElement.  ";
            }
            if (!this.havegeometryElement) {
                miss = miss + "Missing GeometryElement.  ";
            }
            throw new ParseException("Failed to load the GML Input Template.  " + miss);
        }
    }

    public String getFeatureCollectionElementName() throws ParseException {
        if (this.loaded) {
            return this.collectionTag;
        }
        throw new ParseException("requested FeatureCollectionElementName w/o loading the template");
    }

    public String getFeatureElementName() throws ParseException {
        if (this.loaded) {
            return this.featureTag;
        }
        throw new ParseException("requested FeatureCollectionElementName w/o loading the template");
    }

    public int match(String XMLtagName, Attributes xmlAtts) throws ParseException {
        if (this.loaded) {
            for (int t = 0; t < this.columnDefinitions.size(); ++t) {
                if (this.columnDefinitions.get(t).match(XMLtagName, xmlAtts) == 0) continue;
                return t;
            }
            return -1;
        }
        throw new ParseException("requested match() w/o loading the template");
    }

    public Object getColumnValue(int index, String tagBody, Attributes xmlAtts) throws ParseException {
        if (!this.loaded) {
            throw new ParseException("requested getColumnValue w/o loading the template");
        }
        ColumnDescription cd = this.columnDefinitions.get(index);
        String val = cd.valueType == 1 ? tagBody : xmlAtts.getValue(cd.valueAttribute);
        if (!dateAttributeTypes.contains(cd.type)) {
            try {
                Constructor<?> c = null;
                c = this.constructorCache.get(cd.type);
                if (c == null) {
                    c = cd.type.toJavaClass().getConstructor(String.class);
                    this.constructorCache.put(cd.type, c);
                }
                return c.newInstance(val);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (dateAttributeTypes.contains(cd.type)) {
            return val;
        }
        return null;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        try {
            this.tagBody = "";
            if (qName.equals("column")) {
                this.columnDef_tagName = "";
                this.columnDef_tagType = 0;
                this.columnDef_tagAttribute = "";
                this.columnDef_tagValue = "";
                this.columnDef_valueType = 0;
                this.columnDef_valueAttribute = "";
                this.columnDef_columnName = "";
                this.columnDef_type = null;
            }
            this.lastStartTag_uri = uri;
            this.lastStartTag_name = name;
            this.lastStartTag_qName = qName;
            this.lastStartTag_atts = atts;
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    private int lookupAttribute(Attributes atts, String att_name) {
        for (int t = 0; t < atts.getLength(); ++t) {
            if (!atts.getQName(t).equalsIgnoreCase(att_name)) continue;
            return t;
        }
        return -1;
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        try {
            if (qName.equalsIgnoreCase("JCSGMLInputTemplate")) {
                throw new EndOfParseException("Finished parsing input template");
            }
            if (qName.equalsIgnoreCase("type")) {
                String t = this.tagBody.toUpperCase();
                t = t.trim();
                try {
                    this.columnDef_type = AttributeType.toAttributeType(t);
                }
                catch (IllegalArgumentException e) {
                    this.columnDef_type = null;
                }
            }
            if (qName.equalsIgnoreCase("GeometryElement")) {
                this.tagBody = this.tagBody.trim();
                this.geometryElements.add(this.tagBody);
                this.havegeometryElement = true;
                return;
            }
            if (qName.equalsIgnoreCase("CollectionElement")) {
                this.collectionTag = this.tagBody = this.tagBody.trim();
                this.havecollectionTag = true;
                return;
            }
            if (qName.equalsIgnoreCase("FeatureElement")) {
                this.featureTag = this.tagBody = this.tagBody.trim();
                this.havefeatureTag = true;
                return;
            }
            if (qName.equalsIgnoreCase("CRSElement")) {
                this.crsTag = this.tagBody = this.tagBody.trim();
                this.havecrsTag = true;
                return;
            }
            if (qName.equalsIgnoreCase("name")) {
                this.columnDef_columnName = this.tagBody.trim();
            }
            if (qName.equalsIgnoreCase("valueelement")) {
                this.columnDef_tagType = 1;
                int attindex = this.lookupAttribute(this.lastStartTag_atts, "elementname");
                if (attindex == -1) {
                    throw new SAXException("column definition has 'valueelement' tag without 'elementname' attribute");
                }
                this.columnDef_tagName = this.lastStartTag_atts.getValue(attindex);
                attindex = this.lookupAttribute(this.lastStartTag_atts, "attributename");
                if (attindex != -1) {
                    this.columnDef_tagAttribute = this.lastStartTag_atts.getValue(attindex);
                    this.columnDef_tagType = 2;
                    attindex = this.lookupAttribute(this.lastStartTag_atts, "attributevalue");
                    if (attindex != -1) {
                        this.columnDef_tagValue = this.lastStartTag_atts.getValue(attindex);
                        this.columnDef_tagType = 3;
                    }
                }
            }
            if (qName.equalsIgnoreCase("valuelocation")) {
                int attindex = this.lookupAttribute(this.lastStartTag_atts, "position");
                if (attindex == -1) {
                    throw new SAXException("column definition has 'valuelocation' tag without 'position' attribute");
                }
                if (this.lastStartTag_atts.getValue(attindex).equalsIgnoreCase("body")) {
                    this.columnDef_valueType = 1;
                } else {
                    attindex = this.lookupAttribute(this.lastStartTag_atts, "attributename");
                    this.columnDef_valueType = 2;
                    if (attindex == -1) {
                        throw new SAXException("column definition has 'valuelocation' tag, attribute type, but no 'attributename' attribute");
                    }
                    this.columnDef_valueAttribute = this.lastStartTag_atts.getValue(attindex);
                }
            }
            if (qName.equalsIgnoreCase("column")) {
                if (this.columnDef_tagName.equalsIgnoreCase("")) {
                    throw new SAXException("column Definition didnt include tag name ('<name>...</name>')");
                }
                if (this.columnDef_tagType == 0) {
                    throw new SAXException("column Definition didnt include 'valueelement' ");
                }
                if (this.columnDef_valueType == 0) {
                    throw new SAXException("column Definition didnt have a 'valuelocation'");
                }
                ColumnDescription colDes = new ColumnDescription();
                colDes.setColumnName(this.columnDef_columnName);
                if (colDes.columnName.compareTo("GEOMETRY") == 0) {
                    throw new ParseException("Cannot have a column named GEOMETRY!");
                }
                if (this.columnDef_valueType == 2) {
                    colDes.setValueAttribute(this.columnDef_valueAttribute);
                }
                colDes.setTagName(this.columnDef_tagName);
                if (this.columnDef_tagType == 3) {
                    colDes.setTagAttribute(this.columnDef_tagAttribute, this.columnDef_tagValue);
                }
                if (this.columnDef_tagType == 2) {
                    colDes.setTagAttribute(this.columnDef_tagAttribute);
                }
                colDes.setType(this.columnDef_type);
                this.columnDefinitions.add(colDes);
            }
        }
        catch (EndOfParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String part = new String(ch, start, length);
            this.tagBody = this.tagBody + part;
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    static {
        dateAttributeTypes.add(AttributeType.DATE);
        dateAttributeTypes.add(AttributeType.TIMESTAMP);
        dateAttributeTypes.add(AttributeType.TIME);
    }
}

